/*
 * Decompiled with CFR 0.152.
 */
package JXTableEditorsAndRenderers;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class ColorCellRenderer
extends JLabel
implements TableCellRenderer {
    int iconWidth = 15;

    public ColorCellRenderer() {
        this.setOpaque(true);
    }

    public void setSize(int size) {
        this.iconWidth = size;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        if (isSelected) {
            super.setForeground(table.getSelectionForeground());
            super.setBackground(table.getSelectionBackground());
        } else {
            super.setForeground(table.getForeground());
            super.setBackground(table.getBackground());
        }
        BufferedImage icon = new BufferedImage(this.iconWidth, this.iconWidth, 2);
        Graphics2D g2d = icon.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor((Color)value);
        g2d.fillRect(0, 0, this.iconWidth, this.iconWidth);
        g2d.setColor(Color.BLACK);
        g2d.drawRect(0, 0, this.iconWidth - 1, this.iconWidth - 1);
        this.setHorizontalAlignment(0);
        this.setIcon(new ImageIcon(icon));
        return this;
    }
}

