/*
 * Decompiled with CFR 0.152.
 */
package JMWiki;

import JMWiki.JWikiModel;
import JMWiki.WikiDocument;
import JMWiki.WikiEvent;
import JMWiki.WikiPage;

public class DocumentWikiModel
extends JWikiModel {
    private WikiDocument doc;

    public DocumentWikiModel() {
        WikiDocument doc = new WikiDocument();
        this.setDocument(doc);
    }

    public DocumentWikiModel(WikiDocument doc) {
        this.doc = doc;
        this.setDocument(doc);
    }

    public void setDocument(WikiDocument doc) {
        this.doc = doc;
        if (doc == null) {
            this.doc = new WikiDocument();
        }
        this.fireEvents(new WikiEvent(8));
    }

    public WikiDocument getDocument() {
        if (this.doc == null) {
            this.doc = new WikiDocument();
        }
        return this.doc;
    }

    @Override
    public WikiPage getHomePage() {
        return this.doc.getHomePage();
    }

    @Override
    public WikiPage getPage(String id) {
        if (this.doc.contents.containsKey(id)) {
            return this.doc.contents.get(id);
        }
        return this.doc.getErrorPage();
    }

    @Override
    public boolean hasLink(String id) {
        return this.doc.pageExists(id);
    }

    @Override
    public int getPageCount() {
        return this.doc.contents.size();
    }

    @Override
    public WikiPage getErrorPage() {
        return this.doc.getErrorPage();
    }

    @Override
    public void setHomePage(WikiPage page) {
        if (this.doc.getHomePage() != page) {
            this.doc.setHomePage(page);
            this.fireEvents(new WikiEvent(9));
        }
    }

    @Override
    public void setErrorPage(WikiPage page) {
        if (this.doc.getErrorPage() != page) {
            this.doc.setErrorPage(page);
            this.fireEvents(new WikiEvent(10));
        }
    }

    @Override
    public WikiPage addPage(WikiPage page) {
        this.doc.addPage(page);
        this.fireEvents(new WikiEvent(1));
        return page;
    }

    @Override
    public WikiPage addPage(String id) {
        return this.addPage(id, null, null);
    }

    @Override
    public WikiPage addPage(String id, String title) {
        return this.addPage(id, title, null);
    }

    @Override
    public WikiPage addPage(String id, String title, String contents) {
        WikiPage page = new WikiPage(id, title, contents);
        return this.addPage(page);
    }

    @Override
    public void removePage(String id) {
        this.doc.removePage(id);
        this.fireEvents(new WikiEvent(2));
    }

    @Override
    public void clear() {
        this.doc.contents.clear();
        this.fireEvents(new WikiEvent(4));
    }

    @Override
    public String getTitle() {
        return this.doc.getTitle();
    }

    @Override
    public String getDescription() {
        return this.doc.getDescription();
    }

    @Override
    public void setTitle(String title) {
        this.doc.setTitle(title);
        this.fireEvents(new WikiEvent(5));
    }

    @Override
    public void setDescription(String description) {
        this.doc.setDescription(description);
        this.fireEvents(new WikiEvent(6));
    }
}

