/*
 * Decompiled with CFR 0.152.
 */
package JMWiki;

import JMWiki.BinaryTree;
import JMWiki.JWikiModel;
import JMWiki.WikiPage;

public class DefaultWikiModel
extends JWikiModel {
    public String title;
    public String description;
    private String defHomePageLink = "defaultHome";
    private String defHomePageTitle = "Default Main Wiki Home Page";
    private String defHomePageContents = "<html><b><u>Main Wiki Page</u></b></html><br> Welcome to the default wiki page.";
    private String defaultErrorPageLink = "defaultError";
    private String defaultErrorPageTitle = "Default Error Page";
    private String defaultErrorPageContents = "<html><b><u>Wiki Error Page</u></b></html><br> The page you requested was not found.<br> Click <a href =\"" + this.defHomePageLink + "\">here</a> to return home.";
    private WikiPage homePage = new WikiPage(this.defHomePageLink, this.defHomePageTitle, this.defHomePageContents);
    private WikiPage errorPage = new WikiPage(this.defaultErrorPageLink, this.defaultErrorPageTitle, this.defaultErrorPageContents);
    public final BinaryTree<WikiPage> contents = new BinaryTree();

    public DefaultWikiModel() {
        this.contents.put(this.defHomePageLink, this.homePage);
        this.contents.put(this.defaultErrorPageLink, this.errorPage);
    }

    @Override
    public WikiPage getHomePage() {
        return this.homePage;
    }

    @Override
    public WikiPage getPage(String linkName) {
        if (this.contents.containsKey(linkName)) {
            return this.contents.get(linkName);
        }
        return new WikiPage("", "Error", "<html>Error, link <i>" + linkName + "</i> was not found.</html>");
    }

    @Override
    public boolean hasLink(String linkName) {
        return this.contents.containsKey(linkName);
    }

    @Override
    public int getPageCount() {
        return this.contents.size();
    }

    @Override
    public WikiPage getErrorPage() {
        return this.errorPage;
    }

    private boolean isPageWalid(WikiPage page) {
        return page != null && page.id != null && page.id.length() > 0;
    }

    @Override
    public void setHomePage(WikiPage page) {
        if (this.isPageWalid(page)) {
            this.homePage = page;
            this.addPage(page);
        }
    }

    @Override
    public void setErrorPage(WikiPage page) {
        if (this.isPageWalid(page)) {
            this.errorPage = page;
            this.addPage(page);
        }
    }

    @Override
    public WikiPage addPage(WikiPage page) {
        this.contents.put(page.id, page);
        return page;
    }

    @Override
    public WikiPage addPage(String linkName) {
        WikiPage newPage = new WikiPage(linkName);
        this.contents.put(linkName, newPage);
        return newPage;
    }

    @Override
    public WikiPage addPage(String linkName, String title) {
        WikiPage newPage = new WikiPage(linkName, title, "");
        this.contents.put(linkName, newPage);
        return newPage;
    }

    @Override
    public WikiPage addPage(String linkName, String title, String contents) {
        WikiPage newPage = new WikiPage(linkName, title, contents);
        this.contents.put(linkName, newPage);
        return newPage;
    }

    @Override
    public void removePage(String linkName) {
        this.contents.remove(linkName);
    }

    @Override
    public void clear() {
        this.contents.clear();
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }
}

