/*
 * Decompiled with CFR 0.152.
 */
package JMScrollBars;

import JMConstants.Constants;
import JMScrollBars.JMScrollBar;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;

public abstract class TrackRenderer
implements Constants {
    JMScrollBar parent;
    Shape track;
    int width = 0;
    int height = 0;

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Shape getShape() {
        if (this.track != null) {
            return this.track;
        }
        if (this.parent != null && this.parent.isRounded()) {
            return new RoundRectangle2D.Double(0.0, 0.0, this.width - 1, this.height - 1, 10.0, 10.0);
        }
        return new Rectangle(0, 0, this.width - 1, this.height - 1);
    }

    void paint(Graphics2D g2d, int width, int height) {
        if (this.width != width || this.height != height) {
            this.track = null;
        }
        this.width = width;
        this.height = height;
        if (width > 0 && height > 0) {
            this.paintTrack(g2d);
            if (this.parent != null && this.parent.isShowBorder()) {
                this.paintBorder(g2d);
            }
        }
    }

    public abstract void paintTrack(Graphics2D var1);

    public abstract void paintBorder(Graphics2D var1);
}

