/*
 * Decompiled with CFR 0.152.
 */
package IconRenderers;

import IconRenderers.ControlButtonRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Window;

public class RestoreButtonIconRenderer
extends ControlButtonRenderer {
    public RestoreButtonIconRenderer() {
        this.loadUIColors("max");
    }

    @Override
    protected void initDefaultColors() {
        this.colors.setColor(2, 2, Color.lightGray);
        this.colors.setColor(2, 1, Color.black);
        this.colors.setColor(2, 0, Color.GRAY);
        this.colors.setColor(2, 5, Color.black);
        this.colors.setColor(5, 2, Color.lightGray);
        this.colors.setColor(5, 1, Color.black);
        this.colors.setColor(5, 0, Color.GRAY);
        this.colors.setColor(5, 5, Color.black);
    }

    @Override
    public void paintIcon(Graphics g, Component c, int direction, Rectangle rect, int state) {
        int size;
        int top;
        int left;
        int cHt;
        int cWd;
        int offset = 2;
        if (rect != null) {
            cWd = rect.width;
            cHt = rect.height;
            left = rect.x;
            top = rect.y;
            size = Math.min(rect.width, rect.height) - offset;
        } else {
            cHt = c.getHeight();
            cWd = c.getWidth();
            left = cWd / 2 - 5;
            top = cHt / 2 - 3;
            size = 8;
        }
        int left2 = left + offset;
        int right = left + size;
        int right2 = right + offset;
        int top2 = top - offset;
        int bot2 = top2 + size;
        Window parentFrame = this.getParentFrame(c);
        boolean isNormal = this.frameIsNormal(parentFrame);
        Color lineColor = this.colors.getActiveColor(2);
        if (lineColor == null) {
            lineColor = this.lineNoFocus;
        }
        g.setColor(lineColor);
        if (isNormal) {
            g.drawRect(left, top, size, size);
            g.drawLine(left2, top, left2, top2);
            g.drawLine(left2, top2, right2, top2);
            g.drawLine(right2, top2, right2, bot2);
            g.drawLine(right2, bot2, right, bot2);
        } else {
            left = cWd / 2 - 5;
            top = cHt / 2 - 5;
            g.drawRect(left, top, 10, 10);
        }
    }
}

