/*
 * Decompiled with CFR 0.152.
 */
package IconRenderers;

import BaseClasses.RendererColors;
import IconRenderers.TriangleArrowRenderer;
import JMConstants.Constants;
import Tools.UITools;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;

public abstract class IconRenderer
implements Constants {
    private static IconRenderer defaultArrowRenderer = new TriangleArrowRenderer();
    private static IconRenderer defaultCheckRenderer = new TriangleArrowRenderer();
    private static IconRenderer defaultRadioRenderer = new TriangleArrowRenderer();
    protected RendererColors colors = new RendererColors();
    protected final boolean isWindows = UITools.isWindows();
    protected final boolean isMacOS = UITools.isMacintosh();

    public static IconRenderer getDefaultArrowRenderer() {
        return defaultArrowRenderer;
    }

    public static void setDefaultArrowRenderer(IconRenderer renderer) {
        if (renderer != null) {
            defaultArrowRenderer = renderer;
        }
    }

    public static IconRenderer getDefaultCheckRenderer() {
        return defaultCheckRenderer;
    }

    public static void setDefaultCheckRenderer(IconRenderer renderer) {
        if (renderer != null) {
            defaultCheckRenderer = renderer;
        }
    }

    public static IconRenderer getDefaultRadioRenderer() {
        return defaultRadioRenderer;
    }

    public static void setDefaultRadioRenderer(IconRenderer renderer) {
        if (renderer != null) {
            defaultRadioRenderer = renderer;
        }
    }

    public RendererColors getColors() {
        return this.colors;
    }

    public boolean isWindows() {
        return this.isWindows;
    }

    public boolean isMacOS() {
        return this.isMacOS;
    }

    public void paintIcon(Graphics g, Component c) {
        this.paintIcon(g, c, 0, null, UITools.getState(c));
    }

    public void paintIcon(Graphics g, Component c, int direction) {
        this.paintIcon(g, c, direction, null, UITools.getState(c));
    }

    public void paintIcon(Graphics g, Component c, int direction, int state) {
        this.paintIcon(g, c, direction, null, state);
    }

    public abstract void paintIcon(Graphics var1, Component var2, int var3, Rectangle var4, int var5);
}

