/*
 * Decompiled with CFR 0.152.
 */
package IconRenderers;

import IconRenderers.MinButtonIconRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;

public class DockIconRenderer
extends MinButtonIconRenderer {
    public int dockPos = 7;

    public DockIconRenderer() {
        this.loadUIColors("dock");
    }

    public DockIconRenderer(int direction) {
        this.loadUIColors("dock");
        this.dockPos = direction;
    }

    @Override
    public void paintIcon(Graphics g, Component c, int direction, Rectangle rect, int state) {
        int top;
        int left;
        int iconHt = 10;
        int featHt = 3;
        if (rect != null) {
            left = rect.x;
            top = rect.y;
        } else {
            left = c.getWidth() / 2 - 5;
            top = c.getHeight() / 2 - 5;
        }
        Color lineColor = this.colors.getActiveColor(2);
        if (lineColor == null) {
            lineColor = Color.lightGray;
        }
        g.setColor(lineColor);
        int featTop = top + iconHt - featHt;
        switch (this.dockPos) {
            case 3: {
                g.fillRect(left + 7, top, 4, iconHt);
                break;
            }
            case 1: {
                g.fillRect(left, top, iconHt, 4);
                break;
            }
            case 5: {
                g.fillRect(left, featTop, iconHt, featHt);
                break;
            }
            default: {
                g.fillRect(left, top, 4, iconHt);
            }
        }
        g.drawRect(left, top, iconHt, iconHt);
    }
}

