/*
 * Decompiled with CFR 0.152.
 */
package IconRenderers;

import BaseClasses.BasicIcon;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;

public class BasicCheckIcon
extends BasicIcon {
    @Override
    public boolean drawIcon(Graphics2D g2d, boolean enabled, boolean selected, boolean rollOver, boolean pressed) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.setActiveColors(enabled, selected, rollOver, pressed);
        this.paintBackround(g2d, enabled, selected, rollOver, pressed);
        this.paintForeground(g2d, enabled, selected, rollOver, pressed);
        this.paintBorder(g2d, enabled, selected, rollOver, pressed);
        return true;
    }

    @Override
    public void paintForeground(Graphics2D g2d, boolean enabled, boolean selected, boolean rollOver, boolean pressed) {
        if (selected || rollOver || pressed) {
            float oSize = 30.0f;
            GeneralPath check = new GeneralPath();
            check.moveTo(9.0f / oSize * (float)this.width, 12.0f / oSize * (float)this.height);
            check.lineTo(5.0f / oSize * (float)this.width, 16.0f / oSize * (float)this.height);
            check.lineTo(13.0f / oSize * (float)this.width, 24.0f / oSize * (float)this.height);
            check.lineTo(25.0f / oSize * (float)this.width, 11.0f / oSize * (float)this.height);
            check.lineTo(25.0f / oSize * (float)this.width, 8.0f / oSize * (float)this.height);
            check.lineTo(20.0f / oSize * (float)this.width, 8.0f / oSize * (float)this.height);
            check.lineTo(13.0f / oSize * (float)this.width, 18.0f / oSize * (float)this.height);
            check.closePath();
            if (selected || pressed) {
                g2d.setColor(this.colors.getActiveColor(0));
                g2d.fill(check);
            }
            g2d.setColor(this.colors.getActiveColor(2));
            g2d.draw(check);
        }
    }

    @Override
    public void paintBackround(Graphics2D g2d, boolean enabled, boolean selected, boolean rollOver, boolean pressed) {
        Color bColor = this.colors.getActiveColor(1);
        if (bColor != null) {
            g2d.setColor(bColor);
            g2d.fillRect(0, 0, this.width, this.height);
        }
    }

    @Override
    public void paintBorder(Graphics2D g2d, boolean enabled, boolean selected, boolean rollOver, boolean pressed) {
        g2d.setColor(this.colors.getActiveColor(2));
        g2d.drawRect(0, 0, this.width - 1, this.height - 1);
    }
}

