/*
 * Decompiled with CFR 0.152.
 */
package IconListBoxes;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Serializable;
import javax.swing.Icon;

public abstract class IconListItem<T>
implements Serializable {
    public static final DataFlavor iconListItemFlavor = new DataFlavor(IconListItem.class, "Copied Sequence");
    private static final long serialVersionUID = 1L;
    private T item;

    public void setItem(T item) {
        this.item = item;
    }

    public T getItem() {
        return this.item;
    }

    public abstract String getText();

    public abstract Icon getIcon();

    public static Transferable getIconListItemTransferable(IconListItem iconListItem) {
        return new IconListItemTransferable(iconListItem);
    }

    public static class IconListItemTransferable
    implements Transferable {
        IconListItem data;

        public IconListItemTransferable(IconListItem item) {
            this.data = item;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{iconListItemFlavor, DataFlavor.stringFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            if (this.data == null) {
                return false;
            }
            return iconListItemFlavor.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (iconListItemFlavor.equals(flavor)) {
                return this.data;
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }
}

