/*
 * Decompiled with CFR 0.152.
 */
package GraphicTreeClass;

import GraphicTreeClass.GraphicTreeNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class GraphicTreeRenderer
extends DefaultTreeCellRenderer {
    private Font defFont;
    private Font boldFont;
    private Font italFont;
    private Font italBoldFont;

    public Font getDefFont() {
        return this.defFont;
    }

    public void setDefFont(Font defFont) {
        this.defFont = defFont;
    }

    public Font getBoldFont() {
        return this.boldFont;
    }

    public void setBoldFont(Font boldFont) {
        this.boldFont = boldFont;
    }

    public Font getItalFont() {
        return this.italFont;
    }

    public void setItalFont(Font italFont) {
        this.italFont = italFont;
    }

    public Font getItalBoldFont() {
        return this.italBoldFont;
    }

    public void setItalBoldFont(Font italBoldFont) {
        this.italBoldFont = italBoldFont;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        JLabel renderer = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (value instanceof GraphicTreeNode) {
            Color bColor;
            boolean dragover;
            GraphicTreeNode node = (GraphicTreeNode)value;
            ImageIcon icon = node.getIcon();
            if (icon != null) {
                renderer.setIcon(node.getIcon());
            }
            renderer.setText(node.getText());
            JTree.DropLocation dropLocation = tree.getDropLocation();
            boolean bl = dragover = dropLocation != null && dropLocation.getChildIndex() == -1 && tree.getRowForPath(dropLocation.getPath()) == row;
            if (sel || dragover) {
                Color fColor = node.getSelectedTextForeColor();
                if (fColor == null && (fColor = this.getTextSelectionColor()) == null) {
                    fColor = tree.getForeground();
                }
                renderer.setForeground(fColor);
                bColor = node.getSelectedTextBackColor();
                if (bColor == null) {
                    bColor = this.getBackgroundSelectionColor();
                }
            } else {
                Color fColor = node.getTextForeColor();
                if (fColor == null && (fColor = this.getTextNonSelectionColor()) == null) {
                    fColor = tree.getForeground();
                }
                renderer.setForeground(fColor);
                bColor = node.getTextBackColor();
            }
            if (bColor == null) {
                this.setOpaque(false);
            } else {
                renderer.setBackground(bColor);
                this.setOpaque(true);
            }
            if (node.textBold) {
                if (!node.textItalics) {
                    renderer.setFont(this.getBoldFont());
                } else {
                    renderer.setFont(this.getItalBoldFont());
                }
            } else if (node.textItalics) {
                renderer.setFont(this.getItalFont());
            } else {
                renderer.setFont(this.getDefFont());
            }
        }
        return renderer;
    }
}

