/*
 * Decompiled with CFR 0.152.
 */
package GenbankFileReader;

import GenbankFileReader.Qualifier;
import GenbankFileReader.Reference;

public class Header {
    public String dataType = "DNA";
    public String version = "";
    public boolean seqFree = false;
    public boolean circular = false;
    public String name = "";
    public String organism = "";
    public String source = "";
    public String accession = "";
    public String date = "";
    public String notes;
    public Qualifier[] qualifiers;
    public Reference[] references;

    public String toGBString(int seqLen) {
        StringBuilder retVal = new StringBuilder("LOCUS        " + this.name + "        " + seqLen + " bp       " + this.dataType + "        " + (this.circular ? "circular" : "linear") + "      " + this.date + "\nACCESSION    " + this.accession + "\nSOURCE       " + this.source + "\nORGANISM     " + this.organism);
        if (this.qualifiers != null && this.qualifiers.length > 0) {
            for (Qualifier qualifier : this.qualifiers) {
                retVal.append("\n").append(qualifier.toGBString());
            }
        }
        if (this.references != null && this.references.length > 0) {
            for (int x = 0; x < this.references.length; ++x) {
                retVal.append("\n").append(this.references[x].toGBString(x));
            }
        }
        return retVal.toString();
    }
}

