/*
 * Decompiled with CFR 0.152.
 */
package Frame_DD_File_Handler;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.TransferHandler;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;

class TextTransferHandler
extends TransferHandler {
    Position p0 = null;
    Position p1 = null;

    TextTransferHandler() {
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        String data;
        if (!this.canImport(support)) {
            return false;
        }
        try {
            data = (String)support.getTransferable().getTransferData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        JTextField tc = (JTextField)support.getComponent();
        tc.replaceSelection(data);
        return true;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        JTextField source = (JTextField)c;
        int start = source.getSelectionStart();
        int end = source.getSelectionEnd();
        Document doc = source.getDocument();
        if (start == end) {
            return null;
        }
        try {
            this.p0 = doc.createPosition(start);
            this.p1 = doc.createPosition(end);
        }
        catch (BadLocationException e) {
            System.out.println("Can't create position - unable to remove text from source.");
        }
        String data = source.getSelectedText();
        return new StringSelection(data);
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    protected void exportDone(JComponent c, Transferable data, int action) {
        if (action != 2) {
            return;
        }
        if (this.p0 != null && this.p1 != null && this.p0.getOffset() != this.p1.getOffset()) {
            try {
                JTextComponent tc = (JTextComponent)c;
                tc.getDocument().remove(this.p0.getOffset(), this.p1.getOffset() - this.p0.getOffset());
            }
            catch (BadLocationException e) {
                System.out.println("Can't remove text from source.");
            }
        }
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        return support.isDataFlavorSupported(DataFlavor.stringFlavor);
    }
}

