/*
 * Decompiled with CFR 0.152.
 */
package Frame_DD_File_Handler;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;

public abstract class TextBoxFileTransferHandler
extends TransferHandler {
    private static final int NONE = 0;
    private static final int FILE = 1;
    private static final int TEXT = 2;
    Position p0 = null;
    Position p1 = null;
    private int dataType = 0;

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        DataFlavor[] dropFlavors = support.getDataFlavors();
        if (dropFlavors.length == 0) {
            return false;
        }
        DataFlavor dropFlavor = support.getDataFlavors()[0];
        if (dropFlavor.equals(DataFlavor.javaFileListFlavor)) {
            if (!support.isDrop()) {
                return false;
            }
            support.setShowDropLocation(true);
            this.dataType = 1;
            return true;
        }
        if (support.getComponent() instanceof JTextComponent) {
            try {
                String text = (String)support.getTransferable().getTransferData(DataFlavor.stringFlavor);
                JTextComponent tc = (JTextComponent)support.getComponent();
                tc.replaceSelection(text);
                this.dataType = 2;
                return true;
            }
            catch (UnsupportedFlavorException | IOException ex) {
                this.dataType = 0;
                return false;
            }
        }
        this.dataType = 0;
        return false;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        if (c instanceof JTextComponent) {
            JTextComponent source = (JTextComponent)c;
            int start = source.getSelectionStart();
            int end = source.getSelectionEnd();
            Document doc = source.getDocument();
            if (start == end) {
                return null;
            }
            try {
                this.p0 = doc.createPosition(start);
                this.p1 = doc.createPosition(end);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            String data = source.getSelectedText();
            return new StringSelection(data);
        }
        return null;
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
        if (source instanceof JTextComponent) {
            if (action != 2) {
                return;
            }
            if (this.p0 != null && this.p1 != null && this.p0.getOffset() != this.p1.getOffset()) {
                try {
                    JTextComponent tc = (JTextComponent)source;
                    tc.getDocument().remove(this.p0.getOffset(), this.p1.getOffset() - this.p0.getOffset());
                }
                catch (BadLocationException e) {
                    System.out.println("Can't remove text from source.");
                }
            }
        }
    }

    @Override
    public int getSourceActions(JComponent c) {
        return this.dataType == 1 ? 2 : 3;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (!this.canImport(support)) {
            return false;
        }
        DataFlavor[] df = support.getTransferable().getTransferDataFlavors();
        if (df[0].equals(DataFlavor.javaFileListFlavor)) {
            try {
                List fileList = (List)support.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                this.droppedFiles(fileList, support.getDropLocation().getDropPoint().x, support.getDropLocation().getDropPoint().y);
                return true;
            }
            catch (UnsupportedFlavorException | IOException exception) {
                // empty catch block
            }
        }
        return false;
    }

    public abstract void droppedFiles(List<File> var1, int var2, int var3);

    public static String getExtension(File file) {
        return TextBoxFileTransferHandler.getExtension(file.getName());
    }

    public static String getExtension(String filename) {
        int lestPer = filename.lastIndexOf(".");
        if (lestPer > -1) {
            return filename.substring(lestPer);
        }
        return "";
    }
}

