/*
 * Decompiled with CFR 0.152.
 */
package FileReaders;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import javax.swing.filechooser.FileNameExtensionFilter;

public abstract class LoadedLibrary {
    String version = "0.0.0";
    String title = "Data File";
    String loadedFilePath = "";
    boolean loaded = false;
    public FileTime lastModTime;

    public void setVersion(String version) {
        if (version != null) {
            this.version = version;
        }
    }

    public String getVersion() {
        return this.version;
    }

    public abstract boolean isExternal();

    public abstract boolean loadFileContents(String var1);

    public abstract void init();

    public String[] getFileData(File file) {
        return this.getFileData(file.getAbsolutePath());
    }

    public abstract String[] getFileData(String var1);

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        if (title != null) {
            this.title = title;
        }
    }

    public String getLoadedFilePath() {
        return this.loadedFilePath;
    }

    public void setName(String name) {
        if (name != null) {
            this.title = name;
        }
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public LoadedLibrary() {
        this.init();
    }

    public LoadedLibrary(String filepath) {
        this.init();
        this.open(filepath);
    }

    public void open(String filePath) {
        this.loaded = this.loadFileContents(filePath);
        if (this.loaded) {
            this.loadedFilePath = filePath;
            if (this.isExternal()) {
                this.lastModTime = this.getFileLastModTime();
            }
        }
    }

    public void update() {
        if (this.isExternal() && this.loadedFilePath != null && this.loadedFilePath.length() > 0 && !this.isUpToDate()) {
            this.open(this.loadedFilePath);
        }
    }

    public boolean isUpToDate() {
        if (!this.isExternal()) {
            return this.loaded;
        }
        FileTime modTime = this.getFileLastModTime();
        return modTime != null && modTime.equals(this.lastModTime);
    }

    FileTime getFileLastModTime() {
        if (this.loadedFilePath == null || this.loadedFilePath.length() == 0) {
            return null;
        }
        File loadedFile = new File(this.loadedFilePath);
        if (!loadedFile.exists()) {
            return null;
        }
        try {
            Path filePath = Paths.get(loadedFile.getAbsolutePath(), new String[0]);
            BasicFileAttributes attr = Files.readAttributes(filePath, BasicFileAttributes.class, new LinkOption[0]);
            FileTime modTime = attr.lastModifiedTime();
            return modTime;
        }
        catch (IOException ex) {
            return null;
        }
    }

    static FileNameExtensionFilter generateFilter(String BaseText, String ... extensions) {
        String finalString = BaseText + " (*" + LoadedLibrary.formatExtension(extensions[0]);
        for (int x = 1; x < extensions.length; ++x) {
            finalString = finalString + ", *." + LoadedLibrary.formatExtension(extensions[x]);
        }
        finalString = finalString + ")";
        return new FileNameExtensionFilter(finalString, extensions);
    }

    private static String formatExtension(String ext) {
        return ext.startsWith(".") ? ext : "." + ext;
    }

    private static String formatExtension2(String ext) {
        return !ext.startsWith(".") ? ext : "." + ext.substring(1);
    }
}

