/*
 * Decompiled with CFR 0.152.
 */
package FileReaders;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

class FileWatcher {
    private final Path pathToWatch;
    private final FileChangeListener listener;
    private final long debounceMillis;
    private volatile boolean running = false;
    private Thread watcherThread;
    private ScheduledExecutorService scheduler;
    private ScheduledFuture<?> debounceFuture;

    public FileWatcher(Path fileToWatch, FileChangeListener listener, long debounceMillis) {
        this.pathToWatch = fileToWatch;
        this.listener = listener;
        this.debounceMillis = debounceMillis;
    }

    public void start() {
        if (this.running) {
            return;
        }
        this.running = true;
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.watcherThread = new Thread(() -> {
            try (WatchService watchService = FileSystems.getDefault().newWatchService();){
                Path parentDir = this.pathToWatch.getParent();
                if (parentDir == null) {
                    throw new IllegalArgumentException("File must have a parent directory");
                }
                parentDir.register(watchService, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
                while (this.running) {
                    WatchKey key;
                    try {
                        key = watchService.poll(100L, TimeUnit.MILLISECONDS);
                        if (key == null) {
                            continue;
                        }
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    for (WatchEvent<?> event : key.pollEvents()) {
                        Path changed = (Path)event.context();
                        if (changed == null || !parentDir.resolve(changed).equals(this.pathToWatch)) continue;
                        this.debounceNotify();
                    }
                    key.reset();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        this.watcherThread.setDaemon(true);
        this.watcherThread.start();
    }

    private void debounceNotify() {
        if (this.debounceFuture != null && !this.debounceFuture.isDone()) {
            this.debounceFuture.cancel(false);
        }
        this.debounceFuture = this.scheduler.schedule(() -> this.listener.onFileChange(this.pathToWatch), this.debounceMillis, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        this.running = false;
        if (this.watcherThread != null) {
            this.watcherThread.interrupt();
        }
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
        }
    }

    public static interface FileChangeListener {
        public void onFileChange(Path var1);
    }
}

