/*
 * Decompiled with CFR 0.152.
 */
package FileDialogs;

import java.awt.Component;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;

public class FileDialog {
    public static JFileChooser Dlg = FileDialog.getInitializedJChooser();

    private static JFileChooser getInitializedJChooser() {
        JFileChooser Dlg2 = new JFileChooser();
        Dlg2.setFileView(new FileView(){

            @Override
            public Icon getIcon(File f) {
                return FileSystemView.getFileSystemView().getSystemIcon(f);
            }
        });
        return Dlg2;
    }

    public static FileNameExtensionFilter GenerateFilter(String BaseText, String ... extensions) {
        String finalString = BaseText + (extensions[0].toLowerCase().startsWith(".") ? " (*" + extensions[0] : " (*." + extensions[0]);
        for (int x = 1; x < extensions.length; ++x) {
            finalString = finalString + (extensions[x].toLowerCase().startsWith(".") ? ", *" + extensions[x] : ", *." + extensions[x]);
        }
        finalString = finalString + ")";
        return new FileNameExtensionFilter(finalString, extensions);
    }

    public static void setFilter(JFileChooser dialog, FileNameExtensionFilter filter) {
        dialog.setFileFilter(filter);
    }

    public static void addFilter(JFileChooser dialog, FileNameExtensionFilter filter) {
        dialog.addChoosableFileFilter(filter);
    }

    public static boolean showOpen(JFileChooser dialog, Component parent) {
        return dialog.showOpenDialog(parent) == 0;
    }

    public static boolean showOpen(Component parent) {
        return Dlg.showOpenDialog(parent) == 0;
    }

    public static boolean showSave(JFileChooser dialog, Component parent) {
        return dialog.showSaveDialog(parent) == 0;
    }

    public static boolean showSave(Component parent) {
        return Dlg.showSaveDialog(parent) == 0;
    }

    public static void initDefaultDialogs() {
        Dlg.setFileFilter(FileDialog.GenerateFilter("All Files", "*"));
    }
}

