/*
 * Decompiled with CFR 0.152.
 */
package FileChooserDialogs;

import FileChooserDialogs.FileTableModel;
import FileChooserDialogs.FileTreeCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

class FileBrowser {
    public static final String APP_TITLE = "FileBro";
    private Desktop desktop;
    private FileSystemView fileSystemView;
    private File currentFile;
    private JPanel gui;
    private JTree tree;
    private DefaultTreeModel treeModel;
    private JTable table;
    private JProgressBar progressBar;
    private FileTableModel fileTableModel;
    private ListSelectionListener listSelectionListener;
    private boolean cellSizesSet = false;
    private int rowIconPadding = 6;
    private JButton openFile;
    private JButton printFile;
    private JButton editFile;
    private JLabel fileName;
    private JTextField path;
    private JLabel date;
    private JLabel size;
    private JCheckBox readable;
    private JCheckBox writable;
    private JCheckBox executable;
    private JRadioButton isDirectory;
    private JRadioButton isFile;
    private JPanel newFilePanel;
    private JRadioButton newTypeFile;
    private JTextField name;

    FileBrowser() {
    }

    public Container getGui() {
        if (this.gui == null) {
            int ii;
            File[] roots;
            this.gui = new JPanel(new BorderLayout(3, 3));
            this.gui.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.fileSystemView = FileSystemView.getFileSystemView();
            this.desktop = Desktop.getDesktop();
            JPanel detailView = new JPanel(new BorderLayout(3, 3));
            this.table = new JTable();
            this.table.setSelectionMode(0);
            this.table.setAutoCreateRowSorter(true);
            this.table.setShowVerticalLines(false);
            this.listSelectionListener = new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent lse) {
                    int row = FileBrowser.this.table.getSelectionModel().getLeadSelectionIndex();
                    FileBrowser.this.setFileDetails(((FileTableModel)FileBrowser.this.table.getModel()).getFile(row));
                }
            };
            this.table.getSelectionModel().addListSelectionListener(this.listSelectionListener);
            JScrollPane tableScroll = new JScrollPane(this.table);
            Dimension d = tableScroll.getPreferredSize();
            tableScroll.setPreferredSize(new Dimension((int)d.getWidth(), (int)d.getHeight() / 2));
            detailView.add((Component)tableScroll, "Center");
            DefaultMutableTreeNode root = new DefaultMutableTreeNode();
            this.treeModel = new DefaultTreeModel(root);
            TreeSelectionListener treeSelectionListener = new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent tse) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)tse.getPath().getLastPathComponent();
                    FileBrowser.this.showChildren(node);
                    FileBrowser.this.setFileDetails((File)node.getUserObject());
                }
            };
            for (File fileSystemRoot : roots = this.fileSystemView.getRoots()) {
                File[] files;
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(fileSystemRoot);
                root.add(node);
                for (File file : files = this.fileSystemView.getFiles(fileSystemRoot, true)) {
                    if (!file.isDirectory()) continue;
                    node.add(new DefaultMutableTreeNode(file));
                }
            }
            this.tree = new JTree(this.treeModel);
            this.tree.setRootVisible(false);
            this.tree.addTreeSelectionListener(treeSelectionListener);
            this.tree.setCellRenderer(new FileTreeCellRenderer());
            this.tree.expandRow(0);
            JScrollPane treeScroll = new JScrollPane(this.tree);
            this.tree.setVisibleRowCount(15);
            Dimension preferredSize = treeScroll.getPreferredSize();
            Dimension widePreferred = new Dimension(200, (int)preferredSize.getHeight());
            treeScroll.setPreferredSize(widePreferred);
            JPanel fileMainDetails = new JPanel(new BorderLayout(4, 2));
            fileMainDetails.setBorder(new EmptyBorder(0, 6, 0, 6));
            JPanel fileDetailsLabels = new JPanel(new GridLayout(0, 1, 2, 2));
            fileMainDetails.add((Component)fileDetailsLabels, "West");
            JPanel fileDetailsValues = new JPanel(new GridLayout(0, 1, 2, 2));
            fileMainDetails.add((Component)fileDetailsValues, "Center");
            fileDetailsLabels.add(new JLabel("File", 11));
            this.fileName = new JLabel();
            fileDetailsValues.add(this.fileName);
            fileDetailsLabels.add(new JLabel("Path/name", 11));
            this.path = new JTextField(5);
            this.path.setEditable(false);
            fileDetailsValues.add(this.path);
            fileDetailsLabels.add(new JLabel("Last Modified", 11));
            this.date = new JLabel();
            fileDetailsValues.add(this.date);
            fileDetailsLabels.add(new JLabel("File size", 11));
            this.size = new JLabel();
            fileDetailsValues.add(this.size);
            fileDetailsLabels.add(new JLabel("Type", 11));
            JPanel flags = new JPanel(new FlowLayout(3, 4, 0));
            this.isDirectory = new JRadioButton("Directory");
            flags.add(this.isDirectory);
            this.isFile = new JRadioButton("File");
            flags.add(this.isFile);
            fileDetailsValues.add(flags);
            JToolBar toolBar = new JToolBar();
            toolBar.setFloatable(false);
            JButton locateFile = new JButton("Locate");
            locateFile.setMnemonic('l');
            locateFile.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    try {
                        FileBrowser.this.desktop.open(FileBrowser.this.currentFile.getParentFile());
                    }
                    catch (Throwable t) {
                        FileBrowser.this.showThrowable(t);
                    }
                    FileBrowser.this.gui.repaint();
                }
            });
            toolBar.add(locateFile);
            this.openFile = new JButton("Open");
            this.openFile.setMnemonic('o');
            this.openFile.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    try {
                        FileBrowser.this.desktop.open(FileBrowser.this.currentFile);
                    }
                    catch (Throwable t) {
                        FileBrowser.this.showThrowable(t);
                    }
                    FileBrowser.this.gui.repaint();
                }
            });
            toolBar.add(this.openFile);
            this.editFile = new JButton("Edit");
            this.editFile.setMnemonic('e');
            this.editFile.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    try {
                        FileBrowser.this.desktop.edit(FileBrowser.this.currentFile);
                    }
                    catch (Throwable t) {
                        FileBrowser.this.showThrowable(t);
                    }
                }
            });
            toolBar.add(this.editFile);
            this.printFile = new JButton("Print");
            this.printFile.setMnemonic('p');
            this.printFile.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    try {
                        FileBrowser.this.desktop.print(FileBrowser.this.currentFile);
                    }
                    catch (Throwable t) {
                        FileBrowser.this.showThrowable(t);
                    }
                }
            });
            toolBar.add(this.printFile);
            this.openFile.setEnabled(this.desktop.isSupported(Desktop.Action.OPEN));
            this.editFile.setEnabled(this.desktop.isSupported(Desktop.Action.EDIT));
            this.printFile.setEnabled(this.desktop.isSupported(Desktop.Action.PRINT));
            flags.add(new JLabel("::  Flags"));
            this.readable = new JCheckBox("Read  ");
            this.readable.setMnemonic('a');
            flags.add(this.readable);
            this.writable = new JCheckBox("Write  ");
            this.writable.setMnemonic('w');
            flags.add(this.writable);
            this.executable = new JCheckBox("Execute");
            this.executable.setMnemonic('x');
            flags.add(this.executable);
            int count = fileDetailsLabels.getComponentCount();
            for (ii = 0; ii < count; ++ii) {
                fileDetailsLabels.getComponent(ii).setEnabled(false);
            }
            count = flags.getComponentCount();
            for (ii = 0; ii < count; ++ii) {
                flags.getComponent(ii).setEnabled(false);
            }
            JPanel fileView = new JPanel(new BorderLayout(3, 3));
            fileView.add((Component)toolBar, "North");
            fileView.add((Component)fileMainDetails, "Center");
            detailView.add((Component)fileView, "South");
            JSplitPane splitPane = new JSplitPane(1, treeScroll, detailView);
            this.gui.add((Component)splitPane, "Center");
            JPanel simpleOutput = new JPanel(new BorderLayout(3, 3));
            this.progressBar = new JProgressBar();
            simpleOutput.add((Component)this.progressBar, "East");
            this.progressBar.setVisible(false);
            this.gui.add((Component)simpleOutput, "South");
        }
        return this.gui;
    }

    public void showRootFile() {
        this.tree.setSelectionInterval(0, 0);
    }

    private TreePath findTreePath(File find) {
        for (int ii = 0; ii < this.tree.getRowCount(); ++ii) {
            TreePath treePath = this.tree.getPathForRow(ii);
            Object object = treePath.getLastPathComponent();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)object;
            File nodeFile = (File)node.getUserObject();
            if (nodeFile != find) continue;
            return treePath;
        }
        return null;
    }

    private void showErrorMessage(String errorMessage, String errorTitle) {
        JOptionPane.showMessageDialog(this.gui, errorMessage, errorTitle, 0);
    }

    private void showThrowable(Throwable t) {
        t.printStackTrace();
        JOptionPane.showMessageDialog(this.gui, t.toString(), t.getMessage(), 0);
        this.gui.repaint();
    }

    private void setTableData(final File[] files) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (FileBrowser.this.fileTableModel == null) {
                    FileBrowser.this.fileTableModel = new FileTableModel();
                    FileBrowser.this.table.setModel(FileBrowser.this.fileTableModel);
                }
                FileBrowser.this.table.getSelectionModel().removeListSelectionListener(FileBrowser.this.listSelectionListener);
                FileBrowser.this.fileTableModel.setFiles(files);
                FileBrowser.this.table.getSelectionModel().addListSelectionListener(FileBrowser.this.listSelectionListener);
                if (!FileBrowser.this.cellSizesSet) {
                    Icon icon = FileBrowser.this.fileSystemView.getSystemIcon(files[0]);
                    FileBrowser.this.table.setRowHeight(icon.getIconHeight() + FileBrowser.this.rowIconPadding);
                    FileBrowser.this.setColumnWidth(0, -1);
                    FileBrowser.this.setColumnWidth(3, 60);
                    FileBrowser.this.table.getColumnModel().getColumn(3).setMaxWidth(120);
                    FileBrowser.this.setColumnWidth(4, -1);
                    FileBrowser.this.setColumnWidth(5, -1);
                    FileBrowser.this.setColumnWidth(6, -1);
                    FileBrowser.this.setColumnWidth(7, -1);
                    FileBrowser.this.setColumnWidth(8, -1);
                    FileBrowser.this.setColumnWidth(9, -1);
                    FileBrowser.this.cellSizesSet = true;
                }
            }
        });
    }

    private void setColumnWidth(int column, int width) {
        TableColumn tableColumn = this.table.getColumnModel().getColumn(column);
        if (width < 0) {
            JLabel label = new JLabel((String)tableColumn.getHeaderValue());
            Dimension preferred = label.getPreferredSize();
            width = (int)preferred.getWidth() + 14;
        }
        tableColumn.setPreferredWidth(width);
        tableColumn.setMaxWidth(width);
        tableColumn.setMinWidth(width);
    }

    private void showChildren(final DefaultMutableTreeNode node) {
        this.tree.setEnabled(false);
        this.progressBar.setVisible(true);
        this.progressBar.setIndeterminate(true);
        SwingWorker<Void, File> worker = new SwingWorker<Void, File>(){

            @Override
            public Void doInBackground() {
                File file = (File)node.getUserObject();
                if (file.isDirectory()) {
                    File[] files = FileBrowser.this.fileSystemView.getFiles(file, true);
                    if (node.isLeaf()) {
                        for (File child : files) {
                            if (!child.isDirectory()) continue;
                            this.publish(child);
                        }
                    }
                    FileBrowser.this.setTableData(files);
                }
                return null;
            }

            @Override
            protected void process(List<File> chunks) {
                for (File child : chunks) {
                    node.add(new DefaultMutableTreeNode(child));
                }
            }

            @Override
            protected void done() {
                FileBrowser.this.progressBar.setIndeterminate(false);
                FileBrowser.this.progressBar.setVisible(false);
                FileBrowser.this.tree.setEnabled(true);
            }
        };
        worker.execute();
    }

    private void setFileDetails(File file) {
        this.currentFile = file;
        Icon icon = this.fileSystemView.getSystemIcon(file);
        this.fileName.setIcon(icon);
        this.fileName.setText(this.fileSystemView.getSystemDisplayName(file));
        this.path.setText(file.getPath());
        this.date.setText(new Date(file.lastModified()).toString());
        this.size.setText(file.length() + " bytes");
        this.readable.setSelected(file.canRead());
        this.writable.setSelected(file.canWrite());
        this.executable.setSelected(file.canExecute());
        this.isDirectory.setSelected(file.isDirectory());
        this.isFile.setSelected(file.isFile());
        JFrame f = (JFrame)this.gui.getTopLevelAncestor();
        if (f != null) {
            f.setTitle("FileBro :: " + this.fileSystemView.getSystemDisplayName(file));
        }
        this.gui.repaint();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                JFrame f = new JFrame(FileBrowser.APP_TITLE);
                f.setDefaultCloseOperation(3);
                FileBrowser FileBrowser2 = new FileBrowser();
                f.setContentPane(FileBrowser2.getGui());
                try {
                    URL urlBig = FileBrowser2.getClass().getResource("fb-icon-32x32.png");
                    URL urlSmall = FileBrowser2.getClass().getResource("fb-icon-16x16.png");
                    ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
                    images.add(ImageIO.read(urlBig));
                    images.add(ImageIO.read(urlSmall));
                    f.setIconImages(images);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                f.pack();
                f.setLocationByPlatform(true);
                f.setMinimumSize(f.getSize());
                f.setVisible(true);
                FileBrowser2.showRootFile();
            }
        });
    }
}

