/*
 * Decompiled with CFR 0.152.
 */
package FastQReader;

import FastQReader.FastQEntry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Scanner;

public class FastQFile {
    public int maxX = 0;
    public int maxY = 0;
    public String filePath = "";
    public FastQEntry[] entries;
    private static String error = "No file loaded";

    public static String getErrorMessage() {
        return error;
    }

    public static FastQFile getFastQFileContents(File file) {
        return FastQFile.getFastQFileContents1(file);
    }

    public static FastQFile getFastQFileContents(File file, int version) {
        switch (version) {
            case 3: {
                return FastQFile.getFastQFileContents3(file);
            }
            case 2: {
                return FastQFile.getFastQFileContents2(file);
            }
        }
        return FastQFile.getFastQFileContents1(file);
    }

    public static FastQFile getFastQFileContents1(File file) {
        String fileContent;
        ArrayList<FastQEntry> entries = new ArrayList<FastQEntry>();
        try {
            fileContent = new String(Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0])));
        }
        catch (IOException ex) {
            error = ex.getMessage();
            return null;
        }
        String[] lines = fileContent.split("\n");
        for (int x = 0; x < lines.length; x += 4) {
            FastQEntry entry = new FastQEntry(lines[x], lines[x + 1], lines[x + 3]);
            entries.add(entry);
        }
        fileContent = "";
        if (entries.isEmpty()) {
            error = "No valid FastQ entries were found";
            return null;
        }
        FastQFile outFile = new FastQFile();
        outFile.filePath = file.getAbsolutePath();
        outFile.entries = new FastQEntry[entries.size()];
        for (int index = 0; index < entries.size(); ++index) {
            outFile.entries[index] = (FastQEntry)entries.get(index);
            if (outFile.maxX < outFile.entries[index].getX()) {
                outFile.maxX = outFile.entries[index].x;
            }
            if (outFile.maxY >= outFile.entries[index].getY()) continue;
            outFile.maxY = outFile.entries[index].y;
        }
        entries.clear();
        System.gc();
        return outFile;
    }

    public static FastQFile getFastQFileContents2(File file) {
        ArrayList<FastQEntry> entries = new ArrayList<FastQEntry>();
        int maxX = 0;
        int maxY = 0;
        try {
            String scoreLine;
            String plusLine;
            String sequenceLine;
            String infoLine;
            BufferedReader reader = new BufferedReader(new FileReader(file));
            while ((infoLine = reader.readLine()) != null && infoLine.startsWith("@") && (sequenceLine = reader.readLine()) != null && (plusLine = reader.readLine()) != null && plusLine.equals("+") && (scoreLine = reader.readLine()) != null) {
                FastQEntry entry = new FastQEntry(infoLine, sequenceLine, scoreLine);
                entries.add(entry);
                if (maxX < entry.x) {
                    maxX = entry.x;
                }
                if (maxY >= entry.y) continue;
                maxY = entry.y;
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (entries.isEmpty()) {
            error = "No valid FastQ entries were found";
            return null;
        }
        FastQFile outFile = new FastQFile();
        outFile.filePath = file.getAbsolutePath();
        outFile.entries = new FastQEntry[entries.size()];
        outFile.maxX = maxX;
        outFile.maxY = maxY;
        for (int index = 0; index < entries.size(); ++index) {
            outFile.entries[index] = (FastQEntry)entries.get(index);
        }
        entries.clear();
        System.gc();
        return outFile;
    }

    public static FastQFile getFastQFileContents3(File file) {
        ArrayList<FastQEntry> entries = new ArrayList<FastQEntry>();
        try {
            String scoreLine;
            String plusLine;
            String sequenceLine;
            String infoLine;
            Scanner scanner = new Scanner(file);
            while (scanner.hasNextLine() && (infoLine = scanner.nextLine()) != null && infoLine.startsWith("@") && scanner.hasNextLine() && (sequenceLine = scanner.nextLine()) != null && scanner.hasNextLine() && (plusLine = scanner.nextLine()) != null && plusLine.equals("+") && scanner.hasNextLine() && (scoreLine = scanner.nextLine()) != null) {
                FastQEntry entry = new FastQEntry(infoLine, sequenceLine, scoreLine);
                entries.add(entry);
            }
            scanner.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (entries.isEmpty()) {
            error = "No valid FastQ entries were found";
            return null;
        }
        FastQFile outFile = new FastQFile();
        outFile.filePath = file.getAbsolutePath();
        outFile.entries = new FastQEntry[entries.size()];
        for (int index = 0; index < entries.size(); ++index) {
            outFile.entries[index] = (FastQEntry)entries.get(index);
            if (outFile.maxX < outFile.entries[index].getX()) {
                outFile.maxX = outFile.entries[index].x;
            }
            if (outFile.maxY >= outFile.entries[index].getY()) continue;
            outFile.maxY = outFile.entries[index].y;
        }
        entries.clear();
        System.gc();
        return outFile;
    }

    public boolean loadFastQFile(File file) {
        String fileContent;
        ArrayList<FastQEntry> entries = new ArrayList<FastQEntry>();
        try {
            fileContent = new String(Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0])));
        }
        catch (IOException ex) {
            error = ex.getMessage();
            return false;
        }
        String[] lines = fileContent.split("\n");
        for (int x = 0; x < lines.length; x += 4) {
            FastQEntry entry = this.genFastQEntry(lines[x], lines[x + 1], lines[x + 3]);
            entries.add(entry);
        }
        fileContent = "";
        if (entries.isEmpty()) {
            error = "No valid FastQ entries were found";
            return false;
        }
        FastQFile outFile = new FastQFile();
        outFile.filePath = file.getAbsolutePath();
        outFile.entries = new FastQEntry[entries.size()];
        for (int index = 0; index < entries.size(); ++index) {
            outFile.entries[index] = (FastQEntry)entries.get(index);
            if (outFile.maxX < outFile.entries[index].getX()) {
                outFile.maxX = outFile.entries[index].x;
            }
            if (outFile.maxY >= outFile.entries[index].getY()) continue;
            outFile.maxY = outFile.entries[index].y;
        }
        entries.clear();
        return true;
    }

    public FastQEntry genFastQEntry(String infoLine, String sequenceLine, String scoreLine) {
        FastQEntry entry = new FastQEntry(infoLine, sequenceLine, scoreLine);
        return entry;
    }

    public static String convertQualityToConfidence(FastQEntry entry) {
        return FastQFile.convertQualityToConfidence(entry.quality);
    }

    public static String convertQualityToConfidence(String qualityString) {
        StringBuilder retVal = new StringBuilder();
        for (int x = 0; x < qualityString.length(); ++x) {
        }
        return retVal.toString();
    }

    private static float ConvertValue(int Value, int InputMin, int InputMax, int OutputMin, int OutputMax) {
        return (float)(Value - InputMin) / (float)(InputMax - InputMin) * (float)(OutputMax - OutputMin) + (float)OutputMin;
    }
}

