/*
 * Decompiled with CFR 0.152.
 */
package Encoders;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;

public class mHuffmanStandalone {
    private static final byte[] BITMASK = new byte[]{1, 2, 4, 8, 16, 32, 64, -128};
    private static int BUFFERSIZE = 250;
    private static EncoderListener listener = null;
    private static boolean success = false;
    private static final int DEFNODECOUNT = 256;
    private static int treeHeaderLen = 0;
    private static byte CheckSum = 0;
    private static int inLength = 0;
    private static Node RootNode = new Node();
    private static int LastNodeIndex;
    private static short LeafCount;
    private static Node[] Nodes;
    private static Node[] readNodes;
    private static int EncodedBits;
    private static int EncodedBytes;
    private static char[] dataChars;
    private static BitString bitString;
    private static BitString OutBuffer;
    private static String lastError;
    static float length;
    static float value;
    private static int prog;

    public static String getError() {
        return lastError;
    }

    public static void setListener(EncoderListener huffmanListener) {
        listener = huffmanListener;
    }

    public static byte[] encode(String data) {
        mHuffmanStandalone.Reset();
        dataChars = data.toCharArray();
        byte[] outVal = mHuffmanStandalone.encodeString();
        if (listener != null) {
            listener.encodeCompleted(success);
        }
        return outVal;
    }

    public static byte[] encode(char[] data) {
        mHuffmanStandalone.Reset();
        dataChars = data;
        byte[] outVal = mHuffmanStandalone.encodeString();
        if (listener != null) {
            listener.encodeCompleted(success);
        }
        return outVal;
    }

    public static byte[] encode(File file) {
        char[] chars = mHuffmanStandalone.getFileChars(file);
        if (chars == null) {
            if (listener != null) {
                listener.encodeCompleted(false);
            }
            return null;
        }
        byte[] outVal = mHuffmanStandalone.encode(chars);
        return outVal;
    }

    public static String decodeToString(byte[] data) {
        byte[] outBytes = mHuffmanStandalone.decode(data);
        return new String(outBytes, StandardCharsets.UTF_8);
    }

    public static String decodeToString(String data) {
        byte[] outBytes = mHuffmanStandalone.decode(data);
        return new String(outBytes, StandardCharsets.UTF_8);
    }

    public static byte[] decode(String data) {
        byte[] outVal;
        mHuffmanStandalone.Reset();
        bitString = new BitString(data);
        if (listener != null) {
            outVal = mHuffmanStandalone.decodeStringWithListener();
            listener.decodeCompleted(success);
        } else {
            outVal = mHuffmanStandalone.decodeString();
        }
        return outVal;
    }

    public static byte[] decode(byte[] data) {
        byte[] outVal;
        mHuffmanStandalone.Reset();
        bitString = new BitString(data);
        if (listener != null) {
            outVal = mHuffmanStandalone.decodeStringWithListener();
            listener.decodeCompleted(success);
        } else {
            outVal = mHuffmanStandalone.decodeString();
        }
        return outVal;
    }

    private static void Reset() {
        dataChars = null;
        treeHeaderLen = 0;
        EncodedBits = 0;
        EncodedBytes = 0;
        OutBuffer = new BitString();
        LastNodeIndex = 255;
        Nodes = new Node[256];
        readNodes = new Node[256];
        RootNode = new Node();
        mHuffmanStandalone.RootNode.root = true;
    }

    private static void WriteHeader() {
        OutBuffer.setChar('H');
        OutBuffer.setChar('E');
        OutBuffer.setChar('3');
        OutBuffer.setByte((byte)13);
        OutBuffer.setByte(CheckSum);
        OutBuffer.setInt(inLength);
        OutBuffer.setShort(LeafCount);
        for (int x = 0; x < 256; ++x) {
            if (mHuffmanStandalone.readNodes[x].freq <= 0) continue;
            OutBuffer.setChar(mHuffmanStandalone.readNodes[x].Char);
            OutBuffer.setChar((char)mHuffmanStandalone.readNodes[x].Prefix.length);
        }
    }

    private static void WriteTree() {
        for (int x = 0; x < readNodes.length; ++x) {
            if (mHuffmanStandalone.readNodes[x].freq <= 0) continue;
            for (int y = 0; y < mHuffmanStandalone.readNodes[x].Prefix.length; ++y) {
                OutBuffer.setBit(mHuffmanStandalone.readNodes[x].Prefix[y]);
            }
        }
        if (OutBuffer.bitIndex() != 0) {
            OutBuffer.goToNextByte();
        }
    }

    private static void WriteData() {
        if (listener == null) {
            for (int x = 0; x < dataChars.length; ++x) {
                for (int y = 0; y < mHuffmanStandalone.readNodes[mHuffmanStandalone.dataChars[x]].Prefix.length; ++y) {
                    OutBuffer.setBit(mHuffmanStandalone.readNodes[mHuffmanStandalone.dataChars[x]].Prefix[y]);
                }
            }
        } else {
            for (int x = 0; x < dataChars.length; ++x) {
                for (int y = 0; y < mHuffmanStandalone.readNodes[mHuffmanStandalone.dataChars[x]].Prefix.length; ++y) {
                    OutBuffer.setBit(mHuffmanStandalone.readNodes[mHuffmanStandalone.dataChars[x]].Prefix[y]);
                }
                mHuffmanStandalone.valueChanged(x);
            }
        }
    }

    private static void lengthChanged(int newValue) {
        prog = 0;
        value = 0.0f;
        length = newValue;
        listener.lengthChanged(newValue);
    }

    private static void valueChanged(int newValue) {
        value = newValue;
        int progress = (int)(value / length * 100.0f);
        if (progress != prog) {
            prog = progress;
            listener.valueChanged(prog);
        }
    }

    private static byte[] decodeStringWithListener() {
        Node newNode;
        listener.decodeStarted();
        inLength = bitString.length();
        if (inLength < 11) {
            return new byte[0];
        }
        if (bitString.getChar() != 'H' | bitString.getChar() != 'E' | bitString.getChar() != '3' | bitString.getChar() != '\r') {
            return new byte[0];
        }
        CheckSum = bitString.getByte();
        EncodedBytes = bitString.getInt();
        LeafCount = bitString.getShort();
        if (LeafCount == 0) {
            return new byte[0];
        }
        Nodes = new Node[LeafCount];
        int bitCount = 0;
        int byteCount = 0;
        for (int x = 0; x < LeafCount; ++x) {
            char inChar = bitString.getChar();
            char pLen = bitString.getChar();
            bitCount += pLen;
            mHuffmanStandalone.Nodes[x] = newNode = new Node();
            mHuffmanStandalone.Nodes[x].Char = inChar;
            mHuffmanStandalone.Nodes[x].Prefix = new byte[pLen];
            mHuffmanStandalone.Nodes[x].leaf = true;
            mHuffmanStandalone.readNodes[inChar] = newNode;
        }
        byteCount = bitCount % 8 == 0 ? bitCount / 8 : bitCount / 8 + 1;
        for (int x = 0; x < LeafCount; ++x) {
            Node curNode = RootNode;
            for (int y = 0; y < mHuffmanStandalone.Nodes[x].Prefix.length; ++y) {
                mHuffmanStandalone.Nodes[x].Prefix[y] = bitString.getBit();
                if (y == mHuffmanStandalone.Nodes[x].Prefix.length - 1) {
                    if (mHuffmanStandalone.Nodes[x].Prefix[y] == 0) {
                        curNode.left = Nodes[x];
                        continue;
                    }
                    curNode.right = Nodes[x];
                    continue;
                }
                if (mHuffmanStandalone.Nodes[x].Prefix[y] == 0) {
                    if (curNode.left == null) {
                        curNode.left = newNode = new Node();
                    }
                    curNode = curNode.left;
                    continue;
                }
                if (curNode.right == null) {
                    curNode.right = newNode = new Node();
                }
                curNode = curNode.right;
            }
        }
        Node curNode = RootNode;
        int ResultLen = 0;
        BitString OutString = new BitString();
        if (bitString.bitIndex() != 0) {
            bitString.goToNextByte();
        }
        while (ResultLen < EncodedBytes) {
            byte newBit = bitString.getBit();
            curNode = newBit == 0 ? curNode.left : curNode.right;
            if (curNode == null) {
                return new byte[0];
            }
            if (!curNode.leaf) continue;
            OutString.setChar(curNode.Char);
            mHuffmanStandalone.valueChanged(++ResultLen);
            curNode = RootNode;
        }
        success = true;
        return OutString.getBytes(0, EncodedBytes);
    }

    private static byte[] decodeString() {
        Node newNode;
        inLength = bitString.length();
        if (inLength < 11) {
            return new byte[0];
        }
        if (bitString.getChar() != 'H' | bitString.getChar() != 'E' | bitString.getChar() != '3' | bitString.getChar() != '\r') {
            return new byte[0];
        }
        CheckSum = bitString.getByte();
        EncodedBytes = bitString.getInt();
        LeafCount = bitString.getShort();
        if (LeafCount == 0) {
            return new byte[0];
        }
        Nodes = new Node[LeafCount];
        int bitCount = 0;
        int byteCount = 0;
        for (int x = 0; x < LeafCount; ++x) {
            char inChar = bitString.getChar();
            char pLen = bitString.getChar();
            bitCount += pLen;
            mHuffmanStandalone.Nodes[x] = newNode = new Node();
            mHuffmanStandalone.Nodes[x].Char = inChar;
            mHuffmanStandalone.Nodes[x].Prefix = new byte[pLen];
            mHuffmanStandalone.Nodes[x].leaf = true;
            mHuffmanStandalone.readNodes[inChar] = newNode;
        }
        byteCount = bitCount % 8 == 0 ? bitCount / 8 : bitCount / 8 + 1;
        for (int x = 0; x < LeafCount; ++x) {
            Node curNode = RootNode;
            for (int y = 0; y < mHuffmanStandalone.Nodes[x].Prefix.length; ++y) {
                mHuffmanStandalone.Nodes[x].Prefix[y] = bitString.getBit();
                if (y == mHuffmanStandalone.Nodes[x].Prefix.length - 1) {
                    if (mHuffmanStandalone.Nodes[x].Prefix[y] == 0) {
                        curNode.left = Nodes[x];
                        continue;
                    }
                    curNode.right = Nodes[x];
                    continue;
                }
                if (mHuffmanStandalone.Nodes[x].Prefix[y] == 0) {
                    if (curNode.left == null) {
                        curNode.left = newNode = new Node();
                    }
                    curNode = curNode.left;
                    continue;
                }
                if (curNode.right == null) {
                    curNode.right = newNode = new Node();
                }
                curNode = curNode.right;
            }
        }
        Node curNode = RootNode;
        int ResultLen = 0;
        BitString OutString = new BitString();
        if (bitString.bitIndex() != 0) {
            bitString.goToNextByte();
        }
        while (ResultLen < EncodedBytes) {
            byte newBit = bitString.getBit();
            curNode = newBit == 0 ? curNode.left : curNode.right;
            if (curNode == null) {
                return new byte[0];
            }
            if (!curNode.leaf) continue;
            OutString.setChar(curNode.Char);
            ++ResultLen;
            curNode = RootNode;
        }
        success = true;
        return OutString.getBytes(0, EncodedBytes);
    }

    private static byte[] encodeString() {
        int x;
        success = false;
        inLength = dataChars.length;
        if (inLength == 0) {
            return new byte[0];
        }
        if (listener != null) {
            listener.encodeStarted();
            mHuffmanStandalone.lengthChanged(inLength);
        }
        for (x = 0; x < 256; ++x) {
            Node newNode;
            mHuffmanStandalone.Nodes[x] = newNode = new Node();
            mHuffmanStandalone.readNodes[x] = newNode;
            mHuffmanStandalone.Nodes[x].Char = (char)x;
            mHuffmanStandalone.Nodes[x].leaf = true;
        }
        for (x = 0; x < inLength; ++x) {
            try {
                ++mHuffmanStandalone.Nodes[mHuffmanStandalone.dataChars[x]].freq;
                continue;
            }
            catch (Exception e) {
                lastError = e.getMessage();
                return null;
            }
        }
        mHuffmanStandalone.SortNodes();
        LastNodeIndex = -1;
        for (x = 0; x < 256 && mHuffmanStandalone.Nodes[x].freq != 0; ++x) {
            ++LastNodeIndex;
        }
        if (LastNodeIndex == -1) {
            return new byte[0];
        }
        Node[] tmpNodes = new Node[LastNodeIndex + 1];
        System.arraycopy(Nodes, 0, tmpNodes, 0, LastNodeIndex + 1);
        Nodes = tmpNodes;
        tmpNodes = null;
        LeafCount = (short)(LastNodeIndex + 1);
        while (LastNodeIndex > 1) {
            mHuffmanStandalone.SortNodes();
            Node tmpNode = new Node();
            tmpNode.left = Nodes[LastNodeIndex - 1];
            tmpNode.right = Nodes[LastNodeIndex];
            tmpNode.freq = tmpNode.left.freq + tmpNode.right.freq;
            mHuffmanStandalone.Nodes[mHuffmanStandalone.LastNodeIndex - 1] = tmpNode;
            mHuffmanStandalone.Nodes[mHuffmanStandalone.LastNodeIndex] = null;
            --LastNodeIndex;
        }
        mHuffmanStandalone.SortNodes();
        mHuffmanStandalone.RootNode.left = Nodes[0];
        mHuffmanStandalone.RootNode.right = Nodes[1];
        mHuffmanStandalone.RootNode.freq = mHuffmanStandalone.RootNode.left.freq + mHuffmanStandalone.RootNode.right.freq;
        mHuffmanStandalone.AnnotateChildren(RootNode);
        EncodedBytes = EncodedBits % 8 == 0 ? EncodedBits / 8 : EncodedBits / 8 + 1;
        CheckSum = mHuffmanStandalone.getCheckSum(dataChars);
        mHuffmanStandalone.WriteHeader();
        mHuffmanStandalone.WriteTree();
        mHuffmanStandalone.WriteData();
        success = true;
        return OutBuffer.getBytes();
    }

    private static byte getCheckSum(char[] ByteArray) {
        byte cs = 0;
        for (int x = 0; x < ByteArray.length; ++x) {
            cs = (byte)(cs ^ ByteArray[x]);
        }
        return cs;
    }

    private static void SortNodes() {
        for (int x = 0; x <= LastNodeIndex - 1; ++x) {
            int highestIndex = x;
            for (int y = x + 1; y <= LastNodeIndex; ++y) {
                if (mHuffmanStandalone.Nodes[y].freq <= mHuffmanStandalone.Nodes[highestIndex].freq) continue;
                highestIndex = y;
            }
            if (highestIndex == x) continue;
            Node tmpNode = Nodes[x];
            mHuffmanStandalone.Nodes[x] = Nodes[highestIndex];
            mHuffmanStandalone.Nodes[highestIndex] = tmpNode;
        }
    }

    static void AnnotateChildren(Node node) {
        if (!node.leaf & !node.root) {
            if (node.left != null) {
                node.left.Prefix = new byte[node.Prefix.length + 1];
                System.arraycopy(node.Prefix, 0, node.left.Prefix, 0, node.Prefix.length);
                mHuffmanStandalone.AnnotateChildren(node.left);
            }
            if (node.right != null) {
                node.right.Prefix = new byte[node.Prefix.length + 1];
                System.arraycopy(node.Prefix, 0, node.right.Prefix, 0, node.Prefix.length);
                node.right.Prefix[node.Prefix.length] = 1;
                mHuffmanStandalone.AnnotateChildren(node.right);
            }
        } else if (node.leaf) {
            EncodedBits += node.Prefix.length * node.freq;
            treeHeaderLen += node.Prefix.length;
        } else if (node.root) {
            if (node.left != null) {
                node.left.Prefix = new byte[1];
                mHuffmanStandalone.AnnotateChildren(node.left);
            }
            if (node.right != null) {
                node.right.Prefix = new byte[1];
                node.right.Prefix[0] = 1;
                mHuffmanStandalone.AnnotateChildren(node.right);
            }
        }
    }

    static char[] getFileChars(File file) {
        lastError = "";
        if (!file.isFile()) {
            lastError = "Specified path is not a file.";
            return null;
        }
        if (!file.exists()) {
            lastError = "Specified file does not exist.";
            return null;
        }
        if (!file.canRead()) {
            lastError = "Specified file does not have read access.";
            return null;
        }
        try {
            byte[] bytes = Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0]));
            char[] chars = new char[bytes.length];
            for (int i = 0; i < bytes.length; ++i) {
                chars[i] = (char)(bytes[i] & 0xFF);
            }
            return chars;
        }
        catch (FileNotFoundException ex) {
            System.err.println(ex.getLocalizedMessage());
            return null;
        }
        catch (IOException ex) {
            System.err.println(ex.getLocalizedMessage());
            return null;
        }
    }

    static {
        LeafCount = 0;
        EncodedBits = 0;
        EncodedBytes = 0;
        lastError = "";
        length = 0.0f;
        value = 0.0f;
        prog = 0;
    }

    public static interface EncoderListener {
        public void lengthChanged(int var1);

        public void valueChanged(int var1);

        public void decodeStarted();

        public void encodeStarted();

        public void decodeCompleted(boolean var1);

        public void encodeCompleted(boolean var1);
    }

    static class BitString {
        private int mByteIndex = 0;
        private int mBitIndex = 0;
        private byte[] charData;
        private int mBitLength = 0;
        private int mByteLength = 0;

        public void setBufferSize(int BufferSize) {
            if (BufferSize > 0) {
                BUFFERSIZE = BufferSize;
            }
        }

        public int getBufferSize() {
            return BUFFERSIZE;
        }

        public BitString() {
            this.charData = new byte[BUFFERSIZE];
            Arrays.fill(this.charData, (byte)0);
        }

        public BitString(int BufferSize) {
            this.charData = new byte[BufferSize];
            Arrays.fill(this.charData, (byte)0);
        }

        public BitString(String data) {
            this.setString(data);
        }

        public BitString(byte[] data) {
            this.setString(data, 0, data.length);
        }

        public BitString(byte[] data, int startOffset) {
            this.setString(data, startOffset, data.length);
        }

        public BitString(byte[] data, int startOffset, int stopOffset) {
            this.setString(data, startOffset, stopOffset);
        }

        public BitString(BitString data) {
            this.clone(data);
        }

        public void clone(BitString data) {
            this.charData = new byte[data.charData.length];
            System.arraycopy(data.charData, 0, this.charData, 0, data.mByteLength);
            this.mBitIndex = data.mBitIndex;
            this.mByteIndex = data.mByteIndex;
            this.mByteLength = data.mByteLength;
        }

        public int length() {
            return this.mByteLength;
        }

        public int bitLength() {
            return this.mBitLength;
        }

        public void setBitLength(int BitLength) {
            this.charData = BitLength % 8 == 0 ? new byte[BitLength / 8] : new byte[BitLength / 8 + 1];
            this.mBitLength = BitLength;
            this.mByteIndex = 0;
            this.mBitIndex = 0;
        }

        private void incBuffer(int appendByteSize) {
            byte[] newBuffer = new byte[appendByteSize + this.charData.length];
            System.arraycopy(this.charData, 0, newBuffer, 0, this.charData.length);
            this.charData = newBuffer;
        }

        public void setString(String data) {
            byte[] tmpData = data.getBytes();
            this.setString(tmpData, 0, tmpData.length);
        }

        public void setString(byte[] data) {
            this.setString(data, 0, data.length);
        }

        public void setString(byte[] data, int startOffset) {
            this.setString(data, startOffset, data.length);
        }

        public void setString(byte[] data, int startOffset, int stopOffset) {
            int newLen = stopOffset - startOffset;
            this.charData = new byte[newLen + BUFFERSIZE];
            System.arraycopy(data, startOffset, this.charData, 0, newLen);
            this.mByteLength = newLen;
            this.mBitLength = newLen * 8;
            this.mByteIndex = 0;
            this.mBitIndex = 0;
        }

        public void setChar(char Char) {
            this.charData[this.mByteIndex] = (byte)Char;
            this.goToNextByte();
        }

        public void setShort(short value) {
            this.setByte((byte)(value & 0xFF));
            this.setByte((byte)(value >> 8 & 0xFF));
        }

        public void setInt(int value) {
            this.setByte((byte)value);
            this.setByte((byte)(value >>> 8));
            this.setByte((byte)(value >>> 16));
            this.setByte((byte)(value >>> 24));
        }

        public void setByte(byte Byte) {
            this.charData[this.mByteIndex] = Byte;
            this.goToNextByte();
        }

        public void setBit() {
            int n = this.mByteIndex;
            this.charData[n] = (byte)(this.charData[n] | BITMASK[this.mBitIndex]);
            this.goToNextBit();
        }

        public void setBit(boolean value) {
            if (value) {
                int n = this.mByteIndex;
                this.charData[n] = (byte)(this.charData[n] | BITMASK[this.mBitIndex]);
            } else {
                int n = this.mByteIndex;
                this.charData[n] = (byte)(this.charData[n] | BITMASK[this.mBitIndex]);
                int n2 = this.mByteIndex;
                this.charData[n2] = (byte)(this.charData[n2] ^ BITMASK[this.mBitIndex]);
            }
            this.goToNextBit();
        }

        public void setBit(byte value) {
            if (value != 0) {
                int n = this.mByteIndex;
                this.charData[n] = (byte)(this.charData[n] | BITMASK[this.mBitIndex]);
            } else {
                int n = this.mByteIndex;
                this.charData[n] = (byte)(this.charData[n] | BITMASK[this.mBitIndex]);
                int n2 = this.mByteIndex;
                this.charData[n2] = (byte)(this.charData[n2] ^ BITMASK[this.mBitIndex]);
            }
            this.goToNextBit();
        }

        public void append(byte data) {
            this.mBitIndex = 0;
            this.mByteIndex = this.mByteLength;
            this.goToNextByte();
        }

        public void append(byte[] data) {
            int newLen = this.mByteLength + data.length;
            if (this.mByteLength >= this.charData.length) {
                this.incBuffer(newLen - this.mByteLength + BUFFERSIZE);
            }
            System.arraycopy(data, 0, this.charData, this.mByteLength + 1, data.length);
            this.mByteLength = newLen;
            this.mBitIndex = 0;
            this.mByteIndex = newLen;
        }

        public int bitPosition() {
            return this.mByteIndex * 8 + this.mBitIndex;
        }

        public void goToBit(int Index) {
            this.mByteIndex = Index / 8;
            this.mBitIndex = Index - this.mByteIndex * 8;
        }

        public void goToNextBit() {
            ++this.mBitIndex;
            if (this.mBitIndex == 8) {
                this.goToNextByte();
            } else if (this.mByteIndex + this.mBitIndex > this.mBitLength) {
                ++this.mBitLength;
            }
        }

        public void goToNextByte() {
            ++this.mByteIndex;
            this.mBitIndex = 0;
            if (this.mByteIndex > this.mByteLength) {
                this.mByteLength = this.mByteIndex;
                this.mBitLength = this.mByteLength * 8;
            }
            if (this.mByteIndex >= this.charData.length - 1) {
                this.incBuffer(BUFFERSIZE);
            }
        }

        public void goToPrevBit() {
            --this.mBitIndex;
            if (this.mBitIndex == -1) {
                --this.mByteIndex;
                this.mBitIndex = 7;
            }
        }

        public void goToByte(int Index) {
            this.mByteIndex = Index - 1;
            this.goToNextByte();
        }

        public void goToStart() {
            this.mByteIndex = 0;
            this.mBitIndex = 0;
        }

        public void goToEnd() {
            this.goToByte(this.mByteLength);
        }

        public boolean atEnd() {
            return this.mByteIndex == this.mByteLength;
        }

        public String toString() {
            return new String(this.getBytes());
        }

        public int bitIndex() {
            return this.mBitIndex;
        }

        public int byteIndex() {
            return this.mByteIndex;
        }

        public byte getBit() {
            byte outBit = 0;
            if (this.charData[this.mByteIndex] == (this.charData[this.mByteIndex] | BITMASK[this.mBitIndex])) {
                outBit = 1;
            }
            this.goToNextBit();
            return outBit;
        }

        public byte getBit(int Index) {
            int tmpByteIndex = Index / 8;
            int tmpBitIndex = Index - this.mByteIndex;
            if (this.charData[tmpByteIndex] == (this.charData[tmpByteIndex] | BITMASK[tmpBitIndex])) {
                return 1;
            }
            return 0;
        }

        public byte getByte() {
            this.goToNextByte();
            return this.charData[this.mByteIndex - 1];
        }

        public byte getByte(int Index) {
            return this.charData[Index];
        }

        public char getChar() {
            this.goToNextByte();
            return (char)(this.charData[this.mByteIndex - 1] & 0xFF);
        }

        public char getChar(int Index) {
            return (char)(this.charData[Index] & 0xFF);
        }

        public short getShort() {
            int b0 = 0xFF & this.charData[this.mByteIndex];
            int b1 = 0xFF & this.charData[this.mByteIndex + 1];
            this.mByteIndex += 2;
            this.mBitIndex = 0;
            return (short)(b1 << 8 | b0);
        }

        public short getShort(int Index) {
            int b0 = 0xFF & this.charData[Index];
            int b1 = 0xFF & this.charData[Index + 1];
            return (short)(b1 << 8 | b0);
        }

        public int getInt() {
            int b0 = 0xFF & this.charData[this.mByteIndex];
            int b1 = 0xFF & this.charData[this.mByteIndex + 1];
            int b2 = 0xFF & this.charData[this.mByteIndex + 2];
            int b3 = 0xFF & this.charData[this.mByteIndex + 3];
            this.mByteIndex += 4;
            this.mBitIndex = 0;
            return b3 << 24 | b2 << 16 | b1 << 8 | b0;
        }

        public int getInt(int Index) {
            int b0 = 0xFF & this.charData[Index];
            int b1 = 0xFF & this.charData[Index + 1];
            int b2 = 0xFF & this.charData[Index + 2];
            int b3 = 0xFF & this.charData[Index + 3];
            return b3 << 24 | b2 << 16 | b1 << 8 | b0;
        }

        public byte[] getBytes() {
            if (this.mByteLength == this.charData.length) {
                return this.charData;
            }
            byte[] outBytes = new byte[this.mByteLength + 1];
            System.arraycopy(this.charData, 0, outBytes, 0, this.mByteLength + 1);
            return outBytes;
        }

        public byte[] getBytes(int startOffset) {
            int outLen = this.mByteLength - startOffset;
            byte[] outBytes = new byte[outLen];
            System.arraycopy(this.charData, 0, outBytes, 0, outLen);
            return outBytes;
        }

        public byte[] getBytes(int startOffset, int stopOffset) {
            if (stopOffset > this.mByteLength) {
                stopOffset = this.mByteLength;
            }
            int outLen = stopOffset - startOffset;
            byte[] outBytes = new byte[outLen];
            System.arraycopy(this.charData, 0, outBytes, 0, outLen);
            return outBytes;
        }

        public byte[] getNBytes(int Length) {
            byte[] outBytes = new byte[Length];
            System.arraycopy(this.charData, this.mByteIndex, outBytes, 0, Length);
            this.mByteIndex += Length;
            this.mBitIndex = 0;
            return outBytes;
        }

        public void removeWhiteSpaces() {
            int wIndex = 0;
            for (int rIndex = 0; rIndex < this.mByteLength; ++rIndex) {
                if (!(this.charData[rIndex] != 9 & this.charData[rIndex] != 32 & this.charData[rIndex] != 0 & this.charData[rIndex] != 13 & this.charData[rIndex] != 10)) continue;
                if (rIndex != wIndex) {
                    this.charData[wIndex] = this.charData[rIndex];
                }
                ++wIndex;
            }
            for (int x = this.mByteLength = wIndex; x < this.charData.length; ++x) {
                this.charData[x] = 0;
            }
        }

        public void TrimLeft() {
            int x;
            int wIndex = 0;
            int rIndex = -1;
            for (x = 0; x < this.mByteLength && this.charData[x] == 32; ++x) {
                ++rIndex;
            }
            if (rIndex == -1) {
                return;
            }
            if (rIndex == this.mByteLength - 1) {
                Arrays.fill(this.charData, (byte)0);
                this.mByteLength = 0;
                this.mBitLength = 0;
                this.mByteIndex = 0;
                this.mBitIndex = 0;
                return;
            }
            for (x = ++rIndex; x < this.mByteLength; ++x) {
                this.charData[wIndex] = this.charData[rIndex];
            }
            for (x = this.mByteLength = wIndex; x < this.charData.length; ++x) {
                this.charData[x] = 0;
            }
        }

        public void TrimRight() {
            for (int x = this.mByteLength; x >= 0 && this.charData[x] == 32; ++x) {
                this.charData[x] = 0;
                --this.mByteLength;
            }
            this.mBitLength = this.mByteLength * 8;
            this.mByteIndex = 0;
            this.mBitIndex = 0;
        }

        public void replace(char targetByte, char newByte) {
            this.replace((byte)targetByte, (byte)newByte);
        }

        public void replace(byte targetByte, byte newByte) {
            for (int x = 0; x < this.mByteLength; ++x) {
                if (this.charData[x] != targetByte) continue;
                this.charData[x] = newByte;
            }
        }

        public void replace(char targetChar, String newSeq) {
            this.replace((byte)targetChar, newSeq.getBytes());
        }

        public void replace(byte targetByte, String newSeq) {
            this.replace(targetByte, newSeq.getBytes());
        }

        public void replace(byte targetByte, byte[] newByte) {
            if (newByte.length == 1) {
                this.replace(targetByte, newByte[0]);
                return;
            }
            int dSize = newByte.length - 1;
            int ItemsFound = 0;
            for (int x = 0; x < this.mByteLength; ++x) {
                if (this.charData[x] != targetByte) continue;
                ++ItemsFound;
            }
            if (ItemsFound == 0) {
                return;
            }
            int newLen = this.mByteLength + dSize * ItemsFound + BUFFERSIZE;
            byte[] tmpBuffer = new byte[newLen];
            int wIndex = 0;
            for (int x = 0; x < this.mByteLength; ++x) {
                if (this.charData[x] == targetByte) {
                    for (int y = 0; y < newByte.length; ++y) {
                        tmpBuffer[wIndex] = newByte[y];
                        ++wIndex;
                    }
                    continue;
                }
                tmpBuffer[wIndex] = this.charData[x];
                ++wIndex;
            }
            this.charData = tmpBuffer;
            this.mByteLength = this.charData.length - BUFFERSIZE;
            this.mByteIndex = 0;
            this.mBitIndex = 0;
        }

        static int[] bytesToInts(byte[] inBytes) {
            int[] outInts = new int[inBytes.length / 4];
            int inIndex = 0;
            for (int x = 0; x < outInts.length; ++x) {
                int b0 = 0xFF & inBytes[inIndex];
                int b1 = 0xFF & inBytes[inIndex + 1];
                int b2 = 0xFF & inBytes[inIndex + 2];
                int b3 = 0xFF & inBytes[inIndex + 3];
                outInts[x] = b3 << 24 | b2 << 16 | b1 << 8 | b0;
                inIndex += 4;
            }
            return outInts;
        }

        static short[] bytesToShorts(byte[] inBytes) {
            short[] outShorts = new short[inBytes.length / 2];
            int inIndex = 0;
            for (int x = 0; x < outShorts.length; ++x) {
                int b0 = 0xFF & inBytes[inIndex];
                int b1 = 0xFF & inBytes[inIndex + 1];
                outShorts[x] = (short)(b1 << 8 | b0);
                inIndex += 2;
            }
            return outShorts;
        }
    }

    private static class Node {
        public byte[] Prefix;
        public Node left;
        public Node right;
        public char Char;
        public boolean leaf = false;
        public boolean root = false;
        public int freq;
    }
}

