/*
 * Decompiled with CFR 0.152.
 */
package EditorTable;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;

public class TextFileWriter {
    File file = null;
    FileOutputStream fos = null;
    BufferedWriter bw;
    String error;

    public TextFileWriter() {
    }

    public TextFileWriter(File file) {
        this.openFile(file);
    }

    public TextFileWriter(String file) {
        this.openFile(file);
    }

    public boolean hasError() {
        return this.getError().length() > 0;
    }

    public String getError() {
        if (this.error == null) {
            return "";
        }
        return this.error;
    }

    public static FileNameExtensionFilter GenerateFilter(String baseText, String ... extensions) {
        String finalString = baseText + " (*." + extensions[0];
        for (int x = 1; x < extensions.length; ++x) {
            finalString = finalString + ", *." + extensions[x];
        }
        finalString = finalString + ")";
        return new FileNameExtensionFilter(finalString, extensions);
    }

    private static void showMsgBox(String text, String title) {
        JOptionPane.showMessageDialog(null, text, title, 0);
    }

    public static TextFileWriter openFile(String baseText, String ... extensions) {
        JFileChooser saveDlg = new JFileChooser();
        saveDlg.setFileFilter(TextFileWriter.GenerateFilter(baseText, extensions));
        if (saveDlg.showSaveDialog(null) == 0) {
            File newFile = saveDlg.getSelectedFile();
            String absolutePath = newFile.getAbsoluteFile().toString();
            if (!absolutePath.toUpperCase().endsWith("POV")) {
                absolutePath = absolutePath + ".pov";
                newFile = new File(absolutePath);
            }
            if (newFile.exists() && newFile.isFile() && !newFile.canWrite()) {
                TextFileWriter.showMsgBox("File exists and does not have write access", "Save error");
                return null;
            }
            TextFileWriter writer = new TextFileWriter(newFile);
            if (writer.isOpen()) {
                return writer;
            }
        }
        return null;
    }

    public boolean isOpen() {
        return this.file != null && this.fos != null && this.bw != null;
    }

    public void close() {
        this.file = null;
        this.fos = null;
        if (this.bw != null) {
            try {
                this.bw.close();
            }
            catch (IOException ex) {
                this.error = ex.getLocalizedMessage();
            }
        }
        this.bw = null;
    }

    public boolean openFile(String file) {
        return this.openFile(new File(file), false);
    }

    public boolean openFile(String file, boolean promptOverwrite) {
        return this.openFile(new File(file), promptOverwrite);
    }

    public boolean openFile(File file) {
        return this.openFile(file, false);
    }

    public boolean openFile(File file, boolean promptOverwrite) {
        this.error = null;
        if (file.exists()) {
            if (!file.isFile()) {
                this.error = "Specified path exists and is not a file";
                return false;
            }
            if (file.isFile() && !file.canWrite()) {
                this.error = "Specified file exists and does not have write permissions";
                return false;
            }
            if (file.isFile() && file.canWrite() && promptOverwrite && JOptionPane.showConfirmDialog(null, "Overwrite existing file?", "File exists", 0, 0) == 1) {
                this.error = "File overwrite was canceled by user.";
                return false;
            }
        }
        try {
            this.fos = new FileOutputStream(file);
        }
        catch (FileNotFoundException ex) {
            this.error = ex.getLocalizedMessage();
            return false;
        }
        this.file = file;
        this.bw = new BufferedWriter(new OutputStreamWriter(this.fos));
        return true;
    }

    public boolean writeLine(String text) {
        this.error = null;
        if (this.file == null || this.fos == null) {
            return false;
        }
        try {
            this.bw.write(text + "\n");
        }
        catch (IOException ex) {
            this.error = ex.getLocalizedMessage();
            return false;
        }
        return true;
    }
}

