/*
 * Decompiled with CFR 0.152.
 */
package EditorTable;

import EditorTable.ColumnHeaderRenderer;
import EditorTable.DataTable;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import javax.swing.border.EmptyBorder;

public class RowRenderer
extends ColumnHeaderRenderer {
    Color foreground = Color.black;
    Color background = Color.white;

    public RowRenderer() {
        this.label.setBorder(new EmptyBorder(0, 5, 0, 5));
        this.label.setOpaque(false);
    }

    public void setAlignment(int alignment) {
        switch (alignment) {
            case 4: {
                this.label.setHorizontalAlignment(4);
                break;
            }
            case 0: {
                this.label.setHorizontalAlignment(0);
                break;
            }
            default: {
                this.label.setHorizontalAlignment(2);
            }
        }
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
        this.label.setSize(width, height);
        this.regenBuffer(width, height);
    }

    @Override
    public void setForeground(Color color) {
        this.foreground = color;
        this.label.setForeground(color);
    }

    @Override
    public void setBackground(Color color) {
        this.background = color;
    }

    @Override
    public void draw(DataTable editorTable, int colIndex, int rowIndex, boolean selected) {
        this.label.setText(String.valueOf(rowIndex + 1));
        Graphics2D g = this.getGraphicsBuffer(this.width, this.height);
        g.setColor(this.background);
        g.fillRect(0, 0, this.width, this.height);
        this.label.paint(this.getGraphicsBuffer(this.width, this.height));
    }

    @Override
    public void setFont(Font font) {
        this.label.setFont(font);
    }
}

