/*
 * Decompiled with CFR 0.152.
 */
package EditorTable;

import EditorTable.BasicDataTable;
import EditorTable.CellEditor;
import EditorTable.Column;
import EditorTable.TextFileWriter;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class EditorWindow
extends JFrame {
    public static int defaultCloseOperation = 0;
    public static boolean defaultCellEdit = true;
    public static boolean defaultColEdit = true;
    public static boolean rowSelect = false;
    private static String defaultTitle;
    private static ImageIcon defaultIcon;
    static Color selectedBorderColor;
    static Color foreColor;
    static Color backColor;
    static Color selectedForeColor;
    static Color selectedBackColor;
    static boolean updateAfterAppend;
    public static final int EDITOR_NONE = 0;
    public static final int EDITOR_TEXTBOX = 1;
    public static final int EDITOR_COMBOBOX = 2;
    private BasicDataTable dataTable;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem5;
    private JPopupMenu.Separator jSeparator1;
    private JMenuItem mnuClear;
    private JMenuItem mnuCopyAll;
    private JMenuItem mnuCopyAllHeaders;
    private JMenuItem mnuCopySelHeaders;
    private JMenuItem mnuCopySelected;
    private JMenu mnuEdit;
    private JMenu mnuFile;
    private JMenuItem mnuSelectAll;

    public static Color getForeColor() {
        return foreColor;
    }

    public void setForeColor(Color color) {
        foreColor = color;
        this.dataTable.setForecolor(color);
    }

    public static Color getBackColor() {
        return backColor;
    }

    public void setBackColor(Color color) {
        backColor = color;
        this.dataTable.setBackcolor(color);
    }

    public FontMetrics getFontMetrics() {
        return this.dataTable.getFontMetrics();
    }

    public Color getSelectedForeColor() {
        return selectedForeColor;
    }

    public static void setDefaultActionOnClose(int action) {
        defaultCloseOperation = action;
    }

    public void setSelectedForeColor(Color color) {
        selectedForeColor = color;
        this.dataTable.setSelectedForecolor(color);
    }

    public Color getSelectedBackColor() {
        return selectedBackColor;
    }

    public boolean getShowColumnHeaders() {
        return this.dataTable.isShowColumnHeaders();
    }

    public void setShowColumnHeaders(boolean show) {
        this.dataTable.setShowColumnHeaders(show);
    }

    public void setSelectedBackColor(Color color) {
        selectedBackColor = color;
        this.dataTable.setSelectedBackcolor(color);
    }

    public Color getSelectedBorderColor() {
        return selectedBorderColor;
    }

    public void setSelectedBorderColor(Color color) {
        selectedBorderColor = color;
        this.dataTable.setSelectedBordercolor(color);
    }

    public static String getDefaultTitle() {
        return defaultTitle;
    }

    public static void setDefaultTitle(String aDefaultTitle) {
        defaultTitle = aDefaultTitle;
    }

    public static ImageIcon getDefaultIcon() {
        return defaultIcon;
    }

    public static void setDefaultIcon(ImageIcon icon) {
        defaultIcon = icon;
    }

    public void setColumnUseRelativeSize(int columnIndex, boolean useRelativeSize) {
        Column col = this.dataTable.getColumn(columnIndex);
        if (col != null) {
            col.relWidth = col.width / this.dataTable.getWidth();
        }
    }

    public void setColumnRelativeSize(int columnIndex, float relativeWidth) {
        this.setColumnRelativeSize(columnIndex, relativeWidth, false, true);
    }

    public void setColumnRelativeSize(int columnIndex, float relativeWidth, boolean setColumnWidthRelative) {
        this.setColumnRelativeSize(columnIndex, relativeWidth, setColumnWidthRelative, true);
    }

    public void setColumnRelativeSize(int columnIndex, float relativeWidth, boolean setColumnWidthRelative, boolean redraw) {
        Column col = this.dataTable.getColumn(columnIndex);
        if (col != null) {
            col.width = (int)(relativeWidth * (float)this.dataTable.getWidth());
            if (setColumnWidthRelative) {
                col.relWidth = relativeWidth;
            }
            if (redraw) {
                this.dataTable.updateDisplay();
                this.dataTable.columnsManuallyAdjusted = true;
                this.dataTable.adjustHScroll();
            }
        }
    }

    public void setColumnRelativeSizes(int[] columnIndex, float[] relativeWidth) {
        if (columnIndex.length != relativeWidth.length) {
            return;
        }
        int columnCount = this.dataTable.getModel().getColumnCount();
        for (int x = 0; x < columnIndex.length; ++x) {
            Column col;
            if (columnCount <= 0 || columnIndex[x] < 0 || columnIndex[x] >= columnCount || (col = this.dataTable.getColumn(x)) == null) continue;
            col.relWidth = relativeWidth[x];
            col.width = -1;
        }
        this.dataTable.updateDisplay();
        this.dataTable.columnsManuallyAdjusted = true;
        this.dataTable.adjustHScroll();
    }

    public void setColumnHeadings(Object ... data) {
        this.dataTable.setColumnHeadings(data);
    }

    public void setUpdateAfterAppend(boolean update) {
        updateAfterAppend = update;
        if (updateAfterAppend) {
            this.dataTable.displayPanel.repaint();
        }
    }

    public static boolean isUpdateAfterAppend() {
        return updateAfterAppend;
    }

    public void clear() {
        this.dataTable.clear();
    }

    public void autoResizeColumns() {
        this.dataTable.autoResizeColumns();
    }

    public void setColumnAlignment(int column, int align) {
        this.dataTable.setColumnAlignment(column, align);
    }

    private void init() {
        if (EditorWindow.getDefaultIcon() != null) {
            this.setIconImage(EditorWindow.getDefaultIcon().getImage());
        }
        if (EditorWindow.getDefaultTitle() != null) {
            this.setTitle(EditorWindow.getDefaultTitle());
        }
        this.setDefaultCloseOperation(defaultCloseOperation);
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent arg0) {
            }

            @Override
            public void windowClosing(WindowEvent arg0) {
                switch (EditorWindow.this.getDefaultCloseOperation()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        EditorWindow.this.setVisible(false);
                        break;
                    }
                    case 2: {
                        EditorWindow.this.dispose();
                        break;
                    }
                    case 3: {
                        System.exit(0);
                    }
                }
            }

            @Override
            public void windowClosed(WindowEvent arg0) {
            }

            @Override
            public void windowIconified(WindowEvent arg0) {
            }

            @Override
            public void windowDeiconified(WindowEvent arg0) {
            }

            @Override
            public void windowActivated(WindowEvent arg0) {
            }

            @Override
            public void windowDeactivated(WindowEvent arg0) {
            }
        });
        this.dataTable.setColumnHeadings("Primer Name\tPrimer Sequence\tTm(PBS)\u00b0C\tComments");
        this.dataTable.setColumnAlignment(2, 0);
    }

    public void setColumnEditor(int column, CellEditor editor) {
        this.dataTable.setColumnEditor(column, editor);
    }

    public EditorWindow() {
        this.initComponents();
        this.init();
    }

    public void addRow(Object[] values) {
        this.dataTable.addRow(values);
    }

    private void initComponents() {
        this.dataTable = new BasicDataTable();
        this.jMenuBar1 = new JMenuBar();
        this.mnuFile = new JMenu();
        this.jMenuItem5 = new JMenuItem();
        this.mnuEdit = new JMenu();
        this.mnuCopyAll = new JMenuItem();
        this.mnuCopyAllHeaders = new JMenuItem();
        this.mnuCopySelected = new JMenuItem();
        this.mnuCopySelHeaders = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.mnuClear = new JMenuItem();
        this.mnuSelectAll = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                EditorWindow.this.formKeyPressed(evt);
            }
        });
        this.mnuFile.setText("File");
        this.jMenuItem5.setAccelerator(KeyStroke.getKeyStroke(83, 128));
        this.jMenuItem5.setText("Save As...");
        this.jMenuItem5.setEnabled(false);
        this.jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditorWindow.this.jMenuItem5ActionPerformed(evt);
            }
        });
        this.mnuFile.add(this.jMenuItem5);
        this.jMenuBar1.add(this.mnuFile);
        this.mnuEdit.setText("Edit");
        this.mnuCopyAll.setText("Copy All w/o Column Headers");
        this.mnuCopyAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditorWindow.this.mnuCopyAllActionPerformed(evt);
            }
        });
        this.mnuEdit.add(this.mnuCopyAll);
        this.mnuCopyAllHeaders.setAccelerator(KeyStroke.getKeyStroke(67, 128));
        this.mnuCopyAllHeaders.setText("Copy All w/ Column Headers");
        this.mnuCopyAllHeaders.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditorWindow.this.mnuCopyAllHeadersActionPerformed(evt);
            }
        });
        this.mnuEdit.add(this.mnuCopyAllHeaders);
        this.mnuCopySelected.setAccelerator(KeyStroke.getKeyStroke(67, 192));
        this.mnuCopySelected.setText("Copy Selected");
        this.mnuCopySelected.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditorWindow.this.mnuCopySelectedActionPerformed(evt);
            }
        });
        this.mnuEdit.add(this.mnuCopySelected);
        this.mnuCopySelHeaders.setText("Copy Selected w/ Column Headers");
        this.mnuCopySelHeaders.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditorWindow.this.mnuCopySelHeadersActionPerformed(evt);
            }
        });
        this.mnuEdit.add(this.mnuCopySelHeaders);
        this.mnuEdit.add(this.jSeparator1);
        this.mnuClear.setText("Clear");
        this.mnuClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditorWindow.this.mnuClearActionPerformed(evt);
            }
        });
        this.mnuEdit.add(this.mnuClear);
        this.mnuSelectAll.setAccelerator(KeyStroke.getKeyStroke(65, 128));
        this.mnuSelectAll.setText("Select All");
        this.mnuSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditorWindow.this.mnuSelectAllActionPerformed(evt);
            }
        });
        this.mnuEdit.add(this.mnuSelectAll);
        this.jMenuBar1.add(this.mnuEdit);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.dataTable, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.dataTable, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void mnuCopyAllActionPerformed(ActionEvent evt) {
        this.dataTable.copyAll(false);
    }

    private void mnuCopySelectedActionPerformed(ActionEvent evt) {
        this.dataTable.copySelected(false);
    }

    private void formKeyPressed(KeyEvent evt) {
        int key = evt.getKeyCode();
        if (key != 83 && key != 67 && key != 88 && key != 65 && key != 70 && key != 71) {
            this.dataTable.displayPanelKeyPressed(evt);
        }
    }

    private void mnuSelectAllActionPerformed(ActionEvent evt) {
        this.dataTable.selectAll();
    }

    private void mnuClearActionPerformed(ActionEvent evt) {
        this.dataTable.clear();
    }

    private void mnuCopySelHeadersActionPerformed(ActionEvent evt) {
        this.dataTable.copySelected(true);
    }

    private void mnuCopyAllHeadersActionPerformed(ActionEvent evt) {
        this.dataTable.copyAll(true);
    }

    private void jMenuItem5ActionPerformed(ActionEvent evt) {
        TextFileWriter writer = TextFileWriter.openFile("Tab separated file", "tsv");
        if (writer == null) {
            return;
        }
        writer.close();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(EditorWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(EditorWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(EditorWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(EditorWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new EditorWindow().setVisible(true);
            }
        });
    }

    static {
        selectedBorderColor = new Color(0, 120, 215);
        foreColor = Color.BLACK;
        backColor = Color.WHITE;
        selectedForeColor = Color.BLACK;
        selectedBackColor = new Color(229, 241, 251);
        updateAfterAppend = true;
    }
}

