/*
 * Decompiled with CFR 0.152.
 */
package EditorTable;

import EditorTable.DataTableModelEvent;
import EditorTable.DataTableModelListener;
import java.util.Vector;

public abstract class DataTableModel {
    private Vector<DataTableModelListener> listeners = null;
    private boolean listenerEnabled = true;

    public boolean isListenerEnabled() {
        return this.listenerEnabled;
    }

    public void setListenerEnabled(boolean enabled) {
        this.listenerEnabled = enabled;
    }

    public boolean disableListener() {
        boolean wasEnabled = this.listenerEnabled;
        this.listenerEnabled = false;
        return wasEnabled;
    }

    void addListener(DataTableModelListener l) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    void removeListener(DataTableModelListener l) {
        if (this.listeners != null) {
            if (this.listeners.contains(l)) {
                this.listeners.remove(l);
            }
            if (this.listeners.isEmpty()) {
                this.listeners = null;
            }
        }
    }

    public void fireEvents(DataTableModelEvent ... evt) {
        if (this.listeners != null && this.listenerEnabled && !this.listeners.isEmpty()) {
            for (DataTableModelListener l : this.listeners) {
                l.dataTableChanged(evt);
            }
        }
    }

    public abstract void clear();

    public abstract Object getColumn(int var1);

    public abstract void setColumn(int var1, Object var2);

    public abstract void setColumns(Object ... var1);

    public abstract int getColumnCount();

    public abstract void setColumnCount(int var1);

    public abstract void resizeColumn(int var1);

    public abstract int getRowCount();

    public abstract void setValue(int var1, int var2, Object var3);

    public abstract void setRow(int var1, Object ... var2);

    public abstract Object getValue(int var1, int var2);

    public abstract void removeRow(int var1);

    public abstract int addRow(Object ... var1);

    public abstract boolean isCellEditable(int var1, int var2);

    public boolean isColumnEditable(int index) {
        int count = this.getColumnCount();
        return index >= 0 && count < count;
    }

    public abstract void insertColumn(Object var1, int var2);

    public abstract boolean swap(int var1, int var2);
}

