/*
 * Decompiled with CFR 0.152.
 */
package EditorTable;

import EditorTable.BasicDataTableModel;
import EditorTable.CellEditor;
import EditorTable.CellRenderer;
import EditorTable.Column;
import EditorTable.DataTableColumnModel;
import EditorTable.DataTableListener;
import EditorTable.DataTableModel;
import EditorTable.DataTableModelEvent;
import EditorTable.DataTableModelListener;
import EditorTable.ExtensibleArray;
import EditorTable.RowRenderer;
import JMScrollBars.JMScrollBar;
import ScrollPanels.ScrollPanel;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.beans.BeanProperty;
import java.util.Vector;
import javax.swing.UIManager;

public abstract class DataTable
extends ScrollPanel
implements ClipboardOwner,
DataTableModelListener {
    private DataTableModel model;
    protected final RowRenderer rowRenderer = new RowRenderer();
    protected boolean rowSelect = false;
    protected boolean colSelect = false;
    BufferedImage buffer;
    Graphics2D bufferGraphics;
    public Color columnHeaderForeColor = Color.BLACK;
    public Color gridColor = Color.BLACK;
    public Color columnHeaderBackColor = Color.lightGray;
    public Color columnHeaderDividerColor = Color.darkGray;
    protected final Selection selection = new Selection();
    protected int panelHeight = 0;
    protected int panelWidth = 0;
    int rowsVisible = 0;
    private int topY = 0;
    private Font fFont;
    private FontMetrics fMetrics;
    protected boolean antialiased;
    protected CellEditor activeEditor = null;
    protected Column rowHeader = new Column();
    protected Column draggedCol;
    protected int offsetX = 0;
    private int iY;
    private int iRowHeight;
    protected int offsetY;
    private boolean bDrag;
    protected boolean showGrid = true;
    private int rightmost = 0;
    private int leftMost = 0;
    private boolean showColHeaders = true;
    private boolean showRowHeaders = true;
    private DataTableColumnModel columnModel;
    private final ExtensibleArray<Column> columns = new ExtensibleArray<Column>(Column.class);
    private final Cursor resizeCursor = new Cursor(11);
    private final Cursor defaultCursor = new Cursor(0);
    protected boolean columnsManuallyAdjusted;
    private boolean changed = false;
    Color forecolor = Color.BLACK;
    Color backcolor = Color.WHITE;
    Color margincolor = Color.WHITE;
    Color selectedForecolor = Color.BLACK;
    Color selectedBackcolor = new Color(229, 241, 251);
    Color selectedBordercolor = new Color(0, 120, 215);
    private Point dragStart;
    JMScrollBar vScroll;
    JMScrollBar hScroll;
    boolean updateAfterAppend = true;
    public static final int PROPERTY_SELECTION_CHANGED = 0;
    public static final int PROPERTY_MODEL_CHANGED = 1;
    private Vector<DataTableListener> listeners = null;
    private boolean listenersEnabled = true;
    private boolean recalcWidth = false;
    private int firstDisplayRow = 0;
    private int lastDisplayRow = 0;
    private int firstDisplayCol = 0;
    private int lastDisplayCol = 0;

    public int getRowHeight() {
        return this.iRowHeight;
    }

    @BeanProperty(preferred=true, description="The color of text in selected cells")
    public void setSelectedForecolor(Color color) {
        this.selectedForecolor = color;
    }

    @BeanProperty(preferred=true, description="The default background color of cells")
    public void setBackcolor(Color color) {
        this.backcolor = color;
    }

    @BeanProperty(preferred=true, description="The default foreground color of cells")
    public void setForecolor(Color color) {
        this.forecolor = color;
    }

    public Color getSelectedBackcolor() {
        return this.selectedBackcolor;
    }

    public Color getSelectedForecolor() {
        return this.selectedForecolor;
    }

    public Color getBackcolor() {
        return this.backcolor;
    }

    public Color getForecolor() {
        return this.forecolor;
    }

    @BeanProperty(preferred=true, description="The background color of selected cells")
    public void setSelectedBackcolor(Color color) {
        this.selectedBackcolor = color;
    }

    @BeanProperty(preferred=true, description="The border color of a selection")
    public void setSelectedBordercolor(Color color) {
        this.selectedBordercolor = color;
    }

    public Color getSelectedBordercolor() {
        return this.selectedBordercolor;
    }

    public FontMetrics getFontMetrics() {
        return this.fMetrics;
    }

    public DataTableModel getModel() {
        return this.model;
    }

    public void setModel(DataTableModel model) {
        if (model != null) {
            if (this.model != null) {
                this.model.removeListener(this);
            }
            this.model = model;
            model.addListener(this);
            this.columns.clear();
            if (model.getColumnCount() > 0) {
                for (int x = 0; x < model.getColumnCount(); ++x) {
                    this.columns.append(new Column());
                }
            }
            this.reDraw(true);
        }
    }

    public void setUpdateAfterAppend(boolean update) {
        this.updateAfterAppend = update;
        if (this.updateAfterAppend) {
            this.reDraw(true);
        }
    }

    public void setRowSelect(boolean select) {
        this.rowSelect = select;
        if (select) {
            this.colSelect = false;
        }
    }

    public void setColSelect(boolean select) {
        this.colSelect = select;
        if (select) {
            this.rowSelect = false;
        }
    }

    public DataTable() {
        this.init();
    }

    public Column getColumn(int index) {
        return this.columns.get(index);
    }

    public int getColumnWidth(int index) {
        return this.columns.get((int)index).width;
    }

    public int getColumnCellAlignment(int index) {
        return this.columns.get(index).getCellAlignment();
    }

    @Override
    public void displayPanelMouseWheelMoved(MouseWheelEvent e) {
        if (e.isControlDown()) {
            if (e.getWheelRotation() > 0) {
                this.decFontSize();
            } else {
                this.incFontSize();
            }
        } else if (!e.isShiftDown()) {
            if (e.getWheelRotation() > 0) {
                this.vScroll.setValue(this.vScroll.getValue() + 1L);
            } else {
                this.vScroll.setValue(this.vScroll.getValue() - 1L);
            }
        } else if (e.getWheelRotation() > 0) {
            this.hScroll.setValue(this.hScroll.getValue() + 1L);
        } else {
            this.hScroll.setValue(this.hScroll.getValue() - 1L);
        }
    }

    private void init() {
        Color color = UIManager.getColor("Table.background");
        if (color != null) {
            this.backcolor = color;
        }
        if ((color = UIManager.getColor("Table.marginBackground")) != null) {
            this.margincolor = color;
        }
        if ((color = UIManager.getColor("Table.foreground")) != null) {
            this.forecolor = color;
        }
        if ((color = UIManager.getColor("Table.selectionBackground")) != null) {
            this.selectedBackcolor = color;
        }
        if ((color = UIManager.getColor("Table.selectionForeground")) != null) {
            this.selectedForecolor = color;
        }
        if ((color = UIManager.getColor("Table.gridColor")) != null) {
            this.gridColor = color;
        }
        if ((color = UIManager.getColor("TableHeader.gridColor")) != null) {
            this.selectedBordercolor = color;
            this.columnHeaderDividerColor = color;
        }
        if ((color = UIManager.getColor("TableHeader.background")) != null) {
            this.columnHeaderBackColor = color;
            this.rowRenderer.setBackground(color);
        }
        if ((color = UIManager.getColor("TableHeader.foreground")) != null) {
            this.columnHeaderForeColor = color;
            this.rowRenderer.setForeground(color);
        }
        this.setModel(new BasicDataTableModel());
        this.vScroll = this.getVScrollBar();
        this.vScroll.setValues(0, 0, 0, 0, true);
        this.hScroll = this.getHScrollBar();
        this.hScroll.setValues(0, 0, 0, 0, true);
        this.setShowRowHeaders(true);
        this.setHandleMouse(true);
        this.setHandleMouseMotion(true);
        this.setHandleMouseWheel(true);
        this.setHandleFocusLost(true);
        this.setHandleKeys(true);
        this.setShowColumnHeaders(true);
        this.setColumnHeadings("A", "B");
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (DataTable.this.activeEditor != null) {
                    DataTable.this.activeEditor.cancelEdit();
                }
            }
        });
        this.vScroll.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (DataTable.this.activeEditor != null) {
                    DataTable.this.activeEditor.cancelEdit();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.hScroll.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (DataTable.this.activeEditor != null) {
                    DataTable.this.activeEditor.cancelEdit();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
    }

    @Override
    public void displayPanelFocusLost() {
    }

    @BeanProperty(hidden=true)
    public int getSelectionStartCol() {
        return this.selection.getFirstCol();
    }

    @BeanProperty(hidden=true)
    public int getSelectionEndCol() {
        return this.selection.getLastCol();
    }

    @BeanProperty(hidden=true)
    public int getSelectionStartRow() {
        return this.selection.getFirstRow();
    }

    @BeanProperty(hidden=true)
    public int getSelectionEndRow() {
        return this.selection.getLastRow();
    }

    @Override
    public void displayPanelMousePressed(MouseEvent e) {
        this.hideEditors();
        int x = e.getX();
        int y = e.getY();
        if (y < this.iRowHeight && this.showColHeaders) {
            if (e.getClickCount() > 1) {
                this.autoAdjustColumn(this.colIndex(x));
                this.adjustHScroll();
                this.reDraw(true);
            } else {
                this.draggedCol = null;
                if (this.showRowHeaders && this.rowHeader != null && x > this.rowHeader.right - 7 && x < this.rowHeader.right + 7) {
                    this.draggedCol = this.rowHeader;
                    this.dragStart = e.getLocationOnScreen();
                    this.displayPanel.setCursor(this.resizeCursor);
                } else if (this.showColHeaders && y <= this.iRowHeight || !this.showColHeaders) {
                    x += this.offsetX;
                    for (int i = this.model.getColumnCount() - 1; i >= 0; --i) {
                        if (x <= ((Column[])this.columns.items)[i].right - 7 || x >= ((Column[])this.columns.items)[i].right + 7) continue;
                        this.draggedCol = ((Column[])this.columns.items)[i];
                        this.bDrag = true;
                        this.dragStart = e.getLocationOnScreen();
                        return;
                    }
                }
                this.bDrag = false;
            }
            return;
        }
        if (e.isShiftDown()) {
            this.selection.extend(x, y);
            this.fireEvents(0);
        } else {
            int cCount = e.getClickCount();
            this.selection.select(this.colIndex(x), this.rowIndex(y));
            this.fireEvents(0);
            if (cCount > 1 && !this.rowSelect && this.selection.hasSelection()) {
                this.startEditCell(x, y);
            }
        }
    }

    private void fireEvents(int ... events) {
        if (this.listeners != null && this.listenersEnabled) {
            for (DataTableListener l : this.listeners) {
                l.tablePropertyChanged(events);
            }
        }
    }

    public void addDataTableListener(DataTableListener l) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeDataTableListener(DataTableListener l) {
        if (this.listeners != null && this.listeners.contains(l)) {
            this.listeners.remove(l);
        }
    }

    @Override
    public void displayPanelMouseReleased(MouseEvent e) {
        if (this.draggedCol != null) {
            this.bDrag = false;
            this.draggedCol = null;
            this.dragStart = null;
            this.displayPanel.setCursor(this.defaultCursor);
        }
    }

    @Override
    public void displayPanelMouseMoved(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (this.showRowHeaders && this.rowHeader != null && x > this.rowHeader.right - 7 && x < this.rowHeader.right + 7) {
            if (!this.bDrag && this.rowHeader.resizable) {
                this.displayPanel.setCursor(this.resizeCursor);
                this.bDrag = true;
            }
            return;
        }
        if (this.showColHeaders && y <= this.iRowHeight || !this.showColHeaders) {
            for (int i = this.model.getColumnCount() - 1; i >= 0; --i) {
                if (x <= ((Column[])this.columns.items)[i].right - this.offsetX - 7 || x >= ((Column[])this.columns.items)[i].right - this.offsetX + 7) continue;
                this.displayPanel.setCursor(this.resizeCursor);
                this.bDrag = true;
                return;
            }
        }
        if (this.bDrag) {
            this.displayPanel.setCursor(this.defaultCursor);
            this.bDrag = false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void displayPanelMouseDragged(MouseEvent e) {
        if (e.isPopupTrigger() || e.isMetaDown()) {
            return;
        }
        if (this.draggedCol != null && this.dragStart != null) {
            int w;
            Point screenXY = e.getLocationOnScreen();
            int newWd = this.draggedCol.width + screenXY.x - this.dragStart.x;
            if (newWd <= 15) return;
            this.draggedCol.width = w = Math.max(this.draggedCol.width + screenXY.x - this.dragStart.x, 15);
            this.draggedCol.right = this.draggedCol.left + w - 1;
            if (this.draggedCol.relWidth > 0.0f) {
                this.draggedCol.relWidth = w / this.panelWidth;
            }
            this.adjustColumns(this.draggedCol.index);
            this.columnsManuallyAdjusted = true;
            this.dragStart = screenXY;
            this.adjustHScroll();
            this.resetBuffer();
        } else {
            this.selection.extend(e.getX(), e.getY());
        }
        this.reDraw(false);
    }

    void hideEditors() {
        if (this.activeEditor != null) {
            this.activeEditor.setVisible(false);
            this.activeEditor = null;
        }
    }

    public void setColumnEditor(int column, CellEditor editor) {
        Column col = this.columns.get(column);
        if (col != null) {
            col.editor = editor;
        }
    }

    public boolean beforeEdit(int col, int row) {
        return true;
    }

    public void afterEdit(int col, int row) {
    }

    public void editCancelled(int col, int row) {
    }

    public int getColumnIndexAt(int x) {
        x += this.offsetX;
        for (int i = this.model.getColumnCount() - 1; i >= 0; --i) {
            if (x < ((Column[])this.columns.items)[i].left || x > ((Column[])this.columns.items)[i].right) continue;
            return i;
        }
        return -1;
    }

    private void startEditCell(int x, int y) {
        this.hideEditors();
        int col = this.colIndex(x);
        int row = this.rowIndex(y);
        if (col == -1 || row == -1) {
            return;
        }
        if (!this.model.isCellEditable(col, row)) {
            return;
        }
        Column column = this.columns.get(col);
        if (column == null || !column.editable) {
            return;
        }
        CellEditor editor = this.getCellEditor(col, row);
        if (editor != null && this.beforeEdit(col, row)) {
            editor.startEdit(this, col, row, column.left - this.offsetX, this.rowTop(y) + 2, column.width + 2, this.iRowHeight + 1);
        }
    }

    private void incFontSize() {
        Font font = this.fFont.deriveFont((float)this.fFont.getSize() + 1.0f);
        this.setFont(font);
        this.adjustVScroll();
        this.adjustHScroll();
    }

    private void decFontSize() {
        this.setFont(this.fFont.deriveFont((float)this.fFont.getSize() - 1.0f));
        this.adjustVScroll();
        this.adjustHScroll();
    }

    void resetBuffer() {
        this.buffer = null;
        if (this.bufferGraphics != null) {
            this.bufferGraphics.dispose();
            this.bufferGraphics = null;
        }
    }

    @Override
    public void displayPanelResized(int Width, int Height) {
        this.resetBuffer();
        this.hideEditors();
        this.panelHeight = Height;
        this.panelWidth = Width;
        this.adjustColumns(0);
        this.adjustVScroll();
        this.adjustHScroll();
    }

    public boolean isShowRowHeaders() {
        return this.showRowHeaders;
    }

    @BeanProperty(preferred=true, description="Whether the row headers are shown by default.")
    public void setShowRowHeaders(boolean show) {
        this.showRowHeaders = show;
        if (show) {
            this.rowHeader.width = 25;
            this.rowHeader.right = 25;
            this.rowHeader.index = -1;
        } else if (!show && this.rowHeader != null) {
            this.rowHeader.width = 0;
        }
        this.adjustColumns(0);
    }

    @Override
    public void customDisplayPaint(Graphics g, int width, int height) {
        if (width <= 0 || height <= 0) {
            return;
        }
        if (this.buffer == null || width != this.panelWidth || height != this.panelHeight) {
            this.panelHeight = height;
            this.panelWidth = width;
            this.buffer = new BufferedImage(width, height, 6);
            this.bufferGraphics = (Graphics2D)this.buffer.getGraphics();
            this.bufferGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.fMetrics == null) {
                this.fMetrics = g.getFontMetrics();
                this.iRowHeight = this.fMetrics.getHeight() + 2;
                if (this.model.getColumnCount() > 0) {
                    for (int x = 0; x < this.columns.length; ++x) {
                        this.calcColTextWidth(x);
                    }
                    this.recalcWidth = false;
                    this.adjustColumns(0);
                }
            }
            this.bufferGraphics.setFont(this.fFont);
            if (this.iRowHeight == 0 || this.model.getColumnCount() > 0 && ((Column[])this.columns.items)[0].width == 0 && this.model.getRowCount() > 0) {
                int avgWd = width / this.model.getColumnCount();
                for (Column column : this.columns) {
                    column.width = avgWd;
                }
                this.adjustColumns(0);
                this.adjustHScroll(false);
                this.adjustVScroll(false);
            }
            this.topY = this.showColHeaders ? this.iRowHeight + 1 : 0;
            this.rowsVisible = (this.panelHeight - this.topY) / this.iRowHeight;
            int rm = this.rightmost - this.offsetX;
            this.bufferGraphics.setColor(this.columnHeaderBackColor);
            this.bufferGraphics.fillRect(0, 0, this.panelWidth, this.iRowHeight);
            this.bufferGraphics.fillRect(0, 0, this.leftMost, this.panelHeight);
            this.bufferGraphics.setColor(this.backcolor);
            this.bufferGraphics.fillRect(this.leftMost, this.topY, rm, this.panelHeight);
            int curY = this.topY;
            if (this.model.getRowCount() > 0) {
                this.firstDisplayRow = this.rowIndex(this.topY);
                this.lastDisplayRow = this.rowIndex(this.panelHeight);
                this.firstDisplayCol = this.colIndex(this.leftMost);
                this.lastDisplayCol = this.colIndex(this.panelWidth);
                int rowIndex = this.firstDisplayRow;
                while (rowIndex <= this.lastDisplayRow) {
                    for (int colIndex = this.firstDisplayCol; colIndex < this.model.getColumnCount(); ++colIndex) {
                        CellRenderer r;
                        int left2 = ((Column[])this.columns.items)[colIndex].left - this.offsetX;
                        int left = Math.max(this.leftMost, left2);
                        int right = ((Column[])this.columns.items)[colIndex].right - this.offsetX;
                        if (!(right > this.leftMost && right < width || left > this.leftMost && left < width) && (left > this.leftMost || right < width) || (r = this.getCellRenderer(colIndex, rowIndex)) == null) continue;
                        r.draw(this, colIndex, rowIndex, false);
                        this.bufferGraphics.setClip(left, curY, right, curY + this.iRowHeight - 5);
                        this.bufferGraphics.drawImage((Image)r.getImage(), left2, curY, null);
                        this.bufferGraphics.setClip(null);
                    }
                    ++rowIndex;
                    curY += this.iRowHeight;
                }
                if (this.showRowHeaders) {
                    this.drawRowLabels(this.firstDisplayRow, this.lastDisplayRow);
                }
            }
            if (this.showColHeaders) {
                this.drawColumnLabels();
            }
            if (this.hScroll.isVisible()) {
                this.hScroll.repaint();
            }
            if (this.vScroll.isVisible()) {
                this.vScroll.repaint();
            }
        }
        g.drawImage(this.buffer, 0, 0, null);
        if (this.selection.hasSelection()) {
            int maxRow = Math.min(this.offsetY + height / this.iRowHeight, this.model.getRowCount());
            int firstRow = Math.max(this.offsetY, this.selection.getFirstRow());
            int lastRow = Math.min(this.selection.getLastRow(), maxRow);
            int firstCol = Math.max(this.selection.getFirstCol(), 0);
            int lastCol = this.selection.getLastCol();
            int curY = this.topY + (firstRow - this.offsetY) * this.iRowHeight;
            for (int rowIndex = firstRow; rowIndex <= lastRow; ++rowIndex) {
                for (int colIndex = firstCol; colIndex <= lastCol; ++colIndex) {
                    int left2 = ((Column[])this.columns.items)[colIndex].left - this.offsetX;
                    int left = Math.max(this.leftMost, left2);
                    int right = ((Column[])this.columns.items)[colIndex].right - this.offsetX;
                    if (right > this.leftMost && right < width || left > this.leftMost && left < width || left <= this.leftMost && right >= width) {
                        CellRenderer r = this.getCellRenderer(colIndex, rowIndex);
                        if (r == null) continue;
                        r.draw(this, colIndex, rowIndex, true);
                        g.setClip(left, curY, right, curY + this.iRowHeight - 5);
                        g.drawImage(r.getImage(), left2, curY, null);
                        g.setClip(null);
                        continue;
                    }
                    if (right >= width) break;
                }
                curY += this.iRowHeight;
            }
        }
        if (this.activeEditor != null) {
            this.displayPanel.paintComponents(g);
        }
    }

    public CellEditor getActiveCellEditor() {
        return this.activeEditor;
    }

    public void setColumnCellRenderer(int colIndex, CellRenderer renderer) {
        Column dest;
        if (renderer != null && (dest = this.getColumn(colIndex)) != null) {
            dest.columnCellsRenderer = renderer;
        }
    }

    public CellRenderer getColumnCellRenderer(int colIndex) {
        Column dest = this.getColumn(colIndex);
        return dest != null ? dest.columnCellsRenderer : null;
    }

    public CellRenderer getCellRenderer(int colIndex, int rowIndex) {
        return this.getColumnCellRenderer(colIndex);
    }

    public void setColumnCellEditor(int colIndex, CellEditor editor) {
        Column dest;
        if (editor != null && (dest = this.getColumn(colIndex)) != null) {
            dest.editor = editor;
        }
    }

    public CellEditor getColumnCellEditor(int colIndex) {
        Column dest = this.getColumn(colIndex);
        return dest != null ? dest.editor : null;
    }

    public CellEditor getCellEditor(int colIndex, int rowIndex) {
        return this.getColumnCellEditor(colIndex);
    }

    private int getTextWidth(Object value) {
        if (value == null || this.fMetrics == null) {
            return 0;
        }
        return this.fMetrics.stringWidth(String.valueOf(value));
    }

    private int calcColTextWidth(int index) {
        Object value = this.model.getColumn(index);
        if (value == null || this.fMetrics == null) {
            return 0;
        }
        return this.fMetrics.stringWidth(String.valueOf(value));
    }

    private void highlightCell(Graphics gImage, int x1, int y1, int w, int h) {
        gImage.setColor(this.selectedBackcolor);
        gImage.fillRect(x1, y1, w, h);
        gImage.setColor(this.selectedBordercolor);
        gImage.drawRect(x1, y1, w, h);
    }

    private void highlightCell(Graphics gImage, int col, int y) {
        gImage.setColor(this.selectedBackcolor);
        int x1 = Math.max(this.leftMost, ((Column[])this.columns.items)[col].left - this.offsetX - 1);
        int w = ((Column[])this.columns.items)[col].right - x1 - this.offsetX;
        int ht = this.iRowHeight;
        gImage.fillRect(x1, y, w, ht);
        gImage.setColor(this.selectedBordercolor);
        gImage.drawRect(x1, y, w, ht);
    }

    public RowRenderer getRowHeaderRenderer(int rowIndex) {
        if (rowIndex >= 0 && rowIndex < this.model.getRowCount()) {
            return this.rowRenderer;
        }
        return null;
    }

    public CellRenderer getColumnHeaderRenderer(int colIndex) {
        if (colIndex >= 0 && colIndex < this.columns.length && ((Column[])this.columns.items)[colIndex] != null) {
            return ((Column[])this.columns.items)[colIndex].renderer;
        }
        return null;
    }

    void drawColumnLabels() {
        int rm = this.rightmost - this.offsetX;
        for (int index = 0; index < this.columns.length; ++index) {
            Column column = ((Column[])this.columns.items)[index];
            CellRenderer r = this.getColumnHeaderRenderer(index);
            if (r == null) continue;
            int left = Math.max(this.leftMost, column.left - this.offsetX);
            int left2 = column.left - this.offsetX;
            int right = column.right - this.offsetX;
            int wd = right - left;
            this.bufferGraphics.setClip(left, 0, wd, this.iRowHeight);
            r.draw(this, index, 0, false);
            this.bufferGraphics.drawImage((Image)r.getImage(), left2, 0, null);
            this.bufferGraphics.setClip(null);
            if (!this.showGrid || right <= this.leftMost) continue;
            this.bufferGraphics.setColor(this.columnHeaderDividerColor);
            this.bufferGraphics.drawLine(right, 0, right, this.iRowHeight - 1);
            if (this.gridColor != null) {
                this.bufferGraphics.setColor(this.gridColor);
            }
            this.bufferGraphics.drawLine(right, this.iRowHeight, right, this.panelHeight);
            this.bufferGraphics.setColor(Color.white);
            this.bufferGraphics.drawLine(++right, 0, right, this.iRowHeight - 1);
        }
        this.bufferGraphics.setColor(this.margincolor != null ? this.margincolor : this.columnHeaderBackColor);
        this.bufferGraphics.fillRect(((Column[])this.columns.items)[this.columns.size() - 1].right + 1, 0, this.panelWidth - ((Column[])this.columns.items)[this.columns.length - 1].right, this.showGrid ? this.panelHeight : this.iRowHeight);
        this.bufferGraphics.setColor(this.columnHeaderDividerColor);
        this.bufferGraphics.drawLine(0, 0, rm, 0);
        this.bufferGraphics.drawLine(0, this.iRowHeight, rm, this.iRowHeight);
        this.bufferGraphics.drawLine(this.leftMost, 0, this.leftMost, this.panelHeight);
    }

    void drawRowLabels(int startRow, int endRow) {
        int curY = this.topY;
        int rm = this.rightmost - this.offsetX;
        this.bufferGraphics.setColor(this.columnHeaderBackColor);
        this.bufferGraphics.fillRect(0, 0, this.leftMost, this.panelHeight);
        this.rowRenderer.setAlignment(4);
        this.rowRenderer.setBackground(this.columnHeaderBackColor);
        this.rowRenderer.setForeground(this.columnHeaderForeColor);
        this.rowRenderer.setSize(this.rowHeader.width, this.iRowHeight);
        this.rowRenderer.setFont(this.fFont);
        int rowIndex = startRow;
        while (rowIndex <= endRow) {
            RowRenderer r = this.getRowHeaderRenderer(rowIndex);
            if (r != null) {
                if (r != this.rowRenderer) {
                    r.setSize(this.rowHeader.width, this.iRowHeight);
                }
                r.draw(this, 0, rowIndex, false);
                this.bufferGraphics.drawImage((Image)r.getImage(), 0, curY, null);
            }
            if (this.showGrid) {
                int botY = curY + this.iRowHeight;
                this.bufferGraphics.setColor(this.columnHeaderDividerColor);
                this.bufferGraphics.drawLine(0, curY, this.rowHeader.width, curY);
                this.bufferGraphics.drawLine(0, botY, this.rowHeader.width, botY);
                this.bufferGraphics.setColor(this.gridColor != null ? this.gridColor : this.columnHeaderDividerColor);
                this.bufferGraphics.drawLine(this.rowHeader.width + 1, curY, rm, curY);
                this.bufferGraphics.drawLine(this.rowHeader.width + 1, botY, rm, botY);
            }
            ++rowIndex;
            curY += this.iRowHeight;
        }
        this.bufferGraphics.setColor(this.columnHeaderDividerColor);
        this.bufferGraphics.drawLine(this.leftMost, 0, this.leftMost, this.panelHeight);
    }

    private void adjustColumns(int column) {
        Column col;
        this.leftMost = this.showRowHeaders ? this.rowHeader.right : 0;
        if (this.columns.length == 0) {
            return;
        }
        if (column == -1 && this.leftMost > 0) {
            col = this.rowHeader;
        } else if (column > -1 && column < this.model.getColumnCount()) {
            col = ((Column[])this.columns.items)[column];
        } else {
            return;
        }
        if (column == 0) {
            col.left = this.leftMost;
        } else if (column > 0) {
            col.left = ((Column[])this.columns.items)[column - 1].right;
        }
        if (col.relWidth > 0.0f) {
            col.width = (int)((float)this.getWidth() * col.relWidth);
        }
        col.right = col.left + col.width;
        this.shiftColumns(column + 1);
    }

    private void shiftColumns(int column) {
        for (int x = column; x < this.model.getColumnCount(); ++x) {
            if (x == 0 && this.showRowHeaders && this.rowHeader != null) {
                ((Column[])this.columns.items)[x].left = this.rowHeader.right;
                ((Column[])this.columns.items)[x].right = ((Column[])this.columns.items)[x].left + ((Column[])this.columns.items)[x].width;
                continue;
            }
            if (x <= 0) continue;
            ((Column[])this.columns.items)[x].left = ((Column[])this.columns.items)[x - 1].right;
            ((Column[])this.columns.items)[x].right = ((Column[])this.columns.items)[x].left + ((Column[])this.columns.items)[x].width;
        }
        this.rightmost = ((Column[])this.columns.items)[this.columns.length - 1].right;
    }

    private void autoAdjustColumn(int column) {
        if (column == -1 && this.rowHeader != null) {
            this.rowHeader.width = this.fMetrics.stringWidth(String.valueOf(this.model.getRowCount())) + 4;
            this.leftMost = this.rowHeader.right = this.rowHeader.left + this.rowHeader.width;
            this.shiftColumns(0);
        } else {
            if (column < 0 || column >= this.columns.length) {
                return;
            }
            ((Column[])this.columns.items)[column].left = column == 0 ? this.leftMost : ((Column[])this.columns.items)[column - 1].right;
            ((Column[])this.columns.items)[column].relWidth = 0.0f;
            int maxWd = Math.max(15, this.getTextWidth(((Column[])this.columns.items)[column].value) + 4);
            for (int row = 0; row < this.model.getRowCount(); ++row) {
                Object value = this.model.getValue(column, row);
                if (value == null) continue;
                maxWd = Math.max(maxWd, this.getTextWidth(value) + 4);
            }
            ((Column[])this.columns.items)[column].width = maxWd;
            ((Column[])this.columns.items)[column].right = ((Column[])this.columns.items)[column].left + ((Column[])this.columns.items)[column].width;
            this.shiftColumns(column + 1);
        }
    }

    public void setColumnHeadings(Object ... labels) {
        if (labels == null || labels.length == 0) {
            return;
        }
        this.columns.clear();
        this.model.setColumns(labels);
        int colWid = this.getWidth() / this.model.getColumnCount();
        this.model.setListenerEnabled(false);
        for (int x = 0; x < labels.length; ++x) {
            this.model.setColumn(x, labels[x]);
            this.columns.append(new Column());
            ((Column[])this.columns.items)[x].setValue(labels[x]);
            ((Column[])this.columns.items)[x].width = colWid;
            ((Column[])this.columns.items)[x].index = x;
        }
        this.model.setListenerEnabled(true);
        this.clearSelection();
        this.adjustColumns(0);
        this.adjustHScroll();
        this.reDraw(true);
    }

    void reDraw(boolean resetBuffers) {
        if (resetBuffers) {
            this.resetBuffer();
        }
        this.displayPanel.repaint();
    }

    public Object getValue(int col, int row) {
        return this.model.getValue(col, row);
    }

    public void setRow(int rowIndex, Object ... values) {
        this.model.setRow(rowIndex, values);
    }

    public void removeRow(int row) {
        this.model.removeRow(row);
        if (row > this.model.getRowCount() - 1) {
            this.selection.select(0, this.model.getRowCount() - 1);
        }
    }

    public int addRow(Object ... values) {
        return this.model.addRow(values);
    }

    public void setValue(int column, int row, Object value) {
        this.model.setValue(column, row, value);
    }

    public void swapRows(int row1, int row2) {
        this.model.swap(row1, row2);
    }

    public void swapRows(int row1, int row2, boolean reDraw) {
        boolean enabled = this.model.disableListener();
        if (this.model.swap(row1, row2) && reDraw) {
            this.reDraw(true);
        }
        this.model.setListenerEnabled(enabled);
    }

    public void updateDisplay() {
        this.iY = this.iRowHeight * this.model.getRowCount();
        this.adjustVScroll();
    }

    void adjustVScroll() {
        this.adjustVScroll(true);
    }

    void adjustVScroll(boolean update) {
        if (this.iRowHeight == 0) {
            return;
        }
        int value = this.iY / this.iRowHeight;
        int visible = Math.max(0, this.panelHeight / this.iRowHeight - 1);
        int maximum = Math.max(0, this.model.getRowCount() - visible + 1);
        if (visible >= this.model.getRowCount()) {
            value = 0;
            maximum = 0;
            this.offsetY = 0;
        } else if (value > maximum) {
            value = maximum;
        }
        this.vScroll.setValues(value, visible, 0, maximum, update);
        this.iY = this.iRowHeight * value;
    }

    void adjustHScroll() {
        this.adjustHScroll(true);
    }

    void adjustHScroll(boolean update) {
        if (this.model.getColumnCount() == 0) {
            return;
        }
        if (this.rightmost >= this.panelWidth) {
            int value = (int)this.hScroll.getValue();
            int max = this.rightmost - this.panelWidth;
            if (value > 0) {
                value = (int)((float)value / (float)this.hScroll.getMaximum() * (float)max);
            }
            if (value > max) {
                value = 0;
            }
            this.hScroll.setValues(value, max / 10, 0, max, update);
        } else {
            this.hScroll.setValues(0, 0, 0, 0, update);
        }
    }

    @Override
    public void vScrollValueChanged(long newValue) {
        this.offsetY = (int)newValue;
        this.iY = this.iRowHeight * (int)newValue;
        if (this.activeEditor != null) {
            this.activeEditor.cancelEdit();
        }
        this.reDraw(true);
    }

    @Override
    public void hScrollValueChanged(long newValue) {
        this.offsetX = (int)newValue;
        if (this.activeEditor != null) {
            this.activeEditor.cancelEdit();
        }
        this.reDraw(true);
    }

    private void scroll(int inc) {
        this.vScroll.setValue(this.vScroll.getValue() + (long)inc);
        this.iY = this.iRowHeight * (int)this.vScroll.getValue();
    }

    private void shift(int colShift, int rowShift, boolean extendSelection) {
        if (extendSelection) {
            this.selection.extendTo(this.selection.colDot + colShift, this.selection.rowDot + rowShift);
        } else {
            this.selection.select(this.selection.colDot + colShift, this.selection.rowDot + rowShift);
        }
    }

    @Override
    public boolean displayPanelKeyPressed(KeyEvent e) {
        int key = e.getKeyCode();
        switch (key) {
            case 8: 
            case 127: {
                this.clearSelection();
                return true;
            }
            case 38: {
                this.shift(0, -1, e.isShiftDown());
                return true;
            }
            case 40: {
                this.shift(0, 1, e.isShiftDown());
                return true;
            }
            case 39: {
                this.shift(1, 0, e.isShiftDown());
                return true;
            }
            case 37: {
                this.shift(-1, 0, e.isShiftDown());
                return true;
            }
            case 33: {
                this.shift(0, -10, e.isShiftDown());
                return true;
            }
            case 34: {
                this.shift(0, 10, e.isShiftDown());
                return true;
            }
        }
        return false;
    }

    protected int rowIndex(int y) {
        if (y > this.panelHeight || this.iRowHeight == 0) {
            return -1;
        }
        return Math.max(0, Math.min(this.model.getRowCount() - 1, this.showColHeaders ? y / this.iRowHeight + this.offsetY - 1 : y / this.iRowHeight + this.offsetY));
    }

    protected int rowTop(int y) {
        int rIndex = this.rowIndex(y);
        if (rIndex == -1) {
            return -1;
        }
        return (rIndex - this.offsetY + 1) * this.iRowHeight;
    }

    protected int colIndex(int x) {
        if (this.model.getColumnCount() == 0 || x > this.panelWidth || x < this.leftMost) {
            return -1;
        }
        x += this.offsetX;
        for (int colIndex = 0; colIndex < this.model.getColumnCount(); ++colIndex) {
            if (((Column[])this.columns.items)[colIndex].right <= x) continue;
            return colIndex;
        }
        return -1;
    }

    private void setCBText(String text) {
        Clipboard clip = this.getToolkit().getSystemClipboard();
        if (clip == null) {
            return;
        }
        StringSelection data = new StringSelection(text);
        clip.setContents(data, this);
    }

    public void copySelected(boolean includeHeaders) {
        if (this.rowSelect) {
            this.setCBText(this.getRows(this.selection.getFirstRow(), this.selection.getLastRow(), includeHeaders));
        } else {
            this.setCBText(this.getRange(this.selection.getFirstRow(), this.selection.getFirstCol(), this.selection.getLastRow(), this.selection.getLastCol(), includeHeaders));
        }
    }

    public void copyAll(boolean includeHeaders) {
        this.setCBText(this.getRows(0, this.model.getRowCount() - 1, includeHeaders));
    }

    public void clearSelection() {
        this.selection.reset();
        this.hideEditors();
        this.adjustVScroll();
        this.reDraw(false);
    }

    public void clear() {
        this.model.clear();
        this.clearSelection();
    }

    public void selectAll() {
        this.selection.selectAll();
        this.reDraw(false);
        this.fireEvents(0);
    }

    public String getRow() {
        return this.getRows(0, this.model.getRowCount() - 1, false);
    }

    public String getRow(int row) {
        return this.getRows(row, row, false);
    }

    public String getRows(int firstRow, int lastRow, boolean includeHeaders) {
        return this.getRange(firstRow, 0, lastRow, this.model.getColumnCount() - 1, includeHeaders);
    }

    public String getRange(int firstRow, int firstCol, int lastRow, int lastCol, boolean includeHeaders) {
        if (this.model.getRowCount() == 0 || this.model.getColumnCount() == 0) {
            return "";
        }
        firstRow = Math.max(0, Math.min(firstRow, this.model.getRowCount() - 1));
        lastRow = Math.max(0, Math.min(lastRow, this.model.getRowCount() - 1));
        firstCol = Math.max(0, Math.min(firstCol, this.model.getColumnCount() - 1));
        lastCol = Math.max(0, Math.min(lastCol, this.model.getColumnCount() - 1));
        int firstLine = Math.min(firstRow, lastRow);
        int lastLine = Math.max(firstRow, lastRow);
        int colFirst = Math.min(firstCol, lastCol);
        int colLast = Math.max(firstCol, lastCol);
        StringBuilder sb = new StringBuilder();
        if (includeHeaders) {
            for (int j = colFirst; j <= colLast; ++j) {
                if (j > colFirst) {
                    sb.append("\t");
                }
                sb.append(String.valueOf(this.model.getColumn(j)));
            }
            if (sb.length() > 0) {
                sb.append("\n");
            }
        }
        for (int i = firstLine; i <= lastLine; ++i) {
            if (i > firstLine) {
                sb.append("\n");
            }
            for (int j = colFirst; j <= colLast; ++j) {
                Object value;
                if (j > colFirst) {
                    sb.append("\t");
                }
                sb.append((value = this.model.getValue(j, i)) != null ? value : "");
            }
        }
        return sb.toString();
    }

    public String getTable() {
        String colHeaders = this.getColumnHeadings();
        String cellData = this.getRow();
        if (colHeaders.length() == 0 && cellData.length() == 0) {
            return "";
        }
        if (colHeaders.length() > 0 && cellData.length() == 0) {
            return colHeaders;
        }
        if (colHeaders.length() == 0 && cellData.length() > 0) {
            return cellData;
        }
        return colHeaders + "\n" + cellData;
    }

    public String getColumnHeadings() {
        if (this.model.getColumnCount() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int x = 0; x < this.model.getColumnCount(); ++x) {
            if (x > 0) {
                sb.append("\t");
            }
            sb.append(String.valueOf(this.model.getColumn(x)));
        }
        return sb.toString();
    }

    public int getLineCount() {
        return this.model.getRowCount();
    }

    public void setLine(int row, String s) {
        this.addRow(row, s.split("\t"));
    }

    public void setLine(int row, Object ... values) {
        this.setRow(row, values);
    }

    public void setLine(int row, int col, String s) {
        this.model.setValue(col, row, s);
    }

    @BeanProperty(hidden=true)
    public int getSelectionRowStart() {
        return this.selection.getFirstRow();
    }

    @BeanProperty(hidden=true)
    public int getSelectionRowEnd() {
        return this.selection.getLastRow();
    }

    @BeanProperty(hidden=true)
    public int getSelectionColStart() {
        return this.selection.getFirstCol();
    }

    @BeanProperty(hidden=true)
    public int getSelectionColEnd() {
        return this.selection.getLastCol();
    }

    public void scrollToTop() {
        this.vScroll.setValue(0);
        this.iY = 0;
        this.adjustHScroll();
        this.reDraw(true);
    }

    @BeanProperty(preferred=true, description="Whether the column headers are shown by default.")
    public void setShowColumnHeaders(boolean show) {
        this.showColHeaders = show;
        this.reDraw(true);
    }

    public boolean isShowColumnHeaders() {
        return this.showColHeaders;
    }

    public void setColumnAlignment(int column, int align) {
        if (column >= 0 && column < this.model.getColumnCount()) {
            if (((Column[])this.columns.items)[column] == null) {
                ((Column[])this.columns.items)[column] = new Column();
            }
            ((Column[])this.columns.items)[column].setHeaderAlignment(align);
        }
        this.reDraw(true);
    }

    public void setColumnCellAlignment(int column, int align) {
        if (column >= 0 && column < this.model.getColumnCount()) {
            ((Column[])this.columns.items)[column].setCellAlignment(align);
        }
        this.reDraw(true);
    }

    public void autoResizeColumns() {
        if (this.model.getColumnCount() > 0 && this.fMetrics != null) {
            for (int x = 0; x < this.model.getColumnCount(); ++x) {
                this.autoAdjustColumn(x);
            }
            this.adjustHScroll();
            this.reDraw(true);
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.fMetrics = null;
        this.fFont = font;
        this.recalcWidth = true;
    }

    public void select(int colIndex, int rowIndex) {
        this.selection.select(colIndex, rowIndex);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public void setColumnUseRelativeSize(int columnIndex, boolean useRelativeSize) {
        if (columnIndex >= 0 && columnIndex < this.model.getColumnCount()) {
            ((Column[])this.columns.items)[columnIndex].relWidth = ((Column[])this.columns.items)[columnIndex].width / this.panelWidth;
        }
    }

    public void setColumnRelativeSize(int columnIndex, float relativeWidth) {
        this.setColumnRelativeSize(columnIndex, relativeWidth, false, true);
    }

    public void setColumnRelativeSize(int columnIndex, float relativeWidth, boolean setColumnWidthRelative) {
        this.setColumnRelativeSize(columnIndex, relativeWidth, setColumnWidthRelative, true);
    }

    public void setColumnRelativeSize(int columnIndex, float relativeWidth, boolean setColumnWidthRelative, boolean redraw) {
        if (columnIndex >= 0 && columnIndex < this.model.getColumnCount()) {
            ((Column[])this.columns.items)[columnIndex].width = (int)(relativeWidth * (float)this.panelWidth);
            if (setColumnWidthRelative) {
                ((Column[])this.columns.items)[columnIndex].relWidth = relativeWidth;
            }
            if (redraw) {
                this.updateDisplay();
                this.columnsManuallyAdjusted = true;
                this.adjustHScroll();
            }
        }
    }

    public void setColumnRelativeSizes(int[] columnIndex, float[] relativeWidth) {
        if (columnIndex.length != relativeWidth.length) {
            return;
        }
        for (int x = 0; x < columnIndex.length; ++x) {
            if (columnIndex[x] < 0 || columnIndex[x] >= this.model.getColumnCount()) continue;
            ((Column[])this.columns.items)[columnIndex[x]].relWidth = relativeWidth[x];
            ((Column[])this.columns.items)[columnIndex[x]].width = -1;
        }
        this.updateDisplay();
        this.columnsManuallyAdjusted = true;
        this.adjustHScroll();
    }

    private void resetColumnHeaders() {
        this.columns.clear();
        int colCount = this.model.getColumnCount();
        if (colCount == 0) {
            return;
        }
        for (int x = 0; x < colCount; ++x) {
            this.columns.append(new Column());
        }
    }

    Column getColumnHeader(int index) {
        return this.columns.get(index);
    }

    @Override
    public void dataTableChanged(DataTableModelEvent ... events) {
        for (DataTableModelEvent event : events) {
            switch (event.type) {
                case -1: {
                    if (event.firstColumn != -1) {
                        this.columns.delete(event.firstColumn, event.lastColumn);
                        this.adjustVScroll();
                        this.reDraw(true);
                        return;
                    }
                }
                case 1: {
                    if (event.firstColumn == -1 || event.lastColumn == -1) break;
                    for (int x = event.firstColumn; x <= event.lastColumn; ++x) {
                        this.columns.insert(new Column(), event.firstColumn);
                    }
                    this.adjustVScroll();
                    this.reDraw(true);
                    return;
                }
            }
            if (!(event.firstRow >= this.firstDisplayRow && event.firstRow < this.lastDisplayRow || event.lastRow >= this.firstDisplayRow && event.lastRow < this.lastDisplayRow || event.firstColumn >= this.firstDisplayCol && event.firstColumn < this.lastDisplayCol) && (event.lastColumn < this.firstDisplayCol || event.lastRow >= this.lastDisplayCol)) continue;
            this.reDraw(true);
        }
        if (this.columns.length < this.model.getColumnCount()) {
            this.columns.clear();
            for (int index = 0; index < this.model.getColumnCount(); ++index) {
            }
        }
        this.adjustVScroll();
        this.reDraw(true);
    }

    private class Selection {
        int colDot = 0;
        int rowDot = 0;
        int rowMark = 0;
        int colMark = 0;

        private Selection() {
        }

        public int getFirstCol() {
            return this.colDot < this.colMark ? this.colDot : this.colMark;
        }

        public int getLastCol() {
            return this.colDot > this.colMark ? this.colDot : this.colMark;
        }

        public int getFirstRow() {
            return this.rowDot < this.rowMark ? this.rowDot : this.rowMark;
        }

        public int getLastRow() {
            return this.rowDot > this.rowMark ? this.rowDot : this.rowMark;
        }

        public boolean hasSelection() {
            return DataTable.this.model.getRowCount() > 0 && DataTable.this.model.getColumnCount() > 0 && this.length() > 0;
        }

        public int length() {
            return (this.getLastCol() - this.getFirstCol() + 1) * (this.getLastRow() - this.getFirstRow() + 1);
        }

        public void reset() {
            this.colDot = 0;
            this.rowDot = 0;
            this.rowMark = 0;
            this.colMark = 0;
        }

        public void select(int colIndex, int rowIndex) {
            this.setMark(colIndex, rowIndex);
            this.setDot(colIndex, rowIndex);
            DataTable.this.reDraw(this.verifyVisible());
        }

        public void extend(int x, int y) {
            int extRow = DataTable.this.rowIndex(Math.max(0, Math.min(y, DataTable.this.panelHeight - 1)));
            int extCol = DataTable.this.colIndex(Math.max(0, Math.min(x, DataTable.this.rightmost - 1)));
            this.setDot(extCol, extRow);
            DataTable.this.reDraw(this.verifyVisible());
        }

        public void extendTo(int colIndex, int rowIndex) {
            this.setDot(colIndex, rowIndex);
            DataTable.this.reDraw(this.verifyVisible());
        }

        private void setDot(int colIndex, int rowIndex) {
            this.rowDot = DataTable.this.colSelect ? DataTable.this.model.getRowCount() - 1 : this.validateRow(rowIndex);
            this.colDot = DataTable.this.rowSelect ? DataTable.this.model.getColumnCount() - 1 : this.validateColumn(colIndex);
        }

        private void setMark(int colIndex, int rowIndex) {
            this.rowMark = DataTable.this.colSelect ? 0 : this.validateRow(rowIndex);
            this.colMark = DataTable.this.rowSelect ? 0 : this.validateColumn(colIndex);
        }

        private int validateColumn(int colIndex) {
            return Math.min(Math.max(colIndex, 0), DataTable.this.model.getColumnCount() - 1);
        }

        private int validateRow(int rowIndex) {
            return Math.min(Math.max(rowIndex, 0), DataTable.this.model.getRowCount() - 1);
        }

        private void selectAll() {
            if (DataTable.this.model.getColumnCount() > 0 && DataTable.this.model.getRowCount() > 0) {
                this.setMark(0, 0);
                this.setDot(DataTable.this.model.getColumnCount() - 1, DataTable.this.model.getRowCount() - 1);
                DataTable.this.reDraw(this.verifyVisible());
            }
        }

        public boolean verifyVisible() {
            boolean redraw = false;
            if (((Column[])((DataTable)DataTable.this).columns.items)[DataTable.this.selection.colDot].left - DataTable.this.offsetX > DataTable.this.panelWidth) {
                DataTable.this.hScroll.setValue(((Column[])((DataTable)DataTable.this).columns.items)[DataTable.this.selection.colDot].left - DataTable.this.offsetX, true);
                redraw = true;
            }
            if (DataTable.this.selection.rowDot > DataTable.this.rowsVisible + DataTable.this.offsetY) {
                DataTable.this.vScroll.setValue(DataTable.this.selection.rowDot - DataTable.this.rowsVisible, true);
                redraw = true;
            } else if (DataTable.this.selection.rowDot < DataTable.this.offsetY) {
                DataTable.this.vScroll.setValue(DataTable.this.selection.rowDot, true);
                redraw = true;
            }
            return redraw;
        }

        public boolean contains(int row, int col) {
            return this.containsRow(row) && this.containsCol(col);
        }

        public boolean containsRow(int row) {
            return row >= this.getFirstRow() && row <= this.getLastRow();
        }

        public boolean containsCol(int col) {
            return col >= this.getFirstCol() && col <= this.getLastCol();
        }

        public int rowCount() {
            if (!this.hasSelection()) {
                return 0;
            }
            return this.getLastRow() - this.getFirstRow();
        }

        public int columnCount() {
            if (!this.hasSelection()) {
                return 0;
            }
            return this.getLastCol() - this.getFirstCol();
        }
    }
}

