/*
 * Decompiled with CFR 0.152.
 */
package EditorTable;

import EditorTable.ComponentCellEditor;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class CellEditorSpinner
extends ComponentCellEditor {
    JSpinner sEditor;
    SpinnerNumberModel model;

    public CellEditorSpinner(JSpinner spinner) {
        super(spinner);
    }

    public CellEditorSpinner() {
        this(new JSpinner());
    }

    public CellEditorSpinner(int min, int max) {
        this(new JSpinner());
        this.model = new SpinnerNumberModel();
        this.model.setMinimum(Integer.valueOf(min));
        this.model.setMaximum(Integer.valueOf(max));
        this.sEditor.setModel(this.model);
    }

    public void setMinimum(int min) {
        this.model.setMinimum(Integer.valueOf(min));
    }

    public void setMaximum(int max) {
        this.model.setMaximum(Integer.valueOf(max));
    }

    @Override
    public Object getEnteredValue() {
        return this.sEditor.getValue();
    }

    @Override
    public void setStartingValue(Object value) {
        super.setStartingValue(value);
        this.sEditor.setValue(value);
    }

    @Override
    public void init() {
        super.init();
        this.sEditor = (JSpinner)this.editor;
    }

    @Override
    public boolean beforeEdit() {
        if (!super.beforeEdit()) {
            return false;
        }
        JSpinner.DefaultEditor spinnerEditor = (JSpinner.DefaultEditor)this.sEditor.getEditor();
        int alignment = this.table.getColumnCellAlignment(this.colIndex);
        switch (alignment) {
            case 0: {
                spinnerEditor.getTextField().setHorizontalAlignment(0);
                break;
            }
            case 4: {
                spinnerEditor.getTextField().setHorizontalAlignment(4);
                break;
            }
            case 2: {
                spinnerEditor.getTextField().setHorizontalAlignment(2);
                break;
            }
        }
        this.sEditor.setValue(this.table.getModel().getValue(this.colIndex, this.rowIndex));
        return true;
    }
}

