/*
 * Decompiled with CFR 0.152.
 */
package EditorTable;

import EditorTable.ComponentCellEditor;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CellEditorSlider
extends ComponentCellEditor {
    LabeledSlider sEditor;

    public CellEditorSlider() {
        this(0, 100);
    }

    public CellEditorSlider(int min, int max) {
        super(new LabeledSlider());
        this.sEditor.setMinimum(min);
        this.sEditor.setMaximum(max);
        this.sEditor.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CellEditorSlider.this.sEditor.repaint();
            }
        });
    }

    public void setMinimum(int min) {
        this.sEditor.setMinimum(min);
    }

    public void setMaximum(int max) {
        this.sEditor.setMaximum(max);
    }

    @Override
    public Object getEnteredValue() {
        return this.sEditor.getValue();
    }

    @Override
    public void setStartingValue(Object value) {
        super.setStartingValue(value);
        if (value instanceof Integer) {
            Integer val = (Integer)value;
            this.sEditor.setValue(val);
        }
    }

    @Override
    public void init() {
        super.init();
        this.sEditor = (LabeledSlider)this.getEditor();
    }

    @Override
    public boolean beforeEdit() {
        if (!super.beforeEdit()) {
            return false;
        }
        Object value = this.table.getModel().getValue(this.colIndex, this.rowIndex);
        if (value instanceof Integer) {
            this.sEditor.setFont(this.table.getFont());
            Integer val = (Integer)value;
            this.sEditor.setValue(val);
            return true;
        }
        return false;
    }

    private static class LabeledSlider
    extends JSlider {
        Font font;

        @Override
        public void setFont(Font font) {
            this.font = font;
        }

        @Override
        public Font getFont() {
            return this.font;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setColor(Color.black);
            String valString = this.getModel().getValue() + "";
            FontMetrics fm = this.getFontMetrics(this.font);
            int ht = fm.getHeight();
            int wd = fm.stringWidth(valString);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.drawString(valString, (this.getWidth() - wd) / 2, this.getHeight() - ht / 3);
        }
    }
}

