/*
 * Decompiled with CFR 0.152.
 */
package EditorTable;

import EditorTable.DataTable;

public abstract class CellEditor {
    protected DataTable table;
    protected int colIndex;
    protected int rowIndex;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected Object startValue = null;
    protected Object enteredValue = null;
    boolean isEditing = false;

    public Object getEnteredValue() {
        return this.enteredValue;
    }

    public void setEnteredValue(Object value) {
        this.enteredValue = value;
    }

    public void setStartingValue(Object value) {
        this.startValue = value;
    }

    public Object getStartingValue() {
        return this.startValue;
    }

    public int getColumn() {
        return this.colIndex;
    }

    public int getRow() {
        return this.rowIndex;
    }

    public abstract boolean isVisible();

    public abstract void setVisible(boolean var1);

    public void init() {
    }

    public abstract boolean beforeEdit();

    public void afterEdit() {
    }

    public void afterCancel() {
    }

    public boolean isEditing() {
        return this.isEditing;
    }

    public void startEdit(DataTable table, int colIndex, int rowIndex, int x, int y, int width, int height) {
        this.table = table;
        this.colIndex = colIndex;
        this.rowIndex = rowIndex;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.setStartingValue(table.getModel().getValue(colIndex, rowIndex));
        this.isEditing = true;
    }

    public void applyEdit() {
        this.table.getModel().setValue(this.colIndex, this.rowIndex, this.getEnteredValue());
        this.afterEdit();
    }

    public void cancelEdit() {
        this.afterCancel();
        this.table.reDraw(true);
        this.isEditing = false;
    }
}

