/*
 * Decompiled with CFR 0.152.
 */
package EditorTable;

import EditorTable.Cell;
import EditorTable.DataTableModel;
import EditorTable.DataTableModelEvent;
import EditorTable.ExtensibleArray;
import EditorTable.Row;

public class BasicDataTableModel
extends DataTableModel {
    protected final ExtensibleArray<Row> dataRows = new ExtensibleArray<Row>(Row.class);
    protected final ExtensibleArray<Object> columns = new ExtensibleArray<Object>(Object.class);

    public BasicDataTableModel() {
        this.columns.append("Column 1");
        this.columns.append("Column 2");
        this.columns.append("Column 3");
        this.columns.append("Column 4");
    }

    @Override
    public void clear() {
        this.dataRows.clear();
        this.fireEvents(new DataTableModelEvent(this));
    }

    @Override
    public int getColumnCount() {
        return this.columns != null ? this.columns.length : 0;
    }

    @Override
    public int getRowCount() {
        return this.dataRows.length;
    }

    Cell getCell(int col, int row) {
        if (row < 0 || this.columns == null || this.columns.length <= col) {
            return null;
        }
        this.ensureRow(row);
        if (((Row[])this.dataRows.items)[row].cells[col] == null) {
            ((Row[])this.dataRows.items)[row].cells[col] = new Cell();
        }
        return ((Row[])this.dataRows.items)[row].cells[col];
    }

    @Override
    public boolean isCellEditable(int col, int row) {
        Cell selectedCell = this.getCell(col, row);
        return selectedCell != null ? selectedCell.editable : false;
    }

    @Override
    public void setValue(int col, int row, Object value) {
        this.ensureRow(row);
        Row dataRow = ((Row[])this.dataRows.items)[row];
        if (dataRow.isEmpty()) {
            dataRow.cells = new Cell[col];
        }
        if (value instanceof Cell) {
            dataRow.cells[col] = (Cell)value;
            return;
        }
        if (dataRow.cells[col] == null) {
            dataRow.cells[col] = new Cell(value);
        } else {
            dataRow.cells[col].value = value;
        }
        this.fireEvents(new DataTableModelEvent(this));
    }

    @Override
    public Object getValue(int col, int row) {
        return row >= this.dataRows.length || ((Row[])this.dataRows.items)[row].isEmpty() || ((Row[])this.dataRows.items)[row].cells.length < col ? null : ((Row[])this.dataRows.items)[row].cells[col].value;
    }

    private void ensureRow(int row) {
        if (row >= this.dataRows.length) {
            for (int x = this.dataRows.length - 1; x < row; ++x) {
                this.dataRows.append(new Row(this.columns.length));
            }
        } else if (((Row[])this.dataRows.items)[row] == null) {
            ((Row[])this.dataRows.items)[row] = new Row(this.columns.length);
        }
    }

    private void ensureColumn(int col) {
        if (col >= this.columns.length) {
            this.resizeColumn(col);
        } else if (this.columns.items[col] == null) {
            this.columns.items[col] = "";
        }
    }

    @Override
    public int addRow(Object ... values) {
        int rowIndex = this.dataRows.length;
        this.ensureRow(rowIndex);
        this.setRowValues(((Row[])this.dataRows.items)[rowIndex], values);
        this.fireEvents(new DataTableModelEvent(this, rowIndex, rowIndex, -1, -1, 1));
        return rowIndex;
    }

    @Override
    public void setRow(int row, Object ... values) {
        if (row < 0) {
            throw new IllegalArgumentException("index out of range: " + row);
        }
        this.ensureRow(row);
        this.setRowValues(((Row[])this.dataRows.items)[row], values);
        this.fireEvents(new DataTableModelEvent(this, row, row, -1, -1, 0));
    }

    private void setRowValues(Row row, Object ... values) {
        int x;
        this.ensureColumn(values.length);
        if (this.getColumnCount() == 0) {
            this.setColumnCount(values.length);
        }
        int limit = Math.min(values.length, this.columns.length);
        for (x = 0; x < limit; ++x) {
            row.cells[x] = values[x] instanceof Cell ? (Cell)values[x] : new Cell(values[x]);
        }
        if (values.length < this.columns.length) {
            for (x = values.length + 1; x < this.columns.length; ++x) {
                row.cells[x] = null;
            }
        }
    }

    @Override
    public void removeRow(int row) {
        this.dataRows.delete(row);
        this.fireEvents(new DataTableModelEvent(this, row, row, -1, -1, -1));
    }

    public Row insert(int insertIndex) {
        Row row = new Row(this.getColumnCount());
        this.dataRows.insert(row, insertIndex);
        this.fireEvents(new DataTableModelEvent(this));
        return row;
    }

    @Override
    public boolean swap(int row1, int row2) {
        boolean retVal = this.dataRows.swap(row1, row2);
        this.fireEvents(new DataTableModelEvent(this, row1, row2, -1, -1, 0));
        return retVal;
    }

    @Override
    public void insertColumn(Object value, int index) {
        if (index <= this.columns.length) {
            this.columns.insert(value, index);
            this.fireEvents(new DataTableModelEvent(this, -1, -1, index, index, 1));
        }
    }

    @Override
    public Object getColumn(int index) {
        return this.columns.get(index);
    }

    @Override
    public void setColumn(int index, Object value) {
        if (index >= 0 && index < this.columns.length) {
            this.columns.items[index] = value;
            this.fireEvents(new DataTableModelEvent(this));
        }
    }

    @Override
    public void setColumns(Object ... values) {
        this.columns.clear();
        if (values != null && values.length > 0) {
            for (Object value : values) {
                this.columns.append(value);
            }
        }
        this.fireEvents(new DataTableModelEvent(this));
    }

    @Override
    public void setColumnCount(int count) {
        this.columns.clear();
        for (int x = 0; x < count; ++x) {
            this.columns.append("");
        }
        this.fireEvents(new DataTableModelEvent(this));
    }

    @Override
    public void resizeColumn(int count) {
        int x;
        if (count == this.columns.length) {
            return;
        }
        if (count < 1) {
            this.columns.clear();
        } else if (count < this.columns.length) {
            for (x = this.columns.length - 1; x > count; --x) {
                this.columns.delete(x);
            }
        } else {
            for (x = this.columns.length; x <= count; ++x) {
                this.columns.append("");
            }
        }
        this.columns.clear();
        for (x = 0; x < count; ++x) {
            this.columns.append("");
        }
        this.fireEvents(new DataTableModelEvent(this));
    }
}

