/*
 * Decompiled with CFR 0.152.
 */
package DocumentFilters;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class DocumentAllowedKeyFilter
extends DocumentFilter {
    public static final String FILTER_GB_NAME = "\\w\\-'";
    public static final String FILTER_AA = "*ACDEFGHIKLMNPQRSTVWYacdefghiklmnpqrstvwy";
    public static final String FILTER_NUMBER = "0123456789";
    public static final String FILTER_NUMBER_NEG = "-0123456789";
    public static final String FILTER_NUMBER_NEG_DEC = "-0123456789.";
    public static final String FILTER_LOWERCASE = "a-z";
    public static final String FILTER_UPPERCASE = "A-Z";
    public static final String FILTER_ALPHA = "a-zA-Z";
    public static final String FILTER_NUMERIC = "0-9";
    public static final String FILTER_FLOAT = "0123456789\\.";
    public static final String FILTER_ALPHANUMERIC = "a-zA-Z0-9";
    public static final DocumentAllowedKeyFilter NumberFilter = new DocumentAllowedKeyFilter("0123456789");
    public static final DocumentAllowedKeyFilter FloatFilter = new DocumentAllowedKeyFilter("0123456789\\.");
    public static final DocumentAllowedKeyFilter GenbankNameFilter = new DocumentAllowedKeyFilter("\\w\\-'");
    String regExFilter = null;

    public DocumentAllowedKeyFilter() {
    }

    public DocumentAllowedKeyFilter(String allowed) {
        this.regExFilter = "[^" + allowed + "]";
    }

    public void setRegExFilter(String regExFilter) {
        this.regExFilter = regExFilter;
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass fb, int offset, String text, AttributeSet attr) throws BadLocationException {
        if (this.regExFilter == null) {
            super.insertString(fb, offset, text, attr);
        } else {
            super.insertString(fb, offset, text.replaceAll(this.regExFilter, ""), attr);
        }
    }

    @Override
    public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        if (this.regExFilter == null) {
            super.replace(fb, offset, length, text, attrs);
        } else {
            super.replace(fb, offset, length, text.replaceAll(this.regExFilter, ""), attrs);
        }
    }
}

