/*
 * Decompiled with CFR 0.152.
 */
package DockingPanel;

import BaseClasses.RendererColors;
import DockingPanel.DockPanel;
import Renderers.BasicGradientRenderer;
import Renderers.Renderer;
import UIRenderers.RenderedTitlePane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class GradientBar
extends JPanel {
    private static Renderer defaultRenderer = null;
    private final JLabel iconRenderer = new JLabel();
    Renderer renderer = null;
    private float GradientDistance = 1.0f;

    void setRenderer(Renderer renderer) {
        this.renderer = renderer;
    }

    private Renderer getActiveRenderer() {
        if (this.renderer != null) {
            return this.renderer;
        }
        if (defaultRenderer != null) {
            return defaultRenderer;
        }
        return RenderedTitlePane.getDefaultRenderer();
    }

    public GradientBar() {
        this.init();
    }

    public GradientBar(String title) {
        this.setText(title);
        this.init();
    }

    public GradientBar(String title, Icon icon) {
        this.setText(title);
        this.setIcon(icon);
        this.init();
    }

    public void setInsets(int top, int left, int bottom, int right) {
        this.iconRenderer.setBorder(new EmptyBorder(top, left, bottom, right));
    }

    private void init() {
        this.iconRenderer.setOpaque(false);
        this.iconRenderer.setFont(this.getFont());
        this.setInsets(0, 4, 0, 0);
        Object renderer = UIManager.get("RenderedUI.TitlePaneRenderer");
        if (renderer != null && renderer instanceof Renderer) {
            this.setRenderer((Renderer)renderer);
        } else {
            BasicGradientRenderer defRenderer = new BasicGradientRenderer();
            Color mStartColor = UIManager.getColor("DockingFrame.activeTitleBackgroundStart");
            Color mEndColor = UIManager.getColor("DockingFrame.activeTitleBackgroundEnd");
            RendererColors colors = defRenderer.getColors();
            colors.setColors(1, mStartColor != null ? mStartColor : new Color(204, 204, 255));
            colors.setColors(4, mEndColor != null ? mEndColor : new Color(204, 255, 255));
            defRenderer.setStyle(5);
            this.setRenderer(defRenderer);
        }
    }

    @Override
    public void setFont(Font font) {
        if (this.iconRenderer != null) {
            this.iconRenderer.setFont(font);
        }
        super.setFont(font);
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.iconRenderer != null) {
            this.iconRenderer.setForeground(color);
        }
    }

    public float getGradientDistance() {
        return this.GradientDistance;
    }

    public void setGradientDistance(float distance) {
        this.GradientDistance = distance;
        this.repaint();
    }

    public void setText(String text) {
        this.iconRenderer.setText(text);
        this.repaint();
    }

    public String getText() {
        return this.iconRenderer.getText();
    }

    public void setIcon(Icon icon) {
        this.iconRenderer.setIcon(icon);
        this.repaint();
    }

    public Icon getIcon() {
        return this.iconRenderer.getIcon();
    }

    @Override
    protected void paintComponent(Graphics g) {
        Renderer activeRenderer = this.getActiveRenderer();
        boolean isActive = DockPanel.isActive(this);
        if (activeRenderer != null) {
            if (isActive) {
                activeRenderer.paint(g, (Component)this, 0);
            } else {
                activeRenderer.paint(g, (Component)this, 2);
            }
        }
        this.iconRenderer.setForeground(activeRenderer.getColors().getColor(0, isActive ? 0 : 2));
        this.iconRenderer.setSize(this.getWidth(), this.getHeight());
        this.iconRenderer.paint(g);
    }
}

