/*
 * Decompiled with CFR 0.152.
 */
package DockingPanel;

import DockingPanel.ComponentMover;
import DockingPanel.ComponentResizer;
import DockingPanel.DockRunOnClose;
import DockingPanel.DockedComponentInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class DockingWindow
extends JFrame {
    static final ArrayList<UndockedItems> undockedItems = new ArrayList();
    static boolean defaultDecorated = false;
    static boolean defaultResizable = true;
    static boolean defaultOnTop = true;
    static int INSET = 2;
    ComponentMover cm;
    ComponentResizer cr;
    boolean resizable = defaultResizable;
    public DockRunOnClose runOnClose;
    public DockedComponentInfo info = new DockedComponentInfo();

    public static void setDefaultInset(int inset) {
        INSET = inset < 1 ? 1 : inset;
    }

    public static int getDefaultInset() {
        return INSET;
    }

    public static void setDefaultAlwaysOnTop(boolean alwaysOnTop) {
        defaultOnTop = alwaysOnTop;
    }

    public static boolean getDefaultAlwaysOnTop() {
        return defaultDecorated;
    }

    public static void setDefaultDecorated(boolean decorated) {
        defaultDecorated = decorated;
    }

    public static boolean getDefaultDecorated() {
        return defaultDecorated;
    }

    public static void setDefaultResizable(boolean resizable) {
        defaultResizable = resizable;
    }

    public static boolean getDefaultResizable() {
        return defaultResizable;
    }

    public static boolean unDock(Component c) {
        if (DockingWindow.isUndocked(c)) {
            return false;
        }
        DockingWindow undockWindow = new DockingWindow(c);
        DockingWindow.addUndockedWindow(undockWindow);
        undockWindow.setVisible(true);
        return true;
    }

    public static boolean unDock(Component c, DockRunOnClose runOnClose) {
        DockingWindow undockWindow;
        if (DockingWindow.unDock(c) && (undockWindow = DockingWindow.getUndockedWindow(c)) != null) {
            undockWindow.runOnClose = runOnClose;
            return true;
        }
        return false;
    }

    public static DockingWindow getUndockedWindow(Component c) {
        for (UndockedItems item : undockedItems) {
            if (item.c != c) continue;
            return item.w;
        }
        return null;
    }

    private static void removeUndockedWindow(Component c) {
        UndockedItems founditem = null;
        for (UndockedItems item : undockedItems) {
            if (item.c != c) continue;
            founditem = item;
            break;
        }
        if (founditem != null) {
            undockedItems.remove(founditem);
        }
    }

    private static boolean addUndockedWindow(DockingWindow w) {
        if (w == null || w.info.dockedComponent == null) {
            return false;
        }
        UndockedItems item = new UndockedItems(w.info.dockedComponent, w);
        undockedItems.add(item);
        return true;
    }

    public static boolean isDocked(Component c) {
        for (UndockedItems item : undockedItems) {
            if (item.c != c) continue;
            return false;
        }
        return true;
    }

    public static boolean isUndocked(Component c) {
        return !DockingWindow.isDocked(c);
    }

    public static boolean unDock(Component c, String title, DockRunOnClose runOnClose) {
        if (DockingWindow.unDock(c)) {
            DockingWindow undockWindow = DockingWindow.getUndockedWindow(c);
            if (title != null) {
                undockWindow.setTitle(title);
            }
            undockWindow.runOnClose = runOnClose;
            return true;
        }
        return false;
    }

    public static boolean unDock(Component c, String title) {
        if (DockingWindow.unDock(c)) {
            DockingWindow undockWindow = DockingWindow.getUndockedWindow(c);
            if (title != null) {
                undockWindow.setTitle(title);
            }
            return true;
        }
        return false;
    }

    public static boolean unDock(Component c, String title, ImageIcon icon) {
        if (DockingWindow.unDock(c)) {
            DockingWindow undockWindow = DockingWindow.getUndockedWindow(c);
            if (title != null) {
                undockWindow.setTitle(title);
            }
            if (icon != null) {
                undockWindow.setIconImage(icon.getImage());
            }
            return true;
        }
        return false;
    }

    public static boolean unDock(Component c, String title, DockRunOnClose runOnClose, ImageIcon icon) {
        if (DockingWindow.unDock(c)) {
            DockingWindow undockWindow = DockingWindow.getUndockedWindow(c);
            if (title != null) {
                undockWindow.setTitle(title);
            }
            if (icon != null) {
                undockWindow.setIconImage(icon.getImage());
            }
            if (runOnClose != null) {
                undockWindow.runOnClose = runOnClose;
            }
            return true;
        }
        return false;
    }

    public static boolean dock(Component c) {
        DockingWindow undockWindow = DockingWindow.getUndockedWindow(c);
        if (undockWindow == null) {
            return false;
        }
        undockWindow.setVisible(false);
        undockWindow.removeListeners();
        undockWindow.info.parent.add(c);
        c.setBounds(undockWindow.info.originalBounds);
        undockWindow.dispose();
        undockWindow.info.parent.repaint();
        DockingWindow.removeUndockedWindow(c);
        return true;
    }

    private void setDockedComponent(Component c) {
        this.info.dockedComponent = c;
        this.info.parent = c.getParent();
        c.getBounds(this.info.originalBounds);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(INSET, INSET, INSET).addComponent(c, -1, -1, Short.MAX_VALUE).addGap(INSET, INSET, INSET)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(INSET, INSET, INSET).addComponent(c, -1, -1, Short.MAX_VALUE).addGap(INSET, INSET, INSET)));
        this.pack();
        this.setSize(this.info.originalBounds.width + INSET * 2, this.info.originalBounds.height + INSET * 2);
    }

    public void setMoveComponent(Component c) {
        if (this.cm != null) {
            this.cm.deregisterComponents();
            this.cm = null;
        }
        if (c != null) {
            this.cm = new ComponentMover(JFrame.class, c);
            this.cm.setSnapSize(new Dimension(1, 1));
            this.cm.setChangeCursor(false);
        }
    }

    @Override
    public boolean isResizable() {
        return this.resizable;
    }

    @Override
    public void setResizable(boolean resizable) {
        this.resizable = resizable;
        if (!this.isUndecorated()) {
            super.setResizable(resizable);
        } else {
            if (this.cr != null) {
                this.cr.deregisterComponent(this);
                this.cr = null;
            }
            if (resizable) {
                this.cr = new ComponentResizer(new Insets(INSET, INSET, INSET, INSET), new Dimension(1, 1), this);
            }
        }
    }

    public DockingWindow(Component dockedComponent, boolean decorated) {
        if (!this.isVisible() && !decorated) {
            this.setUndecorated(true);
        }
        this.setDockedComponent(dockedComponent);
        this.setResizable(defaultResizable);
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                if (DockingWindow.this.runOnClose == null) {
                    DockingWindow.dock(DockingWindow.this.info.dockedComponent);
                } else {
                    DockingWindow.this.runOnClose.runOnClose();
                }
                DockingWindow.this.info.parent.repaint();
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }
        });
        this.setAlwaysOnTop(defaultOnTop);
        this.info.parent.repaint();
    }

    public DockingWindow(Component dockedComponent) {
        this(dockedComponent, defaultDecorated);
    }

    void removeListeners() {
        if (this.cm != null) {
            this.cm.deregisterComponents();
            this.cm = null;
        }
        if (this.cr != null) {
            this.cr.deregisterComponents();
            this.cr = null;
        }
    }

    private static class UndockedItems {
        Component c;
        DockingWindow w;

        public UndockedItems() {
        }

        public UndockedItems(Component c, DockingWindow w) {
            this.c = c;
            this.w = w;
        }
    }
}

