/*
 * Decompiled with CFR 0.152.
 */
package DNATools;

import Sequences.DNA;
import java.beans.BeanProperty;

public class TmCalculator {
    public static final int GENERIC = 0;
    public static final int NEAREST_NEIGHBOR = 1;
    public static final int TAQ = 2;
    public static final int Q5_POLYMERASE = 3;
    public static final int Q5U_POLYMERASE = 4;
    public static final int VENT = 5;
    public static final int PHUSION = 6;
    private static int mType = 1;
    private static final String[] methodNames = new String[]{"Generic", "Nearest Neighbor", "Taq polymerase", "Q5 polymerase", "Q5U polymerase", "Vent polymerase", "Phusion polymerase"};
    private static double dH = 0.0;
    private static double dS = 0.0;
    private static double s = 0.0;
    private static double o = 0.0;
    private static double at_count = 0.0;
    private static double gc_count = 0.0;
    private static double total_count = 0.0;

    @BeanProperty(preferred=true, enumerationValues={"GENERIC", "NEAREST_NEIGHBOR", "TAQ", "Q5_POLYMERASE", "Q5U_POLYMERASE", "VENT", "PHUSION"}, description="Set the default method of Tm calculation.")
    public static void setType(int type) {
        if (TmCalculator.isTypeValid(type)) {
            mType = type;
        }
    }

    public static int getType() {
        return mType;
    }

    public static boolean isTypeValid(int type) {
        return type >= 0 && type <= 6;
    }

    public static String getTmTypeName() {
        return TmCalculator.getTmTypeName(mType);
    }

    public static String getTmTypeName(int type) {
        if (TmCalculator.isTypeValid(type)) {
            return methodNames[type];
        }
        return "Invalid method";
    }

    public static int getTm(String seqDNA) {
        return TmCalculator.getTm(seqDNA, mType);
    }

    public static int getTm(String seqDNA, int type) {
        switch (type) {
            case 1: {
                return TmCalculator.getTmNN(seqDNA);
            }
            case 3: {
                return TmCalculator.getTmSaltcU(seqDNA, 0.15, 5.0E-7);
            }
            case 4: {
                return TmCalculator.getTmSaltcU(seqDNA, 0.17, 5.0E-7);
            }
            case 5: {
                return TmCalculator.getTmSaltcU(seqDNA, 0.05, 2.0E-7);
            }
            case 2: {
                return TmCalculator.getTmSaltcU(seqDNA, 0.06, 2.0E-7);
            }
            case 6: {
                return TmCalculator.getTmPhusion(seqDNA);
            }
        }
        return TmCalculator.getTmGeneric(seqDNA);
    }

    public static int getTm(String seqDNA, double nM_oligos, int type) {
        switch (type) {
            case 1: {
                return TmCalculator.getTmNN(seqDNA);
            }
            case 3: {
                return TmCalculator.getTmSaltcU(seqDNA, 0.15, nM_oligos / 1.0E9);
            }
            case 4: {
                return TmCalculator.getTmSaltcU(seqDNA, 0.17, nM_oligos / 1.0E9);
            }
            case 5: {
                return TmCalculator.getTmSaltcU(seqDNA, 0.05, nM_oligos / 1.0E9);
            }
            case 2: {
                return TmCalculator.getTmSaltcU(seqDNA, 0.06, nM_oligos / 1.0E9);
            }
            case 6: {
                return TmCalculator.getTmPhusion(seqDNA, nM_oligos);
            }
        }
        return TmCalculator.getTmGeneric(seqDNA);
    }

    public static int getTmGeneric(String seqDNA) {
        TmCalculator.getAT_GC_Counts(seqDNA);
        if (seqDNA.length() < 14) {
            return (int)(at_count * 2.0 + gc_count * 4.0);
        }
        return (int)Math.round(64.9 + 41.0 * (gc_count - 16.4) / (at_count + gc_count));
    }

    public static int getTmNN(String seqDNA) {
        return TmCalculator.getTmNN(seqDNA.toUpperCase(), 0.5f, 0.05f, true);
    }

    private static dHdS get_dH_dS_DNA(String seq) {
        dHdS outVal = new dHdS();
        outVal.dH = 0.0;
        outVal.dS = 0.0;
        if (seq.length() > 2) {
            block27: for (int x = 0; x < seq.length() - 1; ++x) {
                String lTwoBp;
                switch (lTwoBp = seq.substring(x, x + 2)) {
                    case "AA": 
                    case "TT": {
                        outVal.dH += -9.1;
                        outVal.dS += -0.024;
                        continue block27;
                    }
                    case "AT": {
                        outVal.dH += -8.6;
                        outVal.dS += -0.0239;
                        continue block27;
                    }
                    case "TA": {
                        outVal.dH += -6.0;
                        outVal.dS += -0.0169;
                        continue block27;
                    }
                    case "CA": {
                        outVal.dH += -5.8;
                        outVal.dS += -0.0129;
                        continue block27;
                    }
                    case "GT": 
                    case "AC": {
                        outVal.dH += -6.5;
                        outVal.dS += -0.0173;
                        continue block27;
                    }
                    case "CT": {
                        outVal.dH += -7.8;
                        outVal.dS += -0.0208;
                        continue block27;
                    }
                    case "GA": {
                        outVal.dH += -5.6;
                        outVal.dS += -0.0135;
                        continue block27;
                    }
                    case "CG": {
                        outVal.dH += -11.9;
                        outVal.dS += -0.0278;
                        continue block27;
                    }
                    case "GC": {
                        outVal.dH += -11.1;
                        outVal.dS += -0.0267;
                        continue block27;
                    }
                    case "GG": 
                    case "CC": {
                        outVal.dH += -11.0;
                        outVal.dS += -0.0266;
                        continue block27;
                    }
                }
            }
        }
        return outVal;
    }

    private static dHdS get_dH_dS_RNA(String seq) {
        dHdS outVal = new dHdS();
        outVal.dH = 0.0;
        outVal.dS = 0.0;
        if (seq.length() > 2) {
            block32: for (int x = 0; x < seq.length() - 1; ++x) {
                String lTwoBp;
                switch (lTwoBp = seq.substring(x, x + 2)) {
                    case "AA": 
                    case "TT": 
                    case "UU": {
                        outVal.dH += -6.6;
                        outVal.dS += -0.0184;
                        continue block32;
                    }
                    case "AT": 
                    case "AU": {
                        outVal.dH += -5.7;
                        outVal.dS += -0.0155;
                        continue block32;
                    }
                    case "TA": 
                    case "UA": {
                        outVal.dH += -8.1;
                        outVal.dS += -0.0226;
                        continue block32;
                    }
                    case "CA": {
                        outVal.dH += -10.5;
                        outVal.dS += -0.0278;
                        continue block32;
                    }
                    case "GT": 
                    case "AC": 
                    case "GU": {
                        outVal.dH += -10.2;
                        outVal.dS += -0.0262;
                        continue block32;
                    }
                    case "CT": 
                    case "CU": {
                        outVal.dH += -7.6;
                        outVal.dS += -0.0192;
                        continue block32;
                    }
                    case "GA": {
                        outVal.dH += -13.3;
                        outVal.dS += -0.0355;
                        continue block32;
                    }
                    case "CG": {
                        outVal.dH += -8.0;
                        outVal.dS += -0.0194;
                        continue block32;
                    }
                    case "GC": {
                        outVal.dH += -14.2;
                        outVal.dS += -0.0349;
                        continue block32;
                    }
                    case "GG": 
                    case "CC": {
                        outVal.dH += -12.2;
                        outVal.dS += -0.0297;
                        continue block32;
                    }
                }
            }
        }
        return outVal;
    }

    public static int getTmNN(String Seq, float uM_Oligo, float mol_NaCl, boolean isDNA) {
        String uSeq = DNA.filterSequence(Seq).toUpperCase();
        if (uSeq.length() < 2) {
            return 0;
        }
        float R = 0.001987f;
        float A = -0.0108f;
        float C = uM_Oligo / 1000000.0f;
        dHdS dSdH = isDNA ? TmCalculator.get_dH_dS_DNA(uSeq) : TmCalculator.get_dH_dS_RNA(uSeq);
        return (int)(dSdH.dH / ((double)A + dSdH.dS + (double)R * Math.log(C / 4.0f)) - (double)273.15f + (double)16.6f * Math.log10(mol_NaCl));
    }

    public static int getTmQ5(String seqDNA) {
        return TmCalculator.getTmSaltcU(seqDNA, 0.15, 5.0E-7);
    }

    public static int getTmQ5(String seqDNA, double nM_Oligo) {
        return TmCalculator.getTmSaltcU(seqDNA, 0.15, nM_Oligo / 1.0E9);
    }

    public static int getTmPhusion(String seqDNA) {
        return TmCalculator.getTmPhusion(seqDNA, 500.0);
    }

    public static int getTmPhusion(String seqDNA, double nM_Oligo) {
        String wseq = DNA.filterSequence(seqDNA).toUpperCase();
        if (wseq.length() < 2) {
            return 0;
        }
        double saltc = 0.222;
        double u = nM_Oligo / 4.0E9;
        boolean sym = wseq.equals(DNA.getAntisense(wseq));
        double sc_sch = 16.6 * Math.log(saltc) / Math.log(10.0);
        float l = 0.0f;
        if (sym) {
            l = -1.4f;
        }
        TmCalculator.calc_dS_dH(wseq);
        double r = ((dH *= 1000.0) + s) / (o + (double)l + dS + 1.987 * Math.log(u));
        r += sc_sch;
        return (int)(r -= 273.15);
    }

    private static void getAT_GC_Counts(String Sequence2) {
        gc_count = 0.0;
        at_count = 0.0;
        total_count = 0.0;
        block4: for (int x = 0; x < Sequence2.length(); ++x) {
            switch (Sequence2.charAt(x)) {
                case 'C': 
                case 'G': 
                case 'c': 
                case 'g': {
                    gc_count += 1.0;
                    total_count += 1.0;
                    continue block4;
                }
                case 'A': 
                case 'T': 
                case 'a': 
                case 't': {
                    at_count += 1.0;
                    total_count += 1.0;
                }
            }
        }
    }

    private static void calc_dS_dH(String seqDNA) {
        dH = 0.0;
        dS = 0.0;
        s = 0.0;
        o = 0.0;
        char char1 = seqDNA.charAt(0);
        char char2 = seqDNA.charAt(seqDNA.length() - 1);
        if (char1 == 'A' || char1 == 'T') {
            o += 4.1;
            s += 2300.0;
        } else if (char1 == 'G' || char1 == 'C') {
            o -= 2.8;
            s += 100.0;
        }
        if (char2 == 'A' || char2 == 'T') {
            o += 4.1;
            s += 2300.0;
        }
        if (char2 == 'G' || char2 == 'C') {
            o -= 2.8;
            s += 100.0;
        }
        block33: for (int x = 0; x < seqDNA.length() - 1; ++x) {
            String lTwoBp;
            switch (lTwoBp = seqDNA.substring(x, x + 2)) {
                case "TG": {
                    dH += -8.5;
                    dS += -22.7;
                    continue block33;
                }
                case "TC": {
                    dH += -8.2;
                    dS += -22.2;
                    continue block33;
                }
                case "AG": {
                    dH += -7.8;
                    dS += -21.0;
                    continue block33;
                }
                case "AA": 
                case "TT": {
                    dH += -7.9;
                    dS += -22.2;
                    continue block33;
                }
                case "AT": {
                    dH += -7.2;
                    dS += -20.4;
                    continue block33;
                }
                case "TA": {
                    dH += -7.2;
                    dS += -21.3;
                    continue block33;
                }
                case "CA": {
                    dH += -8.5;
                    dS += -22.7;
                    continue block33;
                }
                case "GT": 
                case "AC": {
                    dH += -8.4;
                    dS += -22.4;
                    continue block33;
                }
                case "CT": {
                    dH += -7.8;
                    dS += -21.0;
                    continue block33;
                }
                case "GA": {
                    dH += -8.2;
                    dS += -22.2;
                    continue block33;
                }
                case "CG": {
                    dH += -10.6;
                    dS += -27.2;
                    continue block33;
                }
                case "GC": {
                    dH += -9.8;
                    dS += -24.4;
                    continue block33;
                }
                case "GG": 
                case "CC": {
                    dH += -8.0;
                    dS += -19.9;
                    continue block33;
                }
            }
        }
    }

    private static int getTmSaltcU(String seqDNA, double saltc, double u) {
        if ((seqDNA = DNA.filterSequence(seqDNA).toUpperCase()).length() < 2) {
            return 0;
        }
        boolean sym = seqDNA.equals(DNA.getAntisense(seqDNA));
        float l = 0.0f;
        TmCalculator.getAT_GC_Counts(seqDNA);
        double fgc = gc_count / total_count;
        if (sym) {
            l = -1.4f;
        }
        TmCalculator.calc_dS_dH(seqDNA);
        return (int)Math.round(1.0 / (1.0 / ((dH * 1000.0 + s) / (o + (double)l + dS + 1.987 * Math.log(u))) + (1.0E-5 * (4.29 * fgc - 3.95) * Math.log(saltc) + 9.4E-6 * Math.log(saltc) * Math.log(saltc))) - 273.15);
    }

    static class dHdS {
        double dH = 0.0;
        double dS = 0.0;

        dHdS() {
        }
    }
}

