/*
 * Decompiled with CFR 0.152.
 */
package DNATools;

import DNATools.MutationAnnotation;
import Sequences.DNA;
import java.util.ArrayList;

public class SequenceMutator {
    private String o_Seq = null;
    String m_Seq = null;
    String m_Error = "";
    ArrayList<MutationAnnotation> m_Mutations = new ArrayList();

    public String getError() {
        return this.m_Error;
    }

    public String getOriginalSequence() {
        return this.o_Seq;
    }

    public String getMutatedSequence() {
        if (this.m_Seq == null && this.o_Seq != null) {
            this.mutateSequence();
        }
        return this.m_Seq;
    }

    public void setSequence(String Seq) {
        this.m_Seq = DNA.filterSequence(Seq.toUpperCase());
    }

    public int getFirstMutationCoordinate() {
        if (this.m_Mutations.size() == 0) {
            return 0;
        }
        return this.m_Mutations.get(0).get_DNAStart();
    }

    public int getLastMutationCoordinate() {
        if (this.m_Mutations.size() == 0) {
            return 0;
        }
        return this.m_Mutations.get(this.m_Mutations.size() - 1).get_DNAStop();
    }

    public boolean addMutation(MutationAnnotation mutation) {
        this.m_Seq = null;
        return true;
    }

    public boolean addMutations(MutationAnnotation[] mutations) {
        this.m_Seq = null;
        return true;
    }

    public void removeMutation(MutationAnnotation mutation) {
        if (this.m_Mutations.contains(mutation)) {
            this.m_Mutations.remove(mutation);
        }
        this.m_Seq = null;
    }

    private boolean canMutate() {
        if (this.o_Seq == null || this.o_Seq.length() == 0) {
            return false;
        }
        return !this.m_Mutations.isEmpty();
    }

    private void mutateSequence() {
        this.m_Seq = this.mutateSequence(this.o_Seq, this.m_Mutations);
    }

    private String mutateSequence(String originalSequence, ArrayList<MutationAnnotation> annotations) {
        if (!this.canMutate()) {
            return null;
        }
        boolean haveInDels = false;
        if (annotations.isEmpty()) {
            return originalSequence;
        }
        if (haveInDels) {
            // empty if block
        }
        return "";
    }

    private String mutateSequence(String originalSequence, MutationAnnotation annotation) {
        return "";
    }
}

