/*
 * Decompiled with CFR 0.152.
 */
package DNATools;

import DNATools.Intron;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MutationAnnotation {
    static final String ANNOTATION_STYLE_1 = "(\\s*)(?:(?<type>[cp]).){0,1}(?:\\s*)(?<oldRes>[A-Za-z]{1,3})(?:\\s*)(?<position>\\d+)(?:\\s*)(?<newRes>[A-Za-z]{1,3})";
    static final String ANNOTATION_STYLE_2 = "(?:(?<type>[cp]).){0,1}(?<position>\\d+)(?:\\s*)(?<oldRes>[A-Za-z]{1,3})(?:\\s*)>(?:\\s*)(?:\\s*)(?<newRes>[A-Za-z]{1,3})";
    static final String ANNOTATION_STYLE_3 = "(?<type>[cp]).(?:\\s*)(?<start>\\d+)(?:\\s*)(?:_(?<stop>\\d+)){0,1}(?:\\s*)(?<deldup>del|dup)(?:\\s*)(?<deletedRes>[A-Za-z]+)*";
    private static Pattern ANNOTATION_PATTERN_1 = Pattern.compile("(\\s*)(?:(?<type>[cp]).){0,1}(?:\\s*)(?<oldRes>[A-Za-z]{1,3})(?:\\s*)(?<position>\\d+)(?:\\s*)(?<newRes>[A-Za-z]{1,3})", 2);
    private static Pattern ANNOTATION_PATTERN_2 = Pattern.compile("(?:(?<type>[cp]).){0,1}(?<position>\\d+)(?:\\s*)(?<oldRes>[A-Za-z]{1,3})(?:\\s*)>(?:\\s*)(?:\\s*)(?<newRes>[A-Za-z]{1,3})", 2);
    private static Pattern ANNOTATION_PATTERN_3 = Pattern.compile("(?<type>[cp]).(?:\\s*)(?<start>\\d+)(?:\\s*)(?:_(?<stop>\\d+)){0,1}(?:\\s*)(?<deldup>del|dup)(?:\\s*)(?<deletedRes>[A-Za-z]+)*", 2);
    private static Matcher matcher;
    public static final int TYPE_DNA = 0;
    public static final int TYPE_AA = 1;
    public static final int UNKNOWN = 99;
    public static final int CHANGE_SUBSTITUTION = 0;
    public static final int CHANGE_INSERTION = 1;
    public static final int CHANGE_DELETION = 2;
    public static final int CHANGE_DUPLICATION = 3;
    public String sequenceName = "";
    protected boolean valid = false;
    protected int mutationType = 99;
    protected int annotationType = 99;
    protected int dnaStart = 0;
    protected int dnaStop = 0;
    protected int aaStart = 0;
    protected int aaStop = 0;
    protected int numStart = 0;
    protected int numStop = 0;
    protected String originalResidue = "";
    protected String newResidue = "";
    protected String name = null;
    protected String m_Error = "No mutation set";

    public String toString() {
        return this.getAnnotation();
    }

    public boolean isValid() {
        return this.valid;
    }

    public int getMutationType() {
        return this.mutationType;
    }

    public int getAnnotationType() {
        return this.annotationType;
    }

    public String getError() {
        return this.m_Error;
    }

    public int get_DNAStart() {
        return this.dnaStart;
    }

    public int get_DNAStop() {
        return this.dnaStop;
    }

    public int get_AAStart() {
        return this.aaStart;
    }

    public int get_AAStop() {
        return this.aaStop;
    }

    public int getNumStart() {
        return this.numStart;
    }

    public int getNumStop() {
        return this.numStop;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return this.getAnnotation();
    }

    public MutationAnnotation() {
    }

    public String getAnnotation() {
        if (this.annotationType == 1) {
            return this.getAnnotationAA();
        }
        return this.getAnnotationDNA();
    }

    public String getAnnotationDNA() {
        String outString = "c." + this.originalResidue + this.dnaStart;
        if (this.dnaStop > 0) {
            outString = outString + "_" + this.dnaStop;
        }
        switch (this.mutationType) {
            case 2: {
                if (this.originalResidue.length() > 0) {
                    return outString + "Del(" + this.originalResidue + ")";
                }
                return outString + "Del";
            }
            case 3: {
                return outString + "Dup(" + this.originalResidue + ")";
            }
            case 1: {
                return outString + this.originalResidue + this.newResidue;
            }
        }
        return outString + this.newResidue;
    }

    public String getAnnotationAA() {
        String outString = "p." + MutationAnnotation.ProperCap(this.originalResidue) + this.aaStart;
        if (this.aaStop > 0) {
            outString = outString + "_" + this.aaStop;
        }
        switch (this.mutationType) {
            case 2: {
                if (this.originalResidue.length() > 0) {
                    return outString + "Del(" + this.originalResidue + ")";
                }
                return outString + "Del";
            }
            case 3: {
                return outString + "Dup(" + this.originalResidue + ")";
            }
            case 1: {
                return outString + this.originalResidue + this.newResidue;
            }
        }
        return outString + MutationAnnotation.ProperCap(this.newResidue);
    }

    public void adjustForIntron(Intron intron) {
        if (this.annotationType == 0) {
            if (this.dnaStart >= intron.start) {
                this.dnaStart += intron.length;
            }
            if (this.dnaStop >= intron.start) {
                this.dnaStop += intron.length;
            }
        } else if (this.annotationType == 1) {
            // empty if block
        }
    }

    public void shiftDNACoordinates(int shiftValue) {
        if (this.annotationType == 0) {
            this.dnaStart += shiftValue;
            this.dnaStop += shiftValue;
        }
    }

    public void shiftAACoordinates(int shiftValue) {
        if (this.annotationType == 1) {
            this.aaStart += shiftValue;
            this.aaStop += shiftValue;
        }
    }

    public String getOriginalResidue() {
        return this.originalResidue;
    }

    public void setOriginalResidue(String OriginalBase) {
        this.originalResidue = OriginalBase;
    }

    public String getNewResidue() {
        return this.newResidue;
    }

    public boolean overlap(MutationAnnotation annotation1, MutationAnnotation annotation2) {
        return annotation1.dnaStart > annotation2.dnaStop || annotation1.dnaStop < annotation2.dnaStart;
    }

    public void setNewResidue(String NewResidue) {
        this.newResidue = NewResidue;
    }

    private static int BpToCodon(int Pos2) {
        return (Pos2 - (Pos2 - 1) % 3 - 1) / 3 + 1;
    }

    private boolean pSetMutation(int Pos2, String originalResidue, String newResidue, int annotationType, int changeType) {
        switch (annotationType) {
            case 0: {
                this.dnaStart = Pos2;
                this.aaStart = MutationAnnotation.BpToCodon(Pos2);
                break;
            }
            case 1: {
                this.aaStart = Pos2;
                this.dnaStart = MutationAnnotation.CodonToBp(Pos2);
                break;
            }
            default: {
                return false;
            }
        }
        this.originalResidue = originalResidue.toUpperCase();
        this.newResidue = newResidue.toUpperCase();
        this.annotationType = annotationType;
        this.mutationType = changeType;
        return this.setValid();
    }

    private boolean setValid() {
        if (this.originalResidue.equals(this.newResidue)) {
            this.m_Error = "Original residue and mutant residue are the same";
            this.valid = false;
        } else if (this.dnaStart < 1 || this.aaStart < 1) {
            this.m_Error = "Invalid base specified";
            this.valid = false;
        } else {
            this.m_Error = "";
            this.valid = true;
        }
        return this.valid;
    }

    public MutationAnnotation(int Pos2, String originalResidue, String newResidue) {
        this.pSetMutation(Pos2, originalResidue, newResidue, 0, 0);
    }

    public MutationAnnotation(int Pos2, String originalResidue, String newResidue, int AA_Or_DNA, int changeType) {
        this.pSetMutation(Pos2, originalResidue, newResidue, AA_Or_DNA, changeType);
    }

    public MutationAnnotation(int Pos2, String originalResidue, String newResidue, int AA_Or_DNA) {
        this.pSetMutation(Pos2, originalResidue, newResidue, AA_Or_DNA, 0);
    }

    public MutationAnnotation(String annotation) {
        if (!MutationAnnotation.ExtractMutPosRegex(annotation.trim(), this)) {
            System.err.println("Failed for: " + annotation + ", " + this.m_Error);
        }
    }

    public static MutationAnnotation from(String annotation) {
        MutationAnnotation m = new MutationAnnotation();
        if (!m.setMutation(annotation)) {
            System.err.println("Failed for: " + annotation + ", " + m.m_Error);
            return null;
        }
        return m;
    }

    public boolean setMutation(String Annotation2) {
        this.clearAll();
        if (MutationAnnotation.ExtractMutPos(Annotation2.trim(), this)) {
            return this.setValid();
        }
        this.m_Error = "Failed to parse mutation annotation";
        return false;
    }

    private void clearAll() {
        this.annotationType = 99;
        this.numStart = 0;
        this.numStop = 0;
        this.originalResidue = "";
        this.newResidue = "";
        this.m_Error = "";
        this.dnaStart = 0;
        this.aaStart = 0;
    }

    private static boolean matcherHasGroup(Matcher matcher, String groupname) {
        boolean hasGroup;
        try {
            hasGroup = matcher.group(groupname) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return hasGroup;
    }

    private static String getMatcherGroupValue(Matcher matcher, String groupname, String defaultValue) {
        String groupValue = null;
        try {
            groupValue = matcher.group(groupname);
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
        if (groupValue != null) {
            return groupValue;
        }
        return defaultValue;
    }

    private static int getMatcherGroupValue(Matcher matcher, String groupname, int defaultValue) {
        String groupValue = null;
        try {
            groupValue = matcher.group(groupname);
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
        if (groupValue != null) {
            return Integer.parseInt(groupValue);
        }
        return defaultValue;
    }

    private static boolean ExtractMutPosRegex12(Matcher matcher, MutationAnnotation dst) {
        if (matcher.find()) {
            String type;
            dst.numStart = MutationAnnotation.getMatcherGroupValue(matcher, "position", 0);
            dst.originalResidue = MutationAnnotation.getMatcherGroupValue(matcher, "oldRes", "");
            dst.newResidue = MutationAnnotation.getMatcherGroupValue(matcher, "newRes", "");
            switch (dst.newResidue.toLowerCase()) {
                case "del": 
                case "": {
                    dst.mutationType = 2;
                    break;
                }
                case "dup": {
                    dst.mutationType = 3;
                    break;
                }
                default: {
                    dst.mutationType = 0;
                }
            }
            switch (type = MutationAnnotation.getMatcherGroupValue(matcher, "type", "").toLowerCase()) {
                case "c": {
                    dst.annotationType = 0;
                    return true;
                }
                case "p": {
                    dst.annotationType = 1;
                    return true;
                }
            }
            return MutationAnnotation.deduceType(dst);
        }
        return false;
    }

    private static boolean ExtractMutPosRegex3(Matcher matcher, MutationAnnotation dst) {
        if (matcher.find()) {
            String type;
            String cmp;
            dst.numStart = MutationAnnotation.getMatcherGroupValue(matcher, "start", 0);
            if (dst.numStart == 0) {
                return false;
            }
            dst.numStop = MutationAnnotation.getMatcherGroupValue(matcher, "stop", 0);
            dst.originalResidue = MutationAnnotation.getMatcherGroupValue(matcher, "oldRes", "");
            dst.newResidue = MutationAnnotation.getMatcherGroupValue(matcher, "deletedRes", "");
            if (dst.originalResidue.length() > 0 && dst.newResidue.length() == 0) {
                dst.originalResidue = dst.newResidue;
            } else if (dst.originalResidue.length() == 0 && dst.newResidue.length() > 0) {
                dst.originalResidue = dst.newResidue;
            }
            switch (cmp = MutationAnnotation.getMatcherGroupValue(matcher, "deldup", "").toLowerCase()) {
                case "del": {
                    dst.mutationType = 2;
                    break;
                }
                case "dup": {
                    dst.mutationType = 3;
                }
            }
            switch (type = MutationAnnotation.getMatcherGroupValue(matcher, "type", "").toLowerCase()) {
                case "c": {
                    dst.annotationType = 0;
                    return true;
                }
                case "p": {
                    dst.annotationType = 1;
                    return true;
                }
            }
            return MutationAnnotation.deduceType(dst);
        }
        return false;
    }

    private static boolean deduceType(MutationAnnotation dst) {
        if (dst.originalResidue != null && dst.newResidue != null) {
            if (MutationAnnotation.isDNA(dst.originalResidue) && MutationAnnotation.isDNA(dst.newResidue)) {
                dst.annotationType = 0;
                return true;
            }
            if (MutationAnnotation.isAA(dst.originalResidue) && MutationAnnotation.isAA(dst.newResidue)) {
                dst.annotationType = 1;
                return true;
            }
        } else if (dst.originalResidue != null) {
            if (MutationAnnotation.isDNA(dst.originalResidue)) {
                dst.annotationType = 0;
                return true;
            }
            if (MutationAnnotation.isAA(dst.originalResidue)) {
                dst.annotationType = 1;
                return true;
            }
        } else if (dst.newResidue != null) {
            if (MutationAnnotation.isDNA(dst.newResidue)) {
                dst.annotationType = 0;
                return true;
            }
            if (MutationAnnotation.isAA(dst.newResidue)) {
                dst.annotationType = 1;
                return true;
            }
        }
        dst.annotationType = 99;
        dst.m_Error = "Could not parse mutation annotation";
        return false;
    }

    private static boolean ExtractMutPosRegex(String MutString, MutationAnnotation dst) {
        matcher = ANNOTATION_PATTERN_3.matcher(MutString);
        if (!(MutationAnnotation.ExtractMutPosRegex3(matcher, dst) || MutationAnnotation.ExtractMutPosRegex12(matcher = ANNOTATION_PATTERN_1.matcher(MutString), dst) || MutationAnnotation.ExtractMutPosRegex12(matcher = ANNOTATION_PATTERN_2.matcher(MutString), dst))) {
            dst.m_Error = "Could not parse mutation annotation";
            return false;
        }
        switch (dst.annotationType) {
            case 1: {
                dst.aaStart = dst.numStart;
                dst.dnaStart = MutationAnnotation.CodonToBp(dst.numStart);
                if (dst.numStop <= 0) break;
                dst.aaStop = dst.numStop;
                dst.dnaStop = MutationAnnotation.CodonToBp(dst.numStop);
                break;
            }
            case 0: {
                dst.dnaStart = dst.numStart;
                dst.aaStart = MutationAnnotation.BpToCodon(dst.numStart);
                if (dst.numStop <= 0) break;
                dst.aaStop = MutationAnnotation.BpToCodon(dst.numStop);
                dst.dnaStop = dst.numStop;
                break;
            }
            case 99: {
                break;
            }
            default: {
                dst.m_Error = "Could not parse mutation annotation";
                return false;
            }
        }
        return true;
    }

    private static boolean ExtractMutPos(String MutString, MutationAnnotation dst) {
        int ToIndex;
        MutString = MutString.toUpperCase();
        boolean FoundNum = false;
        boolean FoundEnd = false;
        if (MutString.length() < 2) {
            return false;
        }
        for (int x = 0; x < MutString.length(); ++x) {
            if (MutString.charAt(x) > '/' && MutString.charAt(x) < ':') {
                if (!FoundNum) {
                    FoundNum = true;
                    dst.numStart = x;
                }
            } else if (FoundNum) {
                FoundEnd = true;
                dst.numStop = x;
            }
            if (FoundEnd) break;
        }
        if (!FoundNum) {
            return false;
        }
        if (FoundNum && !FoundEnd) {
            dst.numStop = MutString.length();
        }
        dst.annotationType = 99;
        int Pos2 = Integer.valueOf(MutString.substring(dst.numStart, dst.numStop));
        if (MutString.substring(0, 2).equals("P.")) {
            if (dst.numStart <= 2) {
                dst.m_Error = "Could not parse mutation annotation";
                return false;
            }
            dst.originalResidue = MutString.substring(2, dst.numStart);
            dst.newResidue = MutString.substring(dst.numStop);
            dst.annotationType = 1;
            dst.aaStart = Pos2;
            dst.dnaStart = MutationAnnotation.CodonToBp(Pos2);
        } else if (MutString.substring(0, 2).equalsIgnoreCase("C.")) {
            if (dst.numStart > 2) {
                dst.originalResidue = MutString.substring(2, dst.numStart);
                dst.newResidue = MutString.substring(dst.numStop);
            } else if (dst.numStart == 2) {
                if (!MutString.contains(">")) {
                    return false;
                }
                ToIndex = MutString.indexOf(">");
                if (ToIndex < dst.numStop + 1) {
                    return false;
                }
                dst.originalResidue = MutString.substring(dst.numStop, ToIndex);
                dst.newResidue = MutString.substring(ToIndex + 1);
            }
            dst.annotationType = 0;
            dst.dnaStart = Pos2;
            dst.aaStart = MutationAnnotation.BpToCodon(Pos2);
        } else if (MutString.contains(">")) {
            ToIndex = MutString.indexOf(">");
            if (ToIndex < dst.numStop + 1) {
                return false;
            }
            dst.originalResidue = MutString.substring(dst.numStop, ToIndex);
            dst.newResidue = MutString.substring(ToIndex + 1);
            dst.annotationType = 0;
            dst.dnaStart = Pos2;
            dst.aaStart = MutationAnnotation.BpToCodon(Pos2);
        } else if (dst.numStart == 3) {
            dst.originalResidue = MutString.substring(0, dst.numStart);
            dst.newResidue = MutString.substring(dst.numStop);
            dst.annotationType = 1;
            dst.aaStart = Pos2;
            dst.dnaStart = MutationAnnotation.CodonToBp(Pos2);
        } else if (dst.numStart == 1) {
            dst.originalResidue = MutString.substring(0, 1).trim();
            dst.newResidue = MutString.substring(dst.numStop);
            if (!MutationAnnotation.isDNA(dst.originalResidue) || !MutationAnnotation.isDNA(dst.newResidue)) {
                dst.annotationType = 1;
                dst.aaStart = Pos2;
                dst.dnaStart = MutationAnnotation.CodonToBp(Pos2);
            } else if (MutationAnnotation.isDNA(dst.originalResidue) && MutationAnnotation.isDNA(dst.newResidue)) {
                dst.annotationType = 0;
                dst.dnaStart = Pos2;
                dst.aaStart = MutationAnnotation.BpToCodon(Pos2);
            }
        } else {
            dst.annotationType = 99;
            dst.dnaStart = Pos2;
            dst.aaStart = MutationAnnotation.BpToCodon(Pos2);
            return false;
        }
        dst.originalResidue = dst.originalResidue.trim();
        dst.newResidue = dst.newResidue.trim();
        return true;
    }

    private static boolean isAA(String Seq) {
        String tmpString = Seq.replaceAll("[^*ACDEFGHIKLMNPQRSTVWYacdefghiklmnpqrstvwy]", "");
        return Seq.length() == tmpString.length() && Seq.equals(tmpString);
    }

    private static boolean isDNA(String Seq) {
        String tmpString = Seq.replaceAll("[^atgcnATGCN]", "");
        return Seq.length() == tmpString.length() && Seq.equals(tmpString);
    }

    private static String ProperCap(String inString) {
        if (inString.length() < 2) {
            return inString.toUpperCase();
        }
        return inString.substring(0, 1).toUpperCase() + inString.substring(1).toLowerCase();
    }

    private static int CodonToBp(int CodonNum) {
        return CodonNum * 3 - 2;
    }
}

