/*
 * Decompiled with CFR 0.152.
 */
package DNATools;

import DNATools.TmCalculator;
import java.beans.BeanProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class GibsonPrimerDesigner {
    private static int tmType = 0;

    GibsonPrimerDesigner() {
    }

    @BeanProperty(preferred=true, enumerationValues={"GENERIC", "NEAREST_NEIGHBOR", "TAQ", "Q5_POLYMERASE", "Q5U_POLYMERASE", "VENT", "PHUSION"}, description="Set the default method of Tm calculation.")
    public static void setTmCalculationType(int type) {
        if (TmCalculator.isTypeValid(type)) {
            tmType = type;
        }
    }

    public static int getTmCalculationType() {
        return tmType;
    }

    public static List<List<PrimerPair>> multiplexPrimerDesign(List<String[]> multiplexFragments, List<String> multiplexBackbones, int overlapLength, int primerBindLength) {
        ArrayList<List<PrimerPair>> allResults = new ArrayList<List<PrimerPair>>();
        for (int setIdx = 0; setIdx < multiplexFragments.size(); ++setIdx) {
            String[] fragments = multiplexFragments.get(setIdx);
            String backbone = multiplexBackbones.get(setIdx);
            allResults.add(GibsonPrimerDesigner.generatePrimers(fragments, backbone, overlapLength, primerBindLength));
        }
        return allResults;
    }

    public static List<PrimerPair> generatePrimers(String[] fragments, String backbone, int overlapLength, int primerBindLength) {
        int i;
        ArrayList<PrimerPair> primerPairs = new ArrayList<PrimerPair>();
        int n = fragments.length;
        int overlapLeft = overlapLength / 2;
        int overlapRight = overlapLength - overlapLeft;
        String backboneUC = backbone.toUpperCase();
        String[] fragmentsUC = new String[n];
        for (i = 0; i < n; ++i) {
            fragmentsUC[i] = fragments[i].toUpperCase();
        }
        for (i = 0; i < n; ++i) {
            String frag = fragmentsUC[i];
            if (frag.length() < primerBindLength) {
                throw new IllegalArgumentException("Fragment " + (i + 1) + " is too short for the specified binding length.");
            }
            String fOverlap = i == 0 ? backboneUC.substring(backboneUC.length() - overlapLength) : fragmentsUC[i - 1].substring(fragmentsUC[i - 1].length() - overlapRight);
            fOverlap = fOverlap.toLowerCase();
            String fBind = frag.substring(0, primerBindLength).toUpperCase();
            String forwardPrimer = fOverlap + fBind;
            String rOverlapRaw = i == n - 1 ? backboneUC.substring(0, overlapLength) : fragmentsUC[i + 1].substring(0, overlapLeft);
            String rOverlap = GibsonPrimerDesigner.reverseComplement(rOverlapRaw).toLowerCase();
            String rBindRaw = frag.substring(frag.length() - primerBindLength);
            String rBind = GibsonPrimerDesigner.reverseComplement(rBindRaw).toUpperCase();
            String reversePrimer = rOverlap + rBind;
            double fGc = GibsonPrimerDesigner.gcContent(fBind);
            double rGc = GibsonPrimerDesigner.gcContent(rBind);
            double fTm = TmCalculator.getTm(fBind, tmType);
            double rTm = TmCalculator.getTm(rBind, tmType);
            boolean fHomopolymer = GibsonPrimerDesigner.hasHomopolymer(fBind);
            boolean rHomopolymer = GibsonPrimerDesigner.hasHomopolymer(rBind);
            boolean fSelfComp = GibsonPrimerDesigner.selfComplementary(fBind);
            boolean rSelfComp = GibsonPrimerDesigner.selfComplementary(rBind);
            boolean fOk = fGc >= 40.0 && fGc <= 60.0 && fTm >= 55.0 && fTm <= 65.0 && !fHomopolymer && !fSelfComp;
            boolean rOk = rGc >= 40.0 && rGc <= 60.0 && rTm >= 55.0 && rTm <= 65.0 && !rHomopolymer && !rSelfComp;
            primerPairs.add(new PrimerPair(forwardPrimer, reversePrimer, fGc, fTm, fHomopolymer, fSelfComp, fOk, rGc, rTm, rHomopolymer, rSelfComp, rOk));
        }
        return primerPairs;
    }

    public static String reverseComplement(String seq) {
        StringBuilder sb = new StringBuilder();
        seq = seq.toUpperCase();
        block6: for (int i = seq.length() - 1; i >= 0; --i) {
            char c = seq.charAt(i);
            switch (c) {
                case 'A': {
                    sb.append('T');
                    continue block6;
                }
                case 'T': {
                    sb.append('A');
                    continue block6;
                }
                case 'C': {
                    sb.append('G');
                    continue block6;
                }
                case 'G': {
                    sb.append('C');
                    continue block6;
                }
                default: {
                    sb.append('N');
                }
            }
        }
        return sb.toString();
    }

    public static double gcContent(String seq) {
        int gc = 0;
        seq = seq.toUpperCase();
        for (char c : seq.toCharArray()) {
            if (c != 'G' && c != 'C') continue;
            ++gc;
        }
        return 100.0 * (double)gc / (double)seq.length();
    }

    public static boolean hasHomopolymer(String seq) {
        int count = 1;
        char prev = '\u0000';
        seq = seq.toUpperCase();
        for (char c : seq.toCharArray()) {
            count = c == prev ? ++count : 1;
            if (count >= 4) {
                return true;
            }
            prev = c;
        }
        return false;
    }

    public static boolean selfComplementary(String seq) {
        int len = seq.length();
        seq = seq.toUpperCase();
        for (int i = 0; i < len - 3; ++i) {
            String sub = seq.substring(i, i + 4);
            String rc = GibsonPrimerDesigner.reverseComplement(sub);
            if (!seq.contains(rc)) continue;
            return true;
        }
        return false;
    }

    public static String exportCSV(List<List<PrimerPair>> multiplexResults) {
        StringBuilder sb = new StringBuilder();
        sb.append("Set,Fragment,Direction,Sequence,GC(%),Tm,Homopolymer,SelfComplement,Status\n");
        for (int setIdx = 0; setIdx < multiplexResults.size(); ++setIdx) {
            List<PrimerPair> primers = multiplexResults.get(setIdx);
            for (int i = 0; i < primers.size(); ++i) {
                sb.append(String.format("%d,", setIdx + 1));
                sb.append(primers.get(i).csvLine(i, "forward")).append("\n");
                sb.append(String.format("%d,", setIdx + 1));
                sb.append(primers.get(i).csvLine(i, "reverse")).append("\n");
            }
        }
        return sb.toString();
    }

    public static String exportTSV(List<List<PrimerPair>> multiplexResults) {
        StringBuilder sb = new StringBuilder();
        sb.append("Set\tFragment\tDirection\tSequence\tGC(%)\tTm\tHomopolymer\tSelfComplement\tStatus\n");
        for (int setIdx = 0; setIdx < multiplexResults.size(); ++setIdx) {
            List<PrimerPair> primers = multiplexResults.get(setIdx);
            for (int i = 0; i < primers.size(); ++i) {
                sb.append(String.format("%d\t", setIdx + 1));
                sb.append(primers.get(i).tsvLine(i, "forward")).append("\n");
                sb.append(String.format("%d\t", setIdx + 1));
                sb.append(primers.get(i).tsvLine(i, "reverse")).append("\n");
            }
        }
        return sb.toString();
    }

    public static String exportFASTA(List<List<PrimerPair>> multiplexResults) {
        StringBuilder sb = new StringBuilder();
        for (int setIdx = 0; setIdx < multiplexResults.size(); ++setIdx) {
            List<PrimerPair> primers = multiplexResults.get(setIdx);
            for (int i = 0; i < primers.size(); ++i) {
                sb.append(String.format(">Set%d_Fragment%d_forward\n%s\n", setIdx + 1, i + 1, primers.get((int)i).forward));
                sb.append(String.format(">Set%d_Fragment%d_reverse\n%s\n", setIdx + 1, i + 1, primers.get((int)i).reverse));
            }
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        List<String[]> multiplexFragments = Arrays.asList({"atgcgtacgtagctagctagctagctagctgatcgatgctagcatgcaatgcgtacgtagctagctagctagctagctgatcgatgctagcatgca", "gctagctgactgatcgatgctagctagctgactgatcgatcgtacgtaggctagctgactgatcgatgctagctagctgactgatcgatcgtacgtag", "tacgtagctagctagcatgctagctgatcgtagctagcatcgatcgtactacgtagctagctagcatgctagctgatcgtagctagcatcgatcgtac"}, {"acgtagctagctgatcgatctgacgtagctagctgatcgatctgacgtagctagctgatcgatctgacgtagctagctgatcgatc", "cgtagctagctgatcgatctgacgtagctagctgatcgatctgacgtagctagctgatcgatctgacgtagctagctgatcgatc"});
        List<String> multiplexBackbones = Arrays.asList("atgcgtacgtagctagcatgctagctagctgatcgatgctagcatgcatgcgtacgtagctagcatgctagctagctgatcgatgctagcatgcatgcgtacgtagctagcatgctagctagctgatcgatgctagcatgca", "cgatctgacgtagctagctgatcgatctgacgtagctagctgatcgatc");
        int overlapLength = 15;
        int primerBindLength = 20;
        List<List<PrimerPair>> multiplexResults = GibsonPrimerDesigner.multiplexPrimerDesign(multiplexFragments, multiplexBackbones, overlapLength, primerBindLength);
        for (int setIdx = 0; setIdx < multiplexResults.size(); ++setIdx) {
            System.out.println("Multiplex set " + (setIdx + 1) + ":");
            List<PrimerPair> primers = multiplexResults.get(setIdx);
            for (int i = 0; i < primers.size(); ++i) {
                System.out.println("Fragment " + (i + 1) + " primers:");
                System.out.println(primers.get(i));
            }
            System.out.println();
        }
        System.out.println("CSV Export:\n" + GibsonPrimerDesigner.exportCSV(multiplexResults));
        System.out.println("TSV Export:\n" + GibsonPrimerDesigner.exportTSV(multiplexResults));
        System.out.println("FASTA Export:\n" + GibsonPrimerDesigner.exportFASTA(multiplexResults));
    }

    public static class PrimerPair {
        public String forward;
        public String reverse;
        public double forwardGC;
        public double forwardTm;
        public boolean forwardHomopolymer;
        public boolean forwardSelfComp;
        public boolean forwardOk;
        public double reverseGC;
        public double reverseTm;
        public boolean reverseHomopolymer;
        public boolean reverseSelfComp;
        public boolean reverseOk;

        public PrimerPair(String f, String r, double fgc, double ftm, boolean fhp, boolean fsc, boolean fok, double rgc, double rtm, boolean rhp, boolean rsc, boolean rok) {
            this.forward = f;
            this.reverse = r;
            this.forwardGC = fgc;
            this.forwardTm = ftm;
            this.forwardHomopolymer = fhp;
            this.forwardSelfComp = fsc;
            this.forwardOk = fok;
            this.reverseGC = rgc;
            this.reverseTm = rtm;
            this.reverseHomopolymer = rhp;
            this.reverseSelfComp = rsc;
            this.reverseOk = rok;
        }

        public String csvLine(int fragmentIdx, String direction) {
            Object[] objectArray = new Object[8];
            objectArray[0] = fragmentIdx + 1;
            objectArray[1] = direction;
            objectArray[2] = direction.equals("forward") ? this.forward : this.reverse;
            objectArray[3] = direction.equals("forward") ? this.forwardGC : this.reverseGC;
            objectArray[4] = direction.equals("forward") ? this.forwardTm : this.reverseTm;
            Object object = (direction.equals("forward") ? this.forwardHomopolymer : this.reverseHomopolymer) ? "YES" : (objectArray[5] = "NO");
            Object object2 = (direction.equals("forward") ? this.forwardSelfComp : this.reverseSelfComp) ? "YES" : (objectArray[6] = "NO");
            objectArray[7] = (direction.equals("forward") ? this.forwardOk : this.reverseOk) ? "OK" : "CHECK";
            return String.format("%d,%s,%s,%.1f,%.1f,%s,%s,%s", objectArray);
        }

        public String tsvLine(int fragmentIdx, String direction) {
            Object[] objectArray = new Object[8];
            objectArray[0] = fragmentIdx + 1;
            objectArray[1] = direction;
            objectArray[2] = direction.equals("forward") ? this.forward : this.reverse;
            objectArray[3] = direction.equals("forward") ? this.forwardGC : this.reverseGC;
            objectArray[4] = direction.equals("forward") ? this.forwardTm : this.reverseTm;
            Object object = (direction.equals("forward") ? this.forwardHomopolymer : this.reverseHomopolymer) ? "YES" : (objectArray[5] = "NO");
            Object object2 = (direction.equals("forward") ? this.forwardSelfComp : this.reverseSelfComp) ? "YES" : (objectArray[6] = "NO");
            objectArray[7] = (direction.equals("forward") ? this.forwardOk : this.reverseOk) ? "OK" : "CHECK";
            return String.format("%d\t%s\t%s\t%.1f\t%.1f\t%s\t%s\t%s", objectArray);
        }

        public String fastaForward(int fragmentIdx) {
            return String.format(">Fragment%d_forward\n%s", fragmentIdx + 1, this.forward);
        }

        public String fastaReverse(int fragmentIdx) {
            return String.format(">Fragment%d_reverse\n%s", fragmentIdx + 1, this.reverse);
        }

        public String toString() {
            return "Forward: " + this.forward + "\n  GC: " + String.format("%.1f", this.forwardGC) + "% Tm: " + String.format("%.1f", this.forwardTm) + " Homopolymer: " + (this.forwardHomopolymer ? "yes" : "no") + " Self-complementary: " + (this.forwardSelfComp ? "yes" : "no") + " [" + (this.forwardOk ? "OK" : "Check!") + "]\nReverse: " + this.reverse + "\n  GC: " + String.format("%.1f", this.reverseGC) + "% Tm: " + String.format("%.1f", this.reverseTm) + " Homopolymer: " + (this.reverseHomopolymer ? "yes" : "no") + " Self-complementary: " + (this.reverseSelfComp ? "yes" : "no") + " [" + (this.reverseOk ? "OK" : "Check!") + "]\n";
        }
    }
}

