/*
 * Decompiled with CFR 0.152.
 */
package DNAAnalyzer;

import DNAAnalyzer.AnalyzerResult;
import DNAAnalyzer.ResultProperty;
import java.util.ArrayList;

public abstract class SequenceAnalyzer {
    float minCutoff = 0.0f;
    float maxCutoff = 1.0f;
    float cutoff = 0.7f;
    ArrayList<AnalyzerResult> results = new ArrayList();
    int startIndex = 0;
    int stopIndex = 0;

    public float getCutoff() {
        return this.cutoff;
    }

    public void setCutoff(float cutoff) {
        this.cutoff = Math.min(this.maxCutoff, Math.max(cutoff, this.minCutoff));
    }

    public void setStartStop(int start, int stop) {
        this.startIndex = start > -1 ? start : 0;
        this.stopIndex = start > -1 ? stop : 0;
    }

    public void dumpResults() {
        if (this.results.isEmpty()) {
            System.out.println("No results found");
        } else {
            for (AnalyzerResult result : this.results) {
                System.out.println("\nscore : " + result.score);
                for (ResultProperty property : result.properties) {
                    System.out.println(property.name + " : " + property.value);
                }
            }
        }
    }

    public void addResult(AnalyzerResult result) {
        this.results.add(result);
    }

    public void clearResults() {
        this.results.clear();
    }

    public int resultCount() {
        return this.results.size();
    }

    public AnalyzerResult getResult(int index) {
        if (!this.results.isEmpty() && index > -1 && index < this.results.size()) {
            return this.results.get(index);
        }
        return null;
    }

    public AnalyzerResult[] getResults() {
        return SequenceAnalyzer.resultsToArray(this.results);
    }

    static AnalyzerResult[] resultsToArray(ArrayList<AnalyzerResult> results) {
        if (results == null || results.isEmpty()) {
            return null;
        }
        AnalyzerResult[] outVal = new AnalyzerResult[results.size()];
        for (int x = 0; x < results.size(); ++x) {
            outVal[x] = results.get(x);
        }
        return outVal;
    }
}

