/*
 * Decompiled with CFR 0.152.
 */
package DNAAnalyzer;

public class ScoringMatrix {
    private static final float[][] P35 = new float[][]{{1.0f, 0.99f, 0.78f, 0.27f, 0.94f, 1.36f, 1.29f, 1.32f}, {1.14f, 0.75f, 2.14f, 2.51f, 0.55f, 0.8f, 0.58f, 0.96f}, {0.76f, 1.12f, 0.49f, 0.9f, 0.0f, 1.14f, 1.8f, 0.62f}, {1.05f, 1.21f, 0.3f, 0.06f, 2.68f, 0.65f, 0.37f, 1.01f}, {0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f}};
    private static final float[][] P35_2 = new float[][]{{0.78f, 0.27f, 0.94f, 1.36f, 1.29f, 1.32f}, {2.14f, 2.51f, 0.55f, 0.8f, 0.58f, 0.96f}, {0.49f, 0.9f, 0.0f, 1.14f, 1.8f, 0.62f}, {0.3f, 0.06f, 2.68f, 0.65f, 0.37f, 1.01f}};
    private static final float[][] P15 = new float[][]{{0.92f, 0.83f, 0.71f, 0.64f, 0.6f, 0.09f}, {1.15f, 0.97f, 1.18f, 0.85f, 1.05f, 2.69f}, {0.99f, 1.15f, 1.14f, 0.86f, 1.07f, 0.65f}, {0.92f, 1.11f, 1.01f, 1.8f, 1.4f, 0.33f}};
    private static final float[][] P10 = new float[][]{{0.09f, 3.17f, 1.05f, 2.14f, 2.01f, 0.1f}, {2.69f, 0.29f, 1.56f, 0.6f, 0.38f, 3.21f}, {0.04f, 0.04f, 0.56f, 0.6f, 1.05f, 0.22f}, {0.33f, 0.03f, 0.63f, 0.42f, 0.43f, 0.06f}};
    private static final float[][] KOZAK = new float[][]{{0.2f, 0.2f, 0.21f, 0.21f, 0.19f, 0.24f, 0.46f, 0.29f, 0.19f}, {0.18f, 0.18f, 0.19f, 0.17f, 0.19f, 0.12f, 0.07f, 0.13f, 0.08f}, {0.27f, 0.33f, 0.32f, 0.23f, 0.32f, 0.38f, 0.1f, 0.38f, 0.45f}, {0.35f, 0.29f, 0.28f, 0.39f, 0.3f, 0.26f, 0.37f, 0.2f, 0.28f}};
    private static final float[][] GTSD = new float[][]{{34.0f, 60.4f, 9.2f, 0.0f, 0.0f, 52.6f, 71.3f, 7.1f, 16.0f}, {11.4f, 14.2f, 7.3f, 0.0f, 100.0f, 2.5f, 9.3f, 5.9f, 46.2f}, {36.3f, 12.9f, 3.3f, 0.0f, 0.0f, 2.8f, 7.6f, 5.5f, 16.5f}, {18.3f, 12.5f, 80.3f, 100.0f, 0.0f, 41.9f, 11.8f, 81.4f, 20.9f}, {0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f}};
    private static final char[] reqGTSD = new char[]{'\u0000', '\u0000', '\u0000', 'G', 'T', '\u0000', '\u0000', '\u0000', '\u0000'};
    private static final float[][] GCSD = new float[][]{{40.5f, 88.9f, 1.6f, 0.0f, 0.0f, 87.3f, 84.1f, 1.6f, 7.9f}, {1.6f, 8.7f, 0.0f, 0.0f, 0.0f, 0.0f, 6.3f, 0.8f, 70.6f}, {42.1f, 0.8f, 0.8f, 0.0f, 100.0f, 0.0f, 3.2f, 0.8f, 11.9f}, {15.9f, 1.6f, 97.6f, 100.0f, 0.0f, 12.7f, 6.3f, 96.8f, 9.5f}, {0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f}};
    private static final char[] reqGCSD = new char[]{'\u0000', '\u0000', '\u0000', 'G', 'C', '\u0000', '\u0000', '\u0000', '\u0000'};
    private static final float[][] GTSA = new float[][]{{9.0f, 8.4f, 7.5f, 6.8f, 7.6f, 8.0f, 9.7f, 9.2f, 7.6f, 7.8f, 23.7f, 4.2f, 100.0f, 0.0f, 23.9f}, {42.3f, 44.0f, 47.0f, 49.4f, 47.1f, 46.3f, 40.8f, 42.9f, 44.5f, 50.4f, 24.0f, 24.6f, 0.0f, 0.0f, 10.4f}, {31.0f, 31.0f, 30.7f, 29.3f, 32.6f, 33.0f, 37.3f, 38.5f, 41.0f, 35.2f, 30.9f, 70.8f, 0.0f, 0.0f, 13.8f}, {12.5f, 11.5f, 10.6f, 10.4f, 11.0f, 11.3f, 11.3f, 8.5f, 6.6f, 6.4f, 21.2f, 3.0f, 0.0f, 100.0f, 52.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f}};
    private static final char[] reqGTSA = new char[]{'\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', 'A', 'G', '\u0000'};
    private static final float[][] GCSA = new float[][]{{11.1f, 12.7f, 3.2f, 4.8f, 12.7f, 8.7f, 16.7f, 16.7f, 12.7f, 9.5f, 26.2f, 6.3f, 100.0f, 0.0f, 21.4f}, {38.9f, 41.3f, 58.7f, 55.6f, 42.1f, 40.5f, 30.9f, 37.3f, 44.4f, 47.6f, 27.0f, 25.4f, 0.0f, 0.0f, 7.9f}, {36.5f, 30.9f, 19.1f, 23.0f, 34.9f, 39.7f, 34.9f, 40.5f, 40.5f, 36.5f, 33.3f, 68.2f, 0.0f, 0.0f, 17.9f}, {9.5f, 10.3f, 15.1f, 12.7f, 8.7f, 9.5f, 16.7f, 4.8f, 2.4f, 6.3f, 13.5f, 0.0f, 0.0f, 100.0f, 62.7f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f}};
    private static final char[] reqGCSA = new char[]{'\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', 'A', 'G', '\u0000'};
    private static final float[][] CAP = new float[][]{{23.0f, 23.0f, 18.0f, 0.0f, 2.0f, 1.0f, 4.0f, 43.0f, 6.0f, 9.0f, 9.0f, 15.0f, 10.0f, 16.0f, 6.0f, 7.0f, 34.0f, 10.0f, 33.0f, 12.0f, 18.0f, 14.0f}, {21.0f, 18.0f, 18.0f, 39.0f, 6.0f, 40.0f, 4.0f, 0.0f, 24.0f, 13.0f, 20.0f, 10.0f, 9.0f, 15.0f, 34.0f, 3.0f, 3.0f, 7.0f, 6.0f, 20.0f, 30.0f, 24.0f}, {1.0f, 2.0f, 4.0f, 8.0f, 1.0f, 8.0f, 0.0f, 3.0f, 10.0f, 17.0f, 15.0f, 7.0f, 8.0f, 10.0f, 3.0f, 39.0f, 1.0f, 32.0f, 4.0f, 10.0f, 1.0f, 7.0f}, {4.0f, 6.0f, 9.0f, 2.0f, 40.0f, 0.0f, 41.0f, 3.0f, 9.0f, 10.0f, 5.0f, 17.0f, 21.0f, 7.0f, 6.0f, 0.0f, 11.0f, 0.0f, 6.0f, 7.0f, 0.0f, 4.0f}};
    private static final float[][] MEF = new float[][]{{23.0f, 23.0f, 18.0f, 0.0f, 2.0f, 1.0f, 4.0f, 43.0f, 6.0f, 9.0f, 9.0f, 15.0f}, {21.0f, 18.0f, 18.0f, 39.0f, 6.0f, 40.0f, 4.0f, 0.0f, 24.0f, 13.0f, 20.0f, 10.0f}, {1.0f, 2.0f, 4.0f, 8.0f, 1.0f, 8.0f, 0.0f, 3.0f, 10.0f, 17.0f, 15.0f, 7.0f}, {4.0f, 6.0f, 9.0f, 2.0f, 40.0f, 0.0f, 41.0f, 3.0f, 9.0f, 10.0f, 5.0f, 17.0f}};
    private static final float[][] SHINE_DALGARNO = new float[][]{{0.27f, 0.38f, 0.76f, 0.0f, 0.0f, 0.85f, 0.19f}, {0.38f, 0.0f, 0.1f, 0.0f, 0.0f, 0.11f, 0.15f}, {0.15f, 0.3f, 0.07f, 0.0f, 0.02f, 0.02f, 0.06f}, {0.2f, 0.32f, 0.07f, 0.99f, 0.98f, 0.02f, 0.6f}, {0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f}};
    static final ScoringMatrix Matrix_P35 = new ScoringMatrix(P35);
    static final ScoringMatrix Matrix_P35_2 = new ScoringMatrix(P35_2);
    static final ScoringMatrix Matrix_P10 = new ScoringMatrix(P10);
    static final ScoringMatrix Matrix_P15 = new ScoringMatrix(P15);
    static final ScoringMatrix Matrix_KOZAK = new ScoringMatrix(KOZAK);
    static final ScoringMatrix Matrix_GTSD = new ScoringMatrix(GTSD, reqGTSD);
    static final ScoringMatrix Matrix_GCSD = new ScoringMatrix(GCSD, reqGCSD);
    static final ScoringMatrix Matrix_GTSA = new ScoringMatrix(GTSA, reqGTSA);
    static final ScoringMatrix Matrix_GCSA = new ScoringMatrix(GCSA, reqGCSA);
    static final ScoringMatrix Matrix_CAP = new ScoringMatrix(CAP);
    static final ScoringMatrix Matrix_MEF = new ScoringMatrix(MEF);
    static final ScoringMatrix Matrix_SD = new ScoringMatrix(SHINE_DALGARNO);
    private static final int row_A = 0;
    private static final int row_T = 1;
    private static final int row_C = 2;
    private static final int row_G = 3;
    private static final int row_Max = 4;
    float maxScore = 0.0f;
    float[] maxScores;
    float[][] matrix;
    char[] required;
    int[] caseArray;
    int minLength = 0;

    public ScoringMatrix(float[][] scoringMatrix) {
        this.setMatrix(scoringMatrix);
    }

    public ScoringMatrix(float[][] scoringMatrix, char[] requiredPositions) {
        this.setMatrix(scoringMatrix);
        this.setRequired(requiredPositions);
    }

    public ScoringMatrix(float[][] scoringMatrix, char[] requiredPositions, int[] caseArray) {
        this.setMatrix(scoringMatrix);
        this.setRequired(requiredPositions);
        this.setCaseArray(caseArray);
    }

    public ScoringMatrix(float[][] scoringMatrix, int[] caseArray) {
        this.setMatrix(scoringMatrix);
        this.setCaseArray(caseArray);
    }

    public boolean setRequired(char[] requiredArray) {
        this.required = null;
        if (this.matrix != null && this.matrix[0].length == requiredArray.length) {
            this.required = requiredArray;
        }
        return this.required != null;
    }

    public boolean setCaseArray(int[] caseArray) {
        this.caseArray = null;
        if (this.matrix != null && this.matrix[0].length == caseArray.length) {
            this.caseArray = caseArray;
        }
        return this.caseArray != null;
    }

    public void setMatrix(float[][] scoringMatrix) {
        int col;
        this.required = null;
        this.minLength = scoringMatrix[0].length;
        this.matrix = new float[4][this.minLength];
        this.maxScores = new float[this.minLength];
        for (col = 0; col < this.minLength; ++col) {
            this.maxScores[col] = 0.0f;
            for (int row = 0; row < 4; ++row) {
                this.matrix[row][col] = scoringMatrix[row][col];
                if (!(this.matrix[row][col] > this.maxScores[col])) continue;
                this.maxScores[col] = this.matrix[row][col];
            }
            this.maxScore += this.maxScores[col];
        }
        if (scoringMatrix.length > 4) {
            this.caseArray = new int[this.minLength];
            for (col = 0; col < this.minLength; ++col) {
                this.caseArray[col] = (int)scoringMatrix[4][col];
            }
        }
        if (this.minLength < this.matrix.length) {
            this.minLength = this.matrix.length;
        }
    }

    String formatSequence(char[] sequence, int start) {
        if (start < 0 || start + this.minLength > sequence.length) {
            return "";
        }
        char[] outChar = new char[this.minLength];
        for (int col = 0; col < this.minLength; ++col) {
            char chr = sequence[start + col];
            if (this.caseArray != null) {
                switch (this.caseArray[col]) {
                    case 0: {
                        if (chr > '@' && chr < '[') {
                            outChar[col] = (char)(chr + 32);
                            break;
                        }
                        outChar[col] = chr;
                        break;
                    }
                    case 1: {
                        if (chr > '`' && chr < '{') {
                            outChar[col] = (char)(chr - 32);
                            break;
                        }
                        outChar[col] = chr;
                        break;
                    }
                    default: {
                        outChar[col] = chr;
                        break;
                    }
                }
                continue;
            }
            outChar[col] = chr;
        }
        return new String(outChar);
    }

    public float score(char[] sequence, int start) {
        if (start < 0 || start + this.minLength > sequence.length) {
            return 0.0f;
        }
        if (this.required != null) {
            for (int col = 0; col < this.minLength; ++col) {
                if (this.required[col] <= '\u0000' || ScoringMatrix.charMatch(sequence[start + col], this.required[col])) continue;
                return 0.0f;
            }
        }
        float score = 0.0f;
        for (int col = 0; col < this.minLength; ++col) {
            char chr = sequence[start + col];
            int row = 0;
            switch (chr) {
                case 'A': 
                case 'a': {
                    row = 0;
                    break;
                }
                case 'T': 
                case 't': {
                    row = 1;
                    break;
                }
                case 'C': 
                case 'c': {
                    row = 2;
                    break;
                }
                case 'G': 
                case 'g': {
                    row = 3;
                }
            }
            score += this.matrix[row][col] / this.maxScores[col];
        }
        return score / (float)this.minLength;
    }

    private static boolean charMatch(char seqChar, char matrixChar) {
        if (seqChar == matrixChar) {
            return true;
        }
        switch (seqChar) {
            case 'A': {
                return matrixChar == 'R' || matrixChar == 'W' || matrixChar == 'M' || matrixChar == 'D' || matrixChar == 'H' || matrixChar == 'V';
            }
            case 'T': {
                return matrixChar == 'Y' || matrixChar == 'W' || matrixChar == 'K' || matrixChar == 'H' || matrixChar == 'B' || matrixChar == 'D';
            }
            case 'C': {
                return matrixChar == 'Y' || matrixChar == 'S' || matrixChar == 'M' || matrixChar == 'B' || matrixChar == 'H' || matrixChar == 'D';
            }
            case 'G': {
                return matrixChar == 'R' || matrixChar == 'S' || matrixChar == 'K' || matrixChar == 'B' || matrixChar == 'D' || matrixChar == 'V';
            }
        }
        return false;
    }
}

