/*
 * Decompiled with CFR 0.152.
 */
package DNAAnalyzer;

import DNAAnalyzer.ResultProperty;
import java.util.ArrayList;
import java.util.Comparator;

public class AnalyzerResult {
    public static final Comparator<AnalyzerResult> sortScoreLowToHigh = (arg0, arg1) -> {
        if (arg0.getScore() > arg1.getScore()) {
            return 1;
        }
        if (arg0.score < arg1.score) {
            return -1;
        }
        return 0;
    };
    public static final Comparator<AnalyzerResult> sortScoreHighToLow = (arg0, arg1) -> {
        if (arg0.getScore() < arg1.getScore()) {
            return 1;
        }
        if (arg0.score > arg1.score) {
            return -1;
        }
        return 0;
    };
    public static final Comparator<AnalyzerResult> sortStartLowToHigh = (arg0, arg1) -> {
        if (arg0.getScore() > arg1.getScore()) {
            return 1;
        }
        if (arg0.start < arg1.start) {
            return -1;
        }
        return 0;
    };
    public static final Comparator<AnalyzerResult> sortStartHighToLow = (arg0, arg1) -> {
        if (arg0.getScore() < arg1.getScore()) {
            return 1;
        }
        if (arg0.start > arg1.start) {
            return -1;
        }
        return 0;
    };
    ArrayList<ResultProperty> properties = new ArrayList();
    float score = 0.0f;
    int start = 0;
    int stop = 0;
    String sequence = "";
    String description = "";

    public AnalyzerResult() {
    }

    public AnalyzerResult(float score) {
        this.score = score;
    }

    public AnalyzerResult(String description) {
        this.description = description;
    }

    public AnalyzerResult(String description, float score) {
        this.description = description;
        this.score = score;
    }

    public float getScore() {
        return this.score;
    }

    public int getStart() {
        return this.start;
    }

    public int getStop() {
        return this.stop;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSequence() {
        return this.sequence;
    }

    public void addProperty(String name, Object value) {
        this.properties.add(new ResultProperty(name, value));
    }

    public void addProperty(ResultProperty property) {
        this.properties.add(property);
    }

    public int propertyCount() {
        return this.properties.size();
    }

    public ResultProperty getProperty(int index) {
        return this.properties.get(index);
    }

    public String getResults() {
        if (this.properties.isEmpty()) {
            return "";
        }
        String outVal = "";
        for (int x = 0; x < this.properties.size(); ++x) {
            ResultProperty prop = this.properties.get(x);
            outVal = x == 0 ? prop.name + " : " + (prop.value instanceof Float ? String.format("%.2f", prop.value) : prop.value) : outVal + "\n" + prop.name + " : " + (prop.value instanceof Float ? String.format("%.2f", prop.value) : prop.value);
        }
        return outVal;
    }
}

