/*
 * Decompiled with CFR 0.152.
 */
package CustomListBoxes;

import CustomListBoxes.ProgressListItem;
import CustomListBoxes.ProgressListRenderer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Date;
import javax.swing.DefaultListModel;
import javax.swing.JList;

public class ProgressList
extends JList {
    private progressBarType mStyle = progressBarType.progressBarGradient;
    private Color mBackColor = Color.WHITE;
    private Color mBarColor = Color.GREEN;
    private Color mTextColor = Color.BLACK;
    private Color mBorderColor = Color.BLACK;
    private DefaultListModel<ProgressListItem> listModel;

    private boolean isValidIndex(int itemIndex) {
        return itemIndex >= 0 && itemIndex <= this.listModel.getSize();
    }

    public ProgressListItem getItem(int itemIndex) {
        if (this.isValidIndex(itemIndex)) {
            return this.listModel.getElementAt(itemIndex);
        }
        return null;
    }

    public void setDefaultBackColor(Color backColor) {
        this.mBackColor = backColor;
    }

    public void setDefaultBarColor(Color barColor) {
        this.mBarColor = barColor;
    }

    public void setDefaultProgressTextColor(Color color) {
        this.mTextColor = color;
    }

    public void setDefaultProgressBorderColor(Color color) {
        this.mBorderColor = color;
    }

    public Color getDefaultBackColor() {
        return this.mBackColor;
    }

    public Color getDefaultBarColor() {
        return this.mBarColor;
    }

    public Color getDefaultProgressTextColor() {
        return this.mTextColor;
    }

    public Color getDefaultProgressBorderColor() {
        return this.mBorderColor;
    }

    public void setItemDate(int itemIndex, Date date) {
        if (this.isValidIndex(itemIndex)) {
            this.listModel.getElementAt(itemIndex).setDate(date);
        }
    }

    public Date getItemDate(int itemIndex) {
        return this.isValidIndex(itemIndex) ? this.listModel.getElementAt(itemIndex).getDate() : null;
    }

    public boolean itemHasDate(int itemIndex) {
        return this.isValidIndex(itemIndex) ? this.listModel.getElementAt(itemIndex).hasDate() : false;
    }

    public void setItemBackColor(int itemIndex, Color backColor) {
        if (this.isValidIndex(itemIndex)) {
            this.listModel.getElementAt(itemIndex).setBackColor(backColor);
        }
    }

    public void setItemBarColor(int itemIndex, Color barColor) {
        if (this.isValidIndex(itemIndex)) {
            this.listModel.getElementAt(itemIndex).setProgressBarColor(barColor);
        }
    }

    public Color getItemBackColor(int itemIndex) {
        return this.isValidIndex(itemIndex) ? this.listModel.getElementAt(itemIndex).getBackColor() : this.mBackColor;
    }

    public Color getItemBarColor(int itemIndex) {
        return this.isValidIndex(itemIndex) ? this.listModel.getElementAt(itemIndex).getProgressBarColor() : this.mBarColor;
    }

    public Color getItemProgressTextColor(int itemIndex) {
        return this.isValidIndex(itemIndex) ? this.listModel.getElementAt(itemIndex).getProgressTextColor() : this.mTextColor;
    }

    public Color getItemProgressBorderColor(int itemIndex) {
        return this.isValidIndex(itemIndex) ? this.listModel.getElementAt(itemIndex).getProgressBorderColor() : this.mBorderColor;
    }

    public void setItemProgressTextColor(int itemIndex, Color backColor) {
        if (this.isValidIndex(itemIndex)) {
            this.listModel.getElementAt(itemIndex).setProgressTextColor(backColor);
        }
    }

    public void setItemProgressBorderColor(int itemIndex, Color barColor) {
        if (this.isValidIndex(itemIndex)) {
            this.listModel.getElementAt(itemIndex).setProgressBorderColor(barColor);
        }
    }

    public void refresh() {
        Image bufferimage = this.createImage(this.getWidth(), this.getHeight());
        this.paint(bufferimage.getGraphics());
        Graphics g = this.getGraphics();
        g.drawImage(bufferimage, 0, 0, this);
    }

    public ProgressList(DefaultListModel<ProgressListItem> newListModel) {
        this.setCellRenderer(new ProgressListRenderer());
        this.listModel = newListModel;
        this.setModel(this.listModel);
    }

    public ProgressList() {
        this.setCellRenderer(new ProgressListRenderer());
        this.listModel = new DefaultListModel();
        this.listModel.addElement(new ProgressListItem("0% Test"));
        this.listModel.addElement(new ProgressListItem("10% Test", 0.1f));
        this.listModel.addElement(new ProgressListItem("20% Test", 0.2f));
        this.listModel.addElement(new ProgressListItem("50% Test", 0.5f));
        this.listModel.addElement(new ProgressListItem("75% Test", 0.75f));
        this.listModel.addElement(new ProgressListItem("100% Test", 1.0f));
        this.setModel(this.listModel);
    }

    public void clear() {
        this.listModel.removeAllElements();
    }

    public int getItemCount() {
        return this.listModel.getSize();
    }

    public String getItemText(int index) {
        return this.listModel.getElementAt(index).getName();
    }

    public void setProgressBarStyle(progressBarType style) {
        this.mStyle = style;
        this.repaint();
    }

    public boolean itemExists(String itemText) {
        for (int x = 0; x < this.listModel.getSize(); ++x) {
            if (!this.listModel.elementAt(x).getName().equalsIgnoreCase(itemText)) continue;
            return true;
        }
        return false;
    }

    public progressBarType getProgressBarStyle() {
        return this.mStyle;
    }

    public boolean contains(String itemName) {
        return this.listModel.contains(itemName);
    }

    public void setItemPercentDone(int itemIndex, float percentDone) {
        if (this.isValidIndex(itemIndex)) {
            this.listModel.getElementAt(itemIndex).setPercentDone(percentDone);
            this.refresh();
        }
    }

    public float getItemPercent(int itemIndex) {
        return this.isValidIndex(itemIndex) ? this.listModel.getElementAt(itemIndex).getPercentDone() : 0.0f;
    }

    public void changeItemPercentDoneBy(int itemIndex, float changePercentDone) {
        if (this.isValidIndex(itemIndex)) {
            this.listModel.getElementAt(itemIndex).changePercentDoneBy(changePercentDone);
            this.refresh();
        }
    }

    public void removeItem(int itemIndex) {
        if (this.isValidIndex(itemIndex)) {
            this.listModel.removeElementAt(itemIndex);
        }
    }

    public void moveItemTo(int itemIndex, int newIndex) {
        if (this.isValidIndex(itemIndex) && this.isValidIndex(newIndex)) {
            ProgressListItem tmpItem = this.listModel.remove(itemIndex);
            this.listModel.add(newIndex, tmpItem);
        }
    }

    public int addItem(String text) {
        return this.addItem(text, 0.0f);
    }

    public int addItem(String text, float percentDone) {
        this.listModel.addElement(new ProgressListItem(text, percentDone, this.mBackColor, this.mBarColor, this.mTextColor, this.mBorderColor));
        this.refresh();
        return this.listModel.size() - 1;
    }

    public static enum progressBarType {
        progressBarGradient,
        progressBarSolid;

    }
}

