/*
 * Decompiled with CFR 0.152.
 */
package Buttons;

import Buttons.ButtonRenderer;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;

public class RenderedButton
extends JButton {
    ButtonModel myModel;
    ButtonRenderer renderer = new ButtonRenderer(this);

    public RenderedButton() {
        this.setBorderPainted(false);
        this.setFocusPainted(false);
        this.setContentAreaFilled(false);
        this.setOpaque(false);
        this.myModel = this.getModel();
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.renderer.setText(text);
    }

    public Color getGradientBorderColor() {
        return this.renderer.getGradientBorderColor();
    }

    public void setGradientBorderColor(Color mBorderColor) {
        this.renderer.setGradientBorderColor(mBorderColor);
        this.repaint();
    }

    public Color getGradientStartColor() {
        return this.renderer.getGradientStartColor();
    }

    public void setGradientStartColor(Color mStartColor) {
        this.renderer.setGradientStartColor(mStartColor);
        this.repaint();
    }

    public Color getGradientEndColor() {
        return this.renderer.getGradientEndColor();
    }

    public void setGradientEndColor(Color mEndColor) {
        this.renderer.setGradientEndColor(mEndColor);
        this.repaint();
    }

    @Override
    public Icon getIcon() {
        return this.renderer != null ? this.renderer.icon.getIcon(2) : null;
    }

    @Override
    public void setIcon(Icon icon) {
        if (this.renderer != null) {
            this.renderer.icon.setIcon(icon, 2);
        }
    }

    @Override
    public void setDisabledIcon(Icon icon) {
        if (this.renderer != null) {
            this.renderer.icon.setIcon(icon, 8);
        }
    }

    @Override
    public Icon getDisabledIcon() {
        return this.renderer != null ? this.renderer.icon.getIcon(8) : null;
    }

    @Override
    public Icon getDisabledSelectedIcon() {
        return this.renderer != null ? this.renderer.icon.getIcon(32) : null;
    }

    @Override
    public void setDisabledSelectedIcon(Icon icon) {
        if (this.renderer != null) {
            this.renderer.icon.setIcon(icon, 32);
        }
    }

    @Override
    public Icon getRolloverIcon() {
        return this.renderer != null ? this.renderer.icon.getIcon(1) : null;
    }

    @Override
    public void setRolloverIcon(Icon icon) {
        if (this.renderer != null) {
            this.renderer.icon.setIcon(icon, 1);
        }
    }

    @Override
    public Icon getPressedIcon() {
        return this.renderer != null ? this.renderer.icon.getIcon(4) : null;
    }

    @Override
    public void setPressedIcon(Icon icon) {
        if (this.renderer != null) {
            this.renderer.icon.setIcon(icon, 4);
        }
    }

    @Override
    public void setSelectedIcon(Icon icon) {
        if (this.renderer != null) {
            this.renderer.icon.setIcon(icon, 16);
        }
    }

    @Override
    public Icon getSelectedIcon() {
        return this.renderer != null ? this.renderer.icon.getIcon(16) : null;
    }

    public Icon getIconHot() {
        return this.getRolloverIcon();
    }

    public void setIconHot(Icon icon) {
        this.setRolloverIcon(icon);
    }

    public Icon getIconPressed() {
        return this.getPressedIcon();
    }

    public void setIconPressed(Icon icon) {
        this.setPressedIcon(icon);
    }

    public boolean isValue() {
        return this.renderer.isValue();
    }

    public void setValue(boolean Value) {
        this.renderer.setValue(Value);
        this.repaint();
    }

    public boolean isShiftOnPress() {
        return this.renderer.isShiftOnPress();
    }

    public void setShiftOnPress(boolean ShiftOnPress) {
        this.renderer.setShiftOnPress(ShiftOnPress);
    }

    public ButtonRenderer.eButtonType getButtonType() {
        return this.renderer.getButtonType();
    }

    public void setButtonType(ButtonRenderer.eButtonType ButtonType) {
        this.renderer.setButtonType(ButtonType);
        this.repaint();
    }

    public Color getColorCaptionHot() {
        return this.renderer.getColorCaptionHot();
    }

    public void setColorCaptionHot(Color ColorCaptionHot) {
        this.renderer.setColorCaptionHot(ColorCaptionHot);
        this.repaint();
    }

    public Color getColorCaptionPressed() {
        return this.renderer.getColorCaptionPressed();
    }

    public void setColorCaptionPressed(Color ColorCaptionPressed) {
        this.renderer.setColorCaptionPressed(ColorCaptionPressed);
        this.repaint();
    }

    public boolean isUseThemeColors() {
        return this.renderer.isUseThemeColors();
    }

    public void setUseThemeColors(boolean use) {
        this.renderer.setUseThemeColors(use);
    }

    public Color getColorCaptionNormal() {
        return this.renderer.getColorCaptionNormal();
    }

    public void setColorCaptionNormal(Color ColorCaptionNormal) {
        this.renderer.setColorCaptionNormal(ColorCaptionNormal);
        this.repaint();
    }

    public void setAllCaptionColors(Color color) {
        this.renderer.setAllCaptionColors(color);
        this.repaint();
    }

    public Color getColorHot() {
        return this.renderer.getColorHot();
    }

    public void setColorHot(Color color) {
        this.renderer.setColorRollover(color);
        this.repaint();
    }

    public void setAllBackColors(Color color) {
        this.renderer.setAllBackColors(color);
        this.repaint();
    }

    public Color getColorPressed() {
        return this.renderer.getColorPressed();
    }

    public void setColorPressed(Color color) {
        this.renderer.setColorPressed(color);
        this.repaint();
    }

    public Color getColorNormal() {
        return this.renderer.getColorNormal();
    }

    public void setColorNormal(Color color) {
        this.renderer.setColorNormal(color);
        this.repaint();
    }

    public ButtonRenderer.ButtonStyle getButtonStyle() {
        return this.renderer.buttonStyle;
    }

    public void setButtonStyle(ButtonRenderer.ButtonStyle mButtonStyle) {
        this.renderer.setButtonStyle(mButtonStyle);
        this.repaint();
    }

    public ButtonRenderer.Alignment getCaptionAlignment() {
        return this.renderer.getCaptionAlignment();
    }

    public void setCaptionAlignment(ButtonRenderer.Alignment CaptionAlignment) {
        this.renderer.setCaptionAlignment(CaptionAlignment);
        this.repaint();
    }

    public ButtonRenderer.Alignment getIconAlignment() {
        return this.renderer.getIconAlignment();
    }

    public void setIconAlignment(ButtonRenderer.Alignment IconAlignment) {
        this.renderer.setIconAlignment(IconAlignment);
        this.repaint();
    }

    int getMouseState() {
        if (!this.myModel.isEnabled()) {
            return this.myModel.isSelected() ? 32 : 8;
        }
        if (this.myModel.isArmed()) {
            return 4;
        }
        if (this.myModel.isSelected()) {
            return 16;
        }
        if (this.myModel.isRollover()) {
            return 1;
        }
        return 2;
    }

    @Override
    public void paint(Graphics g) {
        this.renderer.paint(g, this.getMouseState());
    }
}

