/*
 * Decompiled with CFR 0.152.
 */
package Buttons;

import Buttons.ButtonRenderer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JButton;

public class CustomBackgroundButton
extends JButton {
    ButtonRenderer renderer = new ButtonRenderer(this);

    public CustomBackgroundButton() {
        this.init();
    }

    public CustomBackgroundButton(String text) {
        super(text);
        this.init();
    }

    private void init() {
        this.setOpaque(false);
        this.setBackground(new Color(0, true));
    }

    public Color getGradientBorderColor() {
        return this.renderer.getGradientBorderColor();
    }

    public void setGradientBorderColor(Color mBorderColor) {
        this.renderer.setGradientBorderColor(mBorderColor);
        this.repaint();
    }

    public Color getGradientStartColor() {
        return this.renderer.getGradientStartColor();
    }

    public void setGradientStartColor(Color mStartColor) {
        this.renderer.setGradientStartColor(mStartColor);
        this.repaint();
    }

    public Color getGradientEndColor() {
        return this.renderer.getGradientEndColor();
    }

    public void setGradientEndColor(Color mEndColor) {
        this.renderer.setGradientEndColor(mEndColor);
        this.repaint();
    }

    public boolean isValue() {
        return this.renderer.isValue();
    }

    public void setValue(boolean Value) {
        this.renderer.setValue(Value);
        this.repaint();
    }

    public boolean isShiftOnPress() {
        return this.renderer.isShiftOnPress();
    }

    public void setShiftOnPress(boolean ShiftOnPress) {
        this.renderer.setShiftOnPress(ShiftOnPress);
    }

    public ButtonRenderer.eButtonType getButtonType() {
        return this.renderer.getButtonType();
    }

    public void setButtonType(ButtonRenderer.eButtonType ButtonType) {
        this.renderer.setButtonType(ButtonType);
        this.repaint();
    }

    public Color getColorCaptionHot() {
        return this.renderer.getColorCaptionHot();
    }

    public void setColorCaptionHot(Color ColorCaptionHot) {
        this.renderer.setColorCaptionHot(ColorCaptionHot);
        this.repaint();
    }

    public Color getColorCaptionPressed() {
        return this.renderer.getColorCaptionPressed();
    }

    public void setColorCaptionPressed(Color ColorCaptionPressed) {
        this.renderer.setColorCaptionPressed(ColorCaptionPressed);
        this.repaint();
    }

    public boolean isUseThemeColors() {
        return this.renderer.isUseThemeColors();
    }

    public void setUseThemeColors(boolean use) {
        this.renderer.setUseThemeColors(use);
    }

    public Color getColorCaptionNormal() {
        return this.renderer.getColorCaptionNormal();
    }

    public void setColorCaptionNormal(Color ColorCaptionNormal) {
        this.renderer.setColorCaptionNormal(ColorCaptionNormal);
        this.repaint();
    }

    public void setAllCaptionColors(Color color) {
        this.renderer.setAllCaptionColors(color);
        this.repaint();
    }

    public Color getColorHot() {
        return this.renderer.getColorHot();
    }

    public void setColorHot(Color color) {
        this.renderer.setColorRollover(color);
        this.repaint();
    }

    public void setAllBackColors(Color color) {
        this.renderer.setAllBackColors(color);
        this.repaint();
    }

    public Color getColorPressed() {
        return this.renderer.getColorPressed();
    }

    public void setColorPressed(Color color) {
        this.renderer.setColorPressed(color);
        this.repaint();
    }

    public Color getColorNormal() {
        return this.renderer.getColorNormal();
    }

    public void setColorNormal(Color color) {
        this.renderer.setColorNormal(color);
        this.repaint();
    }

    public ButtonRenderer.ButtonStyle getButtonStyle() {
        return this.renderer.buttonStyle;
    }

    public void setButtonStyle(ButtonRenderer.ButtonStyle mButtonStyle) {
        this.renderer.setButtonStyle(mButtonStyle);
        this.repaint();
    }

    private int getMouseState() {
        if (!this.model.isEnabled()) {
            return this.model.isSelected() ? 32 : 8;
        }
        if (this.model.isArmed()) {
            return 4;
        }
        if (this.model.isSelected()) {
            return 16;
        }
        if (this.model.isRollover()) {
            return 1;
        }
        return 2;
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        this.renderer.paint(g2d, this.getMouseState());
        super.paintComponent(g2d);
    }
}

