/*
 * Decompiled with CFR 0.152.
 */
package BuildDater;

import BuildDater.URLLabel;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

class AboutForm
extends JDialog
implements KeyListener {
    String appName = "AppName";
    String version = "VersionNumber";
    String copyright = "CopyrightInfo";
    private final Cursor handCursor = new Cursor(12);
    private final Cursor defaultCursor = new Cursor(0);
    Color mouseOverColor = Color.red;
    Color mouseDownColor = Color.orange;
    Color mouseOutColor = Color.blue;
    String url1 = "";
    String url2 = "";
    String url1Text = "";
    String url2Text = "";
    ImageIcon icon = null;
    Image iconImage = null;
    private JButton cmdClose;
    private JButton jButton1;
    private JPanel jPanel1;
    private JLabel lblCopyright;
    private URLLabel lblLink1;
    private URLLabel lblLink2;
    private JLabel lblName;
    private JLabel lblVersion;

    public AboutForm(Frame parent, boolean modal) {
        super(parent, modal);
        this.initForm(parent);
    }

    public AboutForm(Frame parent, boolean modal, String appName, String version, String copyright, String url1, String url2, ImageIcon icon) {
        super(parent, modal);
        this.initForm(parent);
        this.setInformation(appName, version, copyright, null, url1, null, url2, icon);
    }

    private void initForm(Frame parent) {
        this.initComponents();
        this.setLocationRelativeTo(parent);
        this.addKeyListener(this);
        this.cmdClose.addKeyListener(this);
        MouseListener urlLabelListener = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                JLabel caller = (JLabel)e.getComponent();
                if (caller == AboutForm.this.lblLink1 && AboutForm.this.url1.length() == 0 || caller == AboutForm.this.lblLink2 && AboutForm.this.url2.length() == 0) {
                    return;
                }
                caller.setForeground(AboutForm.this.mouseDownColor);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                JLabel caller = (JLabel)e.getComponent();
                if (caller == AboutForm.this.lblLink1 && AboutForm.this.url1.length() == 0 || caller == AboutForm.this.lblLink2 && AboutForm.this.url2.length() == 0) {
                    return;
                }
                int x = e.getX();
                int y = e.getY();
                if (x >= 0 && x <= caller.getWidth() && y > 0 && y <= caller.getHeight()) {
                    caller.setForeground(AboutForm.this.mouseOverColor);
                    if (caller == AboutForm.this.lblLink1 && AboutForm.this.url1.length() > 0) {
                        this.openURL(AboutForm.this.url1);
                    } else if (caller == AboutForm.this.lblLink2 && AboutForm.this.url2.length() > 0) {
                        this.openURL(AboutForm.this.url2);
                    }
                }
            }

            private void openURL(String url) {
                try {
                    Desktop.getDesktop().browse(new URL(url).toURI());
                }
                catch (MalformedURLException ex) {
                    Logger.getLogger(AboutForm.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IOException | URISyntaxException ex) {
                    Logger.getLogger(AboutForm.class.getName()).log(Level.SEVERE, null, ex);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                JLabel caller = (JLabel)e.getComponent();
                if (caller == AboutForm.this.lblLink1 && AboutForm.this.url1.length() == 0 || caller == AboutForm.this.lblLink2 && AboutForm.this.url2.length() == 0) {
                    return;
                }
                caller.setForeground(AboutForm.this.mouseOverColor);
                caller.setCursor(AboutForm.this.handCursor);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                JLabel caller = (JLabel)e.getComponent();
                if (caller == AboutForm.this.lblLink1 && AboutForm.this.url1.length() == 0 || caller == AboutForm.this.lblLink2 && AboutForm.this.url2.length() == 0) {
                    return;
                }
                caller.setForeground(AboutForm.this.mouseOutColor);
                caller.setCursor(AboutForm.this.defaultCursor);
            }
        };
        this.lblLink1.addMouseListener(urlLabelListener);
        this.lblLink2.addMouseListener(urlLabelListener);
        this.lblLink1.setForeground(this.mouseOutColor);
        this.lblLink2.setForeground(this.mouseOutColor);
    }

    public void setInformation(String appName, String version, String copyright, String url1, String url2, ImageIcon icon) {
        this.setInformation(appName, version, copyright, null, url1, null, url2, icon);
    }

    public void setInformation(String appName, String version, String copyright, String url1Title, String url1, String url2Title, String url2, ImageIcon icon) {
        if (appName != null) {
            this.setAppName(appName);
        }
        if (version != null) {
            this.setVersion(version);
        }
        if (copyright != null) {
            this.setCopyright(copyright);
        }
        if (url1 != null) {
            this.setURL1(url1);
        }
        if (url1Title != null) {
            this.setURL1Title(url1Title);
        }
        if (url2 != null) {
            this.setURL2(url2);
        }
        if (url2Title != null) {
            this.setURL2Title(url2Title);
        }
        if (icon != null) {
            this.setIcon(icon);
        }
    }

    public void setAppName(String appName) {
        this.lblName.setText(appName);
        this.setTitle("About " + appName);
    }

    public void setVersion(String version) {
        this.lblVersion.setText(version);
    }

    public void setCopyright(String copyright) {
        this.lblCopyright.setText(copyright);
    }

    private void setURLTitle(String newTitle, String oldTitleString, String url, JLabel label) {
        oldTitleString = newTitle;
        if (oldTitleString.length() > 0) {
            label.setText(oldTitleString);
            if (oldTitleString.equals(url)) {
                label.setToolTipText("");
            } else {
                label.setToolTipText(url);
            }
        } else {
            label.setText(url);
            label.setToolTipText("");
        }
    }

    public void setURL1Title(String title) {
        this.setURLTitle(title, this.url1Text, this.url1, this.lblLink1);
    }

    public void setURL2Title(String title) {
        this.setURLTitle(title, this.url2Text, this.url2, this.lblLink2);
    }

    public void setURL1(String title, String url1) {
        this.setURL1(url1);
        this.setURL1Title(title);
    }

    public void setURL2(String title, String url2) {
        this.setURL2(url2);
        this.setURL2Title(title);
    }

    public void setURL1(String url1) {
        this.url1 = url1;
        if (url1.length() > 0) {
            this.lblLink1.setCursor(this.handCursor);
        } else {
            this.lblLink1.setCursor(this.defaultCursor);
        }
        if (this.url1Text.length() == 0) {
            this.lblLink1.setText(url1);
        }
    }

    public void setURL2(String url2) {
        this.url2 = url2;
        if (url2.length() > 0) {
            this.lblLink2.setCursor(this.handCursor);
        } else {
            this.lblLink2.setCursor(this.defaultCursor);
        }
        if (this.url2Text.length() == 0) {
            this.lblLink2.setText(url2);
        }
    }

    public void setIcon(ImageIcon icon) {
        this.icon = icon;
        this.iconImage = icon.getImage();
        this.setIconImage(this.iconImage);
    }

    public String getAppName() {
        return this.lblName.getText();
    }

    public String getVersion() {
        return this.lblVersion.getText();
    }

    public String getCopyright() {
        return this.lblCopyright.getText();
    }

    public String getURL1() {
        return this.url1;
    }

    public String getURL2() {
        return this.url2;
    }

    public String getURL1Title() {
        return this.url1Text;
    }

    public String getURL2Title() {
        return this.url2Text;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.cmdClose = new JButton();
        this.lblName = new JLabel();
        this.lblVersion = new JLabel();
        this.lblCopyright = new JLabel();
        this.jPanel1 = new JPanel(){

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                if (AboutForm.this.iconImage != null) {
                    g.drawImage(AboutForm.this.iconImage, 0, 0, this);
                }
            }
        };
        this.lblLink1 = new URLLabel();
        this.lblLink2 = new URLLabel();
        this.jButton1.setText("jButton1");
        this.setDefaultCloseOperation(2);
        this.setTitle("About");
        this.setResizable(false);
        this.cmdClose.setText("Close");
        this.cmdClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AboutForm.this.cmdCloseActionPerformed(evt);
            }
        });
        this.lblName.setFont(new Font("Segoe UI", 3, 24));
        this.lblName.setText("AppName");
        this.lblVersion.setText("VersionNumber");
        this.lblCopyright.setText("CopyrightInfo");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 64, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 64, Short.MAX_VALUE));
        this.lblLink1.setText("uRLLabel1");
        this.lblLink2.setText("uRLLabel2");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.cmdClose, -2, 81, -2).addContainerGap()).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.lblCopyright, -1, -1, Short.MAX_VALUE).addComponent(this.lblVersion, -1, -1, Short.MAX_VALUE).addComponent(this.lblName, -2, 321, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.lblLink2, GroupLayout.Alignment.LEADING, -1, 265, Short.MAX_VALUE).addComponent(this.lblLink1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE))).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.lblName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblVersion, -2, 28, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblCopyright, -2, 24, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblLink1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblLink2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.cmdClose).addContainerGap()));
        this.pack();
    }

    private void cmdCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(AboutForm.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(AboutForm.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(AboutForm.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(AboutForm.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AboutForm dialog = new AboutForm((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 27 || e.getKeyCode() == 10) {
            this.dispose();
        }
    }
}

