/*
 * Decompiled with CFR 0.152.
 */
package BlockTree;

import BlockTree.XMLConstants;
import BlockTree.XMLElement;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;

class XMLDocument
implements XMLConstants {
    static String error = "";
    final XMLElement root = new XMLElement("root");

    static String escapeString(String inputString) {
        return inputString.trim().replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&apos;");
    }

    static String unEscapeString(String inputString) {
        return inputString.trim().replace("&amp;", "&").replace("&lt;", "<").replace("&gt;", ">").replace("&quot;", "\"").replace("&apos;", "'");
    }

    static String decodeEscape(ParseableObject xmlData) {
        String outString = "";
        while (true) {
            ++xmlData.cIndex;
            if (xmlData.cIndex >= xmlData.data.length) {
                return "";
            }
            if (xmlData.data[xmlData.cIndex] == ';') break;
            outString = outString + xmlData.data[xmlData.cIndex];
        }
        switch (outString) {
            case "amp": {
                return "&";
            }
            case "apos": {
                return "'";
            }
            case "lt": {
                return "<";
            }
            case "gt": {
                return ">";
            }
            case "quot": {
                return "\"";
            }
        }
        if (xmlData.data[xmlData.cIndex - outString.length()] == '#') {
            outString = xmlData.data[xmlData.cIndex - outString.length() + 1] == 'x' ? outString.substring(2) : outString.substring(1);
            return outString;
        }
        return "";
    }

    static String parseName(ParseableObject xmlData) {
        boolean bEnd = false;
        String outString = "";
        while (xmlData.cIndex < xmlData.data.length) {
            switch (xmlData.data[xmlData.cIndex]) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case ';': 
                case '=': {
                    bEnd = true;
                    break;
                }
                case '\"': 
                case '\'': 
                case '>': {
                    return outString;
                }
                case '/': {
                    if (xmlData.data[xmlData.cIndex + 1] == '>') {
                        return outString;
                    }
                }
                default: {
                    char chr = xmlData.data[xmlData.cIndex];
                    if (!(chr >= 'A' && chr <= 'Z' || chr >= 'a' && chr <= 'z' || chr >= '0' && chr <= '9' || chr == '_' || chr == ':') && chr != '-') break;
                    if (bEnd) {
                        return outString;
                    }
                    outString = outString + chr;
                }
            }
            ++xmlData.cIndex;
        }
        return "";
    }

    public static XMLDocument loadXML(String xmlDataString) {
        return new XMLDocument(xmlDataString);
    }

    public static XMLDocument loadXML(File file) {
        if (!file.exists()) {
            error = "file does not exist";
            return null;
        }
        if (!file.isFile()) {
            error = "specified path is not a file.";
            return null;
        }
        if (!file.canRead()) {
            error = "file does not have read permission";
            return null;
        }
        error = "";
        try {
            String xmlDataString = Files.readString(file.toPath());
            return new XMLDocument(xmlDataString);
        }
        catch (IOException ex) {
            error = "Error reading file contents";
            return null;
        }
    }

    public boolean read(File file) {
        if (!file.exists()) {
            error = "file does not exist";
            return false;
        }
        if (!file.isFile()) {
            error = "specified path is not a file.";
            return false;
        }
        if (!file.canRead()) {
            error = "file does not have read permission";
            return false;
        }
        error = "";
        try {
            String xmlDataString = Files.readString(file.toPath());
            ParseableObject xmlData = new ParseableObject(xmlDataString);
            this.root.parse(xmlData);
            return true;
        }
        catch (IOException ex) {
            error = "Error reading file contents";
            return false;
        }
    }

    public boolean write(File file) {
        if (file.exists()) {
            if (!file.isFile()) {
                error = "specified path is not a file.";
                return false;
            }
            if (!file.canWrite()) {
                error = "file does not have write permission";
                return false;
            }
        }
        error = "";
        try {
            Files.write(file.toPath(), this.root.exportToString(0).getBytes(), new OpenOption[0]);
            return true;
        }
        catch (IOException ex) {
            error = ex.getMessage();
            return false;
        }
    }

    public static String getError() {
        return error;
    }

    public XMLDocument() {
    }

    public XMLDocument(String xmlDataString) {
        ParseableObject xmlData = new ParseableObject(xmlDataString);
        this.root.parse(xmlData);
    }

    public void addElement(XMLElement element) {
        this.root.addElement(element);
    }

    public boolean loadData(String data) {
        int headerEnd;
        if (data.length() == 0) {
            return false;
        }
        if (data.startsWith("<?xml version") && (headerEnd = data.indexOf("?>")) > 0) {
            data = data.substring(headerEnd + 1);
        }
        ParseableObject xmlData = new ParseableObject(data);
        return this.root.parse(xmlData);
    }

    public int getElementCount() {
        if (this.root.elements == null) {
            return 0;
        }
        return this.root.elements.size();
    }

    public XMLElement getElement(int index) {
        if (this.root.elements != null && this.root.elements.size() > index) {
            return this.root.elements.get(index);
        }
        return null;
    }

    public void removeElement(int index) {
        if (this.root.elements != null && this.root.elements.size() > index) {
            this.root.elements.remove(index);
        }
    }

    public XMLElement getRoot() {
        return this.root;
    }

    public String serialize() {
        return this.root.serialize();
    }

    static String parseValue(ParseableObject xmlData) {
        boolean bEnd = false;
        String outString = "";
        char QuoteChar = xmlData.data[xmlData.cIndex];
        while (xmlData.cIndex < xmlData.data.length) {
            if (xmlData.data[xmlData.cIndex] == QuoteChar) {
                boolean bl = bEnd = !bEnd;
                if (!bEnd) {
                    return outString;
                }
            } else if (xmlData.data[xmlData.cIndex] == '&') {
                outString = outString + XMLDocument.decodeEscape(xmlData);
            } else if (xmlData.data[xmlData.cIndex] != '<' || xmlData.data[xmlData.cIndex] != '&') {
                outString = outString + xmlData.data[xmlData.cIndex];
            }
            ++xmlData.cIndex;
        }
        return "";
    }

    class ParseableObject {
        int cIndex = 0;
        char[] data;

        public ParseableObject() {
        }

        public ParseableObject(String xmlString) {
            this.setDataString(xmlString);
        }

        public void setDataString(String xmlString) {
            this.data = (xmlString + "\u0000").toCharArray();
            this.cIndex = 0;
        }
    }
}

