/*
 * Decompiled with CFR 0.152.
 */
package BlockTree;

import BlockTree.NodeBlock;
import BlockTree.NodeFolder;
import BlockTree.NodeRoot;
import BlockTree.TreeUndoManager;
import GraphicTreeClass.GraphicTree;
import GraphicTreeClass.GraphicTreeCellEditor;
import GraphicTreeClass.GraphicTreeNode;
import SequenceEditorPanels.ExtensibleArray;
import Sequences.SequenceExportFormat;
import UndoRedo.Undoable;
import java.util.List;
import javax.swing.DropMode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import plot.MobileBlock;

public class BlocksTree
extends GraphicTree {
    private boolean changed = false;
    private final TreeUndoManager undoManager = new TreeUndoManager();

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public BlocksTree() {
        super(new NodeRoot());
        this.initTree();
    }

    public void clear() {
        this.setModel(new DefaultTreeModel(new NodeRoot(), false));
        this.undoManager.clear();
    }

    private void initTree() {
        this.setDropMode(DropMode.ON_OR_INSERT);
        this.setSelectionModel(4);
        this.setCellEditor(new GraphicTreeCellEditor(this, this.renderer));
    }

    @Override
    public void nodeCollapsed(GraphicTreeNode node) {
        node.expanded = false;
    }

    @Override
    public void nodeExpanded(GraphicTreeNode node) {
        node.expanded = true;
    }

    @Override
    public void nodeRightClicked(GraphicTreeNode node, int x, int y) {
    }

    @Override
    public void nodeLeftClicked(GraphicTreeNode node, int x, int y) {
    }

    @Override
    public void nodeDoubleClicked(GraphicTreeNode node) {
    }

    @Override
    public void nodeSelected(GraphicTreeNode node) {
    }

    @Override
    public void nodeChanged(GraphicTreeNode node) {
    }

    @Override
    public void nodeFilesDrop(GraphicTreeNode destNode, List fileList) {
    }

    public NodeFolder addFolder(String folderText) {
        NodeFolder node = new NodeFolder(folderText);
        this.addNode(node, this.getRoot());
        return node;
    }

    @Override
    public void addNode(GraphicTreeNode node, GraphicTreeNode parent) {
        this.addNode(node, parent, parent.getChildCount());
    }

    public void addNode(MobileBlock block) {
        this.addNode(block, this.getRoot(), this.getRoot().getChildCount());
    }

    public void addNode(MobileBlock block, GraphicTreeNode parent) {
        this.addNode(block, parent, parent.getChildCount());
    }

    public void addNode(MobileBlock block, GraphicTreeNode parent, int index) {
        this.addNode(new NodeBlock(block), parent, index);
    }

    @Override
    public void addNode(final GraphicTreeNode node, final GraphicTreeNode parent, final int index) {
        final DefaultTreeModel tmpModel = (DefaultTreeModel)this.getModel();
        final boolean b = this.isChanged();
        Undoable edit = new Undoable(){

            @Override
            public boolean undo() {
                tmpModel.removeNodeFromParent(node);
                BlocksTree.this.setChanged(b);
                return true;
            }

            @Override
            public boolean redo() {
                tmpModel.insertNodeInto(node, parent, index);
                BlocksTree.this.expandNode(parent);
                return true;
            }
        };
        this.undoManager.runEdit(edit);
    }

    public void addNode(final GraphicTreeNode[] nodes, final GraphicTreeNode parent, int index) {
        final DefaultTreeModel tmpModel = (DefaultTreeModel)this.getModel();
        final boolean b = this.isChanged();
        Undoable edit = new Undoable(){

            @Override
            public boolean undo() {
                for (GraphicTreeNode node : nodes) {
                    tmpModel.removeNodeFromParent(node);
                }
                BlocksTree.this.setChanged(b);
                return true;
            }

            @Override
            public boolean redo() {
                for (GraphicTreeNode node : nodes) {
                    tmpModel.insertNodeInto(node, parent, parent.getChildCount());
                }
                BlocksTree.this.expandNode(parent);
                return true;
            }
        };
        this.undoManager.runEdit(edit);
    }

    @Override
    public void removeNode(final GraphicTreeNode node) {
        if (node != null && node.getParent() != null) {
            final GraphicTreeNode parent = (GraphicTreeNode)node.getParent();
            final boolean b = this.isChanged();
            Undoable edit = new Undoable(){

                @Override
                public boolean undo() {
                    BlocksTree.this.addNode(node, parent, parent.getChildCount());
                    BlocksTree.this.setChanged(b);
                    return true;
                }

                @Override
                public boolean redo() {
                    ((DefaultTreeModel)BlocksTree.this.getModel()).removeNodeFromParent(node);
                    BlocksTree.this.setChanged(true);
                    return true;
                }
            };
            this.undoManager.runEdit(edit);
        }
    }

    @Override
    public void nodeNodesDrop(GraphicTreeNode destNode, GraphicTreeNode[] droppedNodes) {
        NodeFolder destFolder = destNode instanceof NodeFolder ? (NodeFolder)destNode : (NodeFolder)destNode.getParent();
        DefaultTreeModel tm = (DefaultTreeModel)this.getModel();
        for (GraphicTreeNode droppedNode : droppedNodes) {
            if (droppedNode == null) break;
            tm.removeNodeFromParent(droppedNode);
            tm.insertNodeInto(droppedNode, destFolder, destNode.getChildCount());
        }
    }

    @Override
    public void nodeRenamed(GraphicTreeNode node) {
    }

    public GraphicTreeNode[] getSelectedNodes() {
        TreePath[] paths;
        ExtensibleArray<GraphicTreeNode> outSCF = new ExtensibleArray<GraphicTreeNode>(GraphicTreeNode.class);
        for (TreePath path : paths = this.getSelectionPaths()) {
            outSCF.add((GraphicTreeNode)path.getLastPathComponent());
        }
        return outSCF.toArray();
    }

    public SequenceExportFormat[] getSelectedSEF() {
        ExtensibleArray<SequenceExportFormat> outSCF = new ExtensibleArray<SequenceExportFormat>(SequenceExportFormat.class);
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            return null;
        }
        for (TreePath path : paths) {
            GraphicTreeNode node = (GraphicTreeNode)path.getLastPathComponent();
            if (!(node instanceof NodeBlock)) continue;
            outSCF.add((SequenceExportFormat)((NodeBlock)node).getBlock().getItem());
        }
        return outSCF.toArray();
    }
}

