/*
 * Decompiled with CFR 0.152.
 */
package BaseClasses;

import UIRenderers.RenderedSliderUI;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;

public abstract class ThumbShapeRenderer {
    public static final ThumbShapeRenderer TRIANGLE_THUMB = new ThumbShapeRenderer(){

        @Override
        public Shape genShape(Rectangle thumbRect, RenderedSliderUI ui) {
            GeneralPath shape = new GeneralPath(0);
            if (ui.getSlider().getOrientation() == 1) {
                int x1 = thumbRect.x + 2;
                int x2 = thumbRect.x + thumbRect.width - 2;
                int height = thumbRect.height - 4;
                int y1 = thumbRect.y + 2;
                int y2 = y1 + height;
                if (ui.isDrawInverted()) {
                    shape.moveTo(x2, (y1 + y2) / 2);
                    shape.lineTo(x1, y1);
                    shape.lineTo(x1, y2);
                } else {
                    shape.moveTo(x1, (y1 + y2) / 2);
                    shape.lineTo(x2, y1);
                    shape.lineTo(x2, y2);
                }
            } else {
                int x1 = thumbRect.x + 2;
                int x2 = thumbRect.x + thumbRect.width - 2;
                int width = thumbRect.width - 4;
                int y1 = thumbRect.y + thumbRect.height / 2 - thumbRect.width / 3;
                int y2 = y1 + width;
                if (ui.isDrawInverted()) {
                    shape.moveTo((x1 + x2) / 2, y1);
                    shape.lineTo(x1, y2);
                    shape.lineTo(x2, y2);
                } else {
                    shape.moveTo((x1 + x2) / 2, y2);
                    shape.lineTo(x1, y1);
                    shape.lineTo(x2, y1);
                }
            }
            shape.closePath();
            return shape;
        }
    };
    public static final ThumbShapeRenderer DIAMOND_THUMB = new ThumbShapeRenderer(){

        @Override
        public Shape genShape(Rectangle thumbRect, RenderedSliderUI ui) {
            int x1 = thumbRect.x + 2;
            int x2 = thumbRect.x + thumbRect.width - 2;
            int height = thumbRect.height - 4;
            int y1 = thumbRect.y + 2;
            int y2 = y1 + height;
            int midY = (y1 + y2) / 2;
            int midX = (x1 + x2) / 2;
            GeneralPath shape = new GeneralPath(0);
            shape.moveTo(x1, midY);
            shape.lineTo(midX, y1);
            shape.lineTo(x2, midY);
            shape.lineTo(midX, y2);
            shape.closePath();
            return shape;
        }
    };
    public static final ThumbShapeRenderer CIRCLE_THUMB = new ThumbShapeRenderer(){

        @Override
        public Shape genShape(Rectangle thumbRect, RenderedSliderUI ui) {
            Arc2D.Double circle = new Arc2D.Double(thumbRect.x + 1, thumbRect.y + 1, thumbRect.width - 3, thumbRect.height - 3, 0.0, 360.0, 0);
            return circle;
        }
    };
    int x = 0;
    int y = 0;
    int wd = 0;
    int ht = 0;
    Shape shape = null;

    public Shape getShape(Rectangle thumbRect, RenderedSliderUI ui) {
        if (thumbRect.width == 0 || thumbRect.height == 0) {
            return null;
        }
        if (this.shape == null || thumbRect.width != this.wd || thumbRect.height != this.ht || thumbRect.x != this.x || thumbRect.y != this.y) {
            this.shape = this.genShape(thumbRect, ui);
            this.wd = thumbRect.width;
            this.ht = thumbRect.height;
            this.x = thumbRect.x;
            this.y = thumbRect.y;
        }
        return this.shape;
    }

    public abstract Shape genShape(Rectangle var1, RenderedSliderUI var2);
}

