/*
 * Decompiled with CFR 0.152.
 */
package BaseClasses;

import JMConstants.Constants;
import Renderers.BasicGradientRenderer;
import Renderers.BasicRenderer;
import Renderers.GalaxyRenderer;
import Renderers.GelRenderer;
import Renderers.GlossyRenderer;
import Renderers.JavTRenderer;
import Renderers.MetalRenderer;
import Renderers.MetallicRenderer;
import Renderers.OfficeXPRenderer;
import Renderers.Renderer;
import Renderers.ShineyRenderer;
import Renderers.VistaRenderer;
import java.awt.Color;
import java.beans.BeanProperty;
import javax.swing.JComponent;

public abstract class JMRenderedComponent
extends JComponent
implements Constants {
    protected Renderer renderer = null;
    protected boolean rounded = false;
    protected Constants.DEFAULTRENDERERS style = Constants.DEFAULTRENDERERS.Default;
    protected boolean showBorder = true;
    protected Color colorNormal;
    protected Color colorOver = this.colorNormal = Color.gray;
    protected Color colorPressed = this.colorNormal;
    protected Color colorSelected = this.colorNormal;
    protected Color colorBorder = this.colorNormal.darker();
    protected Color colorNormalText;
    protected Color colorOverText = this.colorNormalText = Color.black;
    protected Color colorPressedText = this.colorNormalText;
    protected Color colorSelectedText = this.colorNormalText;
    protected boolean showFocus = false;

    @BeanProperty(preferred=true, description="Sets whether the focus should be drawn.")
    public void setShowFocus(boolean show) {
        this.showFocus = show;
        this.updateRenderer();
    }

    public boolean isShowFocus() {
        return this.showFocus;
    }

    public boolean isRounded() {
        return this.rounded;
    }

    @BeanProperty(preferred=true, description="Sets whether the track and default thumb are rounded or rectangular.")
    public void setRounded(boolean rounded) {
        this.rounded = rounded;
        this.updateRenderer();
    }

    @BeanProperty(preferred=true, description="Sets the style of the track.")
    public void setStyle(Constants.DEFAULTRENDERERS style) {
        this.setRenderer(this.getRendererStyle(style));
        this.style = style;
    }

    protected Renderer getRendererStyle(Constants.DEFAULTRENDERERS style) {
        switch (style) {
            case Metallic: {
                return new MetallicRenderer(this);
            }
            case Metal: {
                return new MetalRenderer(this);
            }
            case JavT: {
                return new JavTRenderer(this);
            }
            case Gradient: {
                return new BasicGradientRenderer(this);
            }
            case Solid: {
                return new BasicRenderer(this);
            }
            case Gel: {
                return new GelRenderer(this);
            }
            case Glossy: {
                return new GlossyRenderer(this);
            }
            case Shiney: {
                return new ShineyRenderer(this);
            }
            case Galaxy: {
                return new GalaxyRenderer(this);
            }
            case OfficeXP: {
                return new OfficeXPRenderer(this);
            }
            case Vista: {
                return new VistaRenderer(this);
            }
        }
        return null;
    }

    public Constants.DEFAULTRENDERERS getStyle() {
        return this.style;
    }

    @BeanProperty(hidden=true, description="Sets the scrollbar track and border renderer.")
    public void setRenderer(Renderer renderer) {
        this.renderer = renderer;
        this.updateRenderer();
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    protected void updateRenderer() {
        if (this.renderer != null) {
            this.renderer.getColors().setColors(1, this.colorNormal, this.colorPressed, null, null, null, this.colorOver, null);
            this.renderer.getColors().setColors(2, this.colorBorder);
            this.renderer.getColors().setColors(0, this.colorNormalText, this.colorPressedText, null, null, null, this.colorOverText, null);
            this.renderer.setPaintBorder(this.showBorder);
            this.renderer.setRounded(this.rounded);
            this.renderer.setShowFocus(false);
            this.repaint();
        }
    }

    @BeanProperty(hidden=true)
    public void setColors(Color colorNormal, Color colorRollOver, Color colorPressed, Color colorBorder) {
        this.colorNormal = colorNormal;
        this.colorOver = colorRollOver;
        this.colorPressed = colorPressed;
        this.colorBorder = colorBorder;
        this.updateRenderer();
        this.repaint();
    }

    @BeanProperty(hidden=true)
    public void setColors(Color color) {
        this.colorNormal = color;
        this.colorOver = color;
        this.colorPressed = color;
        this.updateRenderer();
        this.repaint();
    }

    @BeanProperty(hidden=true)
    public void setTextColors(Color colorNormal, Color colorRollOver, Color colorPressed) {
        this.colorNormalText = colorNormal;
        this.colorOverText = colorRollOver;
        this.colorPressedText = colorPressed;
        this.updateRenderer();
        this.repaint();
    }

    @BeanProperty(preferred=true, description="Sets background color when the mouse is over the component.")
    public void setColorRollover(Color color) {
        this.colorOver = color;
        this.updateRenderer();
        this.repaint();
    }

    @BeanProperty(preferred=true, description="Sets background color when the mouse is pressed over the component.")
    public void setColorPressed(Color color) {
        this.colorPressed = color;
        this.updateRenderer();
        this.repaint();
    }

    @BeanProperty(preferred=true, description="Sets background color when the mouse is not the component.")
    public void setColorNormal(Color color) {
        if (color != null) {
            this.setForeground(color);
        } else {
            this.colorNormal = color;
        }
        this.updateRenderer();
        this.repaint();
    }

    @BeanProperty(preferred=true, description="Sets text color when the mouse is over the component.")
    public void setTextColorRollover(Color color) {
        this.colorOverText = color;
        this.updateRenderer();
        this.repaint();
    }

    @BeanProperty(preferred=true, description="Sets text color when the mouse is pressed over the component.")
    public void setTextColorPressed(Color color) {
        this.colorPressedText = color;
        this.updateRenderer();
        this.repaint();
    }

    @BeanProperty(preferred=true, description="Sets text color when the mouse is not the component.")
    public void setTextColorNormal(Color color) {
        this.setForeground(color);
    }

    @BeanProperty(preferred=true, description="Sets text color when the item is set as selected for objects that support this state.")
    public void setColorSelected(Color color) {
        this.colorSelected = color;
        this.updateRenderer();
        this.repaint();
    }

    @Override
    @BeanProperty(preferred=true, visualUpdate=true, description="The foreground color of the component.")
    public void setForeground(Color color) {
        this.colorNormalText = color;
        this.updateRenderer();
        if (color != null) {
            super.setForeground(color);
        } else {
            this.repaint();
        }
    }

    public Color getColorRollover() {
        return this.colorOver;
    }

    public Color getColorPressed() {
        return this.colorPressed;
    }

    public Color getColorSelected() {
        return this.colorSelected;
    }

    public Color getColorNormal() {
        return this.colorNormal;
    }

    public Color getTextColorRollover() {
        return this.colorOverText;
    }

    public Color getTextColorPressed() {
        return this.colorPressedText;
    }

    public Color getTextColorSelected() {
        return this.colorSelectedText;
    }

    public Color getTextColorNormal() {
        return this.colorNormalText;
    }

    public Color getBorderColor() {
        return this.colorBorder;
    }

    @BeanProperty(preferred=true, description="Sets the color of the border.")
    public void setBorderColor(Color color) {
        if (color != null) {
            this.colorBorder = color;
            this.updateRenderer();
        }
    }

    public boolean isShowBorder() {
        return this.showBorder;
    }

    @BeanProperty(preferred=true, description="Toggle the border.")
    public void setShowBorder(boolean show) {
        this.showBorder = show;
        this.updateRenderer();
    }

    static float scale(float value, float inputMin, float inputMax, float outputMin, float outputMax) {
        value = JMRenderedComponent.constrain(value, inputMin, inputMax);
        return (value - inputMin) / (inputMax - inputMin) * (outputMax - outputMin) + outputMin;
    }

    static float scale(int value, int inputMin, int inputMax, int outputMin, int outputMax) {
        value = JMRenderedComponent.constrain(value, inputMin, inputMax);
        return (float)(value - inputMin) / (float)(inputMax - inputMin) * (float)(outputMax - outputMin) + (float)outputMin;
    }

    static int constrain(int value, int min, int max) {
        return Math.min(Math.max(value, min), max);
    }

    static long constrain(long value, long min, long max) {
        return Math.min(Math.max(value, min), max);
    }

    static double constrain(double value, double min, double max) {
        return Math.min(Math.max(value, min), max);
    }

    static float constrain(float value, float min, float max) {
        return Math.min(Math.max(value, min), max);
    }
}

