/*
 * Decompiled with CFR 0.152.
 */
package BaseClasses;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JFrame;
import javax.swing.border.LineBorder;

public class FrameBorder
extends LineBorder {
    protected Color lineColorInactive;

    private static JFrame getParentFrame(Component c) {
        if (c == null) {
            return null;
        }
        if (c instanceof JFrame) {
            return (JFrame)c;
        }
        Container parent = c.getParent();
        if (parent == null) {
            return null;
        }
        return FrameBorder.getParentFrame(parent);
    }

    private static boolean isFrameActive(Component c) {
        JFrame parentFrame = FrameBorder.getParentFrame(c);
        return parentFrame != null ? parentFrame.isActive() : true;
    }

    protected Color getLineColor(Component c) {
        return FrameBorder.isFrameActive(c) ? this.lineColor : this.lineColorInactive;
    }

    public FrameBorder(Color color) {
        super(color);
        this.lineColorInactive = this.lineColor;
    }

    public FrameBorder(Color activeColor, Color inactiveColor) {
        super(activeColor);
        this.lineColorInactive = inactiveColor;
    }

    public FrameBorder(Color color, int size) {
        super(color, size);
        this.lineColorInactive = this.lineColor;
    }

    public FrameBorder(Color activeColor, Color inactiveColor, int size) {
        super(activeColor, size);
        this.lineColorInactive = inactiveColor;
    }

    public FrameBorder(Color color, int size, boolean rounded) {
        super(color, size, rounded);
        this.lineColorInactive = this.lineColor;
    }

    public FrameBorder(Color activeColor, Color inactiveColor, int size, boolean rounded) {
        super(activeColor, size, rounded);
        this.lineColorInactive = inactiveColor;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (this.thickness > 0 && g instanceof Graphics2D) {
            RectangularShape inner;
            RectangularShape outer;
            Graphics2D g2d = (Graphics2D)g;
            Color oldColor = g2d.getColor();
            Color bColor = this.getLineColor(c);
            g2d.setColor(bColor);
            int offs = this.thickness;
            int size = offs + offs;
            if (this.roundedCorners) {
                float arc = 0.2f * (float)offs;
                outer = new RoundRectangle2D.Float(x, y, width, height, offs, offs);
                inner = new RoundRectangle2D.Float(x + offs, y + offs, width - size, height - size, arc, arc);
            } else {
                outer = new Rectangle2D.Float(x, y, width, height);
                inner = new Rectangle2D.Float(x + offs, y + offs, width - size, height - size);
            }
            Path2D.Float path = new Path2D.Float(0);
            path.append(outer, false);
            path.append(inner, false);
            g2d.fill(path);
            g2d.setColor(oldColor);
        }
    }
}

