/*
 * Decompiled with CFR 0.152.
 */
package AlignmentTools;

import AlignmentTools.PairwiseAlignment;
import AlignmentTools.QuadAlignment;
import Sequences.Protein;

public class ProteinAlignment {
    static int[][] MBLOSUM45 = new int[][]{{5, 0, -1, -2, -1, -2, 0, -2, -1, 0, -1, -1, -1, -1, 0, -1, -1, -2, 1, 0, 0, 0, -2, 0, -2, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {-1, 0, 12, -3, -3, -2, -3, -3, -3, 0, -3, -2, -2, -2, 0, -4, -3, -3, -1, -1, 0, -1, -5, 0, -3, 0}, {-2, 0, -3, 7, 2, -4, -1, 0, -4, 0, 0, -3, -3, 2, 0, -1, 0, -1, 0, -1, 0, -3, -4, 0, -2, 0}, {-1, 0, -3, 2, 6, -3, -2, 0, -3, 0, 1, -2, -2, 0, 0, 0, 2, 0, 0, -1, 0, -3, -3, 0, -2, 0}, {-2, 0, -2, -4, -3, 8, -3, -2, 0, 0, -3, 1, 0, -2, 0, -3, -4, -2, -2, -1, 0, 0, 1, 0, 3, 0}, {0, 0, -3, -1, -2, -3, 7, -2, -4, 0, -2, -3, -2, 0, 0, -2, -2, -2, 0, -2, 0, -3, -2, 0, -3, 0}, {-2, 0, -3, 0, 0, -2, -2, 10, -3, 0, -1, -2, 0, 1, 0, -2, 1, 0, -1, -2, 0, -3, -3, 0, 2, 0}, {-1, 0, -3, -4, -3, 0, -4, -3, 5, 0, -3, 2, 2, -2, 0, -2, -2, -3, -2, -1, 0, 3, -2, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {-1, 0, -3, 0, 1, -3, -2, -1, -3, 0, 5, -3, -1, 0, 0, -1, 1, 3, -1, -1, 0, -2, -2, 0, -1, 0}, {-1, 0, -2, -3, -2, 1, -3, -2, 2, 0, -3, 5, 2, -3, 0, -3, -2, -2, -3, -1, 0, 1, -2, 0, 0, 0}, {-1, 0, -2, -3, -2, 0, -2, 0, 2, 0, -1, 2, 6, -2, 0, -2, 0, -1, -2, -1, 0, 1, -2, 0, 0, 0}, {-1, 0, -2, 2, 0, -2, 0, 1, -2, 0, 0, -3, -2, 6, 0, -2, 0, 0, 1, 0, 0, -3, -4, 0, -2, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {-1, 0, -4, -1, 0, -3, -2, -2, -2, 0, -1, -3, -2, -2, 0, 9, -1, -2, -1, -1, 0, -3, -3, 0, -3, 0}, {-1, 0, -3, 0, 2, -4, -2, 1, -2, 0, 1, -2, 0, 0, 0, -1, 6, 1, 0, -1, 0, -3, -2, 0, -1, 0}, {-2, 0, -3, -1, 0, -2, -2, 0, -3, 0, 3, -2, -1, 0, 0, -2, 1, 7, -1, -1, 0, -2, -2, 0, -1, 0}, {1, 0, -1, 0, 0, -2, 0, -1, -2, 0, -1, -3, -2, 1, 0, -1, 0, -1, 4, 2, 0, -1, -4, 0, -2, 0}, {0, 0, -1, -1, -1, -1, -2, -2, -1, 0, -1, -1, -1, 0, 0, -1, -1, -1, 2, 5, 0, 0, -3, 0, -1, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, -1, -3, -3, 0, -3, -3, 3, 0, -2, 1, 1, -3, 0, -3, -3, -2, -1, 0, 0, 5, -3, 0, -1, 0}, {-2, 0, -5, -4, -3, 1, -2, -3, -2, 0, -2, -2, -2, -4, 0, -3, -2, -2, -4, -3, 0, -3, 15, 0, 3, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {-2, 0, -3, -2, -2, 3, -3, 2, 0, 0, -1, 0, 0, -2, 0, -3, -1, -1, -2, -1, 0, -1, 3, 0, 8, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
    static int[][] MBLOSUM62 = new int[][]{{4, 0, 0, -2, -1, -2, 0, -2, -1, 0, -1, -1, -1, -2, 0, -1, -1, -1, 1, 0, 0, 0, -3, 0, -2, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 9, -3, -4, -2, -3, -3, -1, 0, -3, -1, -1, -3, 0, -3, -3, -3, -1, -1, 0, -1, -2, 0, -2, 0}, {-2, 0, -3, 6, 2, -3, -1, -1, -3, 0, -1, -4, -3, 1, 0, -1, 0, -2, 0, -1, 0, -3, -4, 0, -3, 0}, {-1, 0, -4, 2, 5, -3, -2, 0, -3, 0, 1, -3, -2, 0, 0, -1, 2, 0, 0, -1, 0, -2, -3, 0, -2, 0}, {-2, 0, -2, -3, -3, 6, -3, -1, 0, 0, -3, 0, 0, -3, 0, -4, -3, -3, -2, -2, 0, -1, 1, 0, 3, 0}, {0, 0, -3, -1, -2, -3, 6, -2, -4, 0, -2, -4, -3, 0, 0, -2, -2, -2, 0, -2, 0, -3, -2, 0, -3, 0}, {-2, 0, -3, -1, 0, -1, -2, 8, -3, 0, -1, -3, -2, 1, 0, -2, 0, 0, -1, -2, 0, -3, -2, 0, 2, 0}, {-1, 0, -1, -3, -3, 0, -4, -3, 4, 0, -3, 2, 1, -3, 0, -3, -3, -3, -2, -1, 0, 3, -3, 0, -1, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {-1, 0, -3, -1, 1, -3, -2, -1, -3, 0, 5, -2, -1, 0, 0, -1, 1, 2, 0, -1, 0, -2, -3, 0, -2, 0}, {-1, 0, -1, -4, -3, 0, -4, -3, 2, 0, -2, 4, 2, -3, 0, -3, -2, -2, -2, -1, 0, 1, -2, 0, -1, 0}, {-1, 0, -1, -3, -2, 0, -3, -2, 1, 0, -1, 2, 5, -2, 0, -2, 0, -1, -1, -1, 0, 1, -1, 0, -1, 0}, {-2, 0, -3, 1, 0, -3, 0, 1, -3, 0, 0, -3, -2, 6, 0, -2, 0, 0, 1, 0, 0, -3, -4, 0, -2, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {-1, 0, -3, -1, -1, -4, -2, -2, -3, 0, -1, -3, -2, -2, 0, 7, -1, -2, -1, -1, 0, -2, -4, 0, -3, 0}, {-1, 0, -3, 0, 2, -3, -2, 0, -3, 0, 1, -2, 0, 0, 0, -1, 5, 1, 0, -1, 0, -2, -2, 0, -1, 0}, {-1, 0, -3, -2, 0, -3, -2, 0, -3, 0, 2, -2, -1, 0, 0, -2, 1, 5, -1, -1, 0, -3, -3, 0, -2, 0}, {1, 0, -1, 0, 0, -2, 0, -1, -2, 0, 0, -2, -1, 1, 0, -1, 0, -1, 4, 1, 0, -2, -3, 0, -2, 0}, {0, 0, -1, -1, -1, -2, -2, -2, -1, 0, -1, -1, -1, 0, 0, -1, -1, -1, 1, 5, 0, 0, -2, 0, -2, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, -1, -3, -2, -1, -3, -3, 3, 0, -2, 1, 1, -3, 0, -2, -2, -3, -2, 0, 0, 4, -3, 0, -1, 0}, {-3, 0, -2, -4, -3, 1, -2, -2, -3, 0, -3, -2, -1, -4, 0, -4, -2, -3, -3, -2, 0, -3, 11, 0, 2, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {-2, 0, -2, -3, -2, 3, -3, 2, -1, 0, -2, -1, -1, -2, 0, -3, -1, -2, -2, -2, 0, -1, 2, 0, 7, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
    static int[][] MBLOSUM80 = new int[][]{{5, 0, -1, -2, -1, -3, 0, -2, -2, 0, -1, -2, -1, -2, 0, -1, -1, -2, 1, 0, 0, 0, -3, 0, -2, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {-1, 0, 9, -4, -5, -3, -4, -4, -2, 0, -4, -2, -2, -3, 0, -4, -4, -4, -2, -1, 0, -1, -3, 0, -3, 0}, {-2, 0, -4, 6, 1, -4, -2, -2, -4, 0, -1, -5, -4, 1, 0, -2, -1, -2, -1, -1, 0, -4, -6, 0, -4, 0}, {-1, 0, -5, 1, 6, -4, -3, 0, -4, 0, 1, -4, -2, -1, 0, -2, 2, -1, 0, -1, 0, -3, -4, 0, -3, 0}, {-3, 0, -3, -4, -4, 6, -4, -2, -1, 0, -4, 0, 0, -4, 0, -4, -4, -4, -3, -2, 0, -1, 0, 0, 3, 0}, {0, 0, -4, -2, -3, -4, 6, -3, -5, 0, -2, -4, -4, -1, 0, -3, -2, -3, -1, -2, 0, -4, -4, 0, -4, 0}, {-2, 0, -4, -2, 0, -2, -3, 8, -4, 0, -1, -3, -2, 0, 0, -3, 1, 0, -1, -2, 0, -4, -3, 0, 2, 0}, {-2, 0, -2, -4, -4, -1, -5, -4, 5, 0, -3, 1, 1, -4, 0, -4, -3, -3, -3, -1, 0, 3, -3, 0, -2, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {-1, 0, -4, -1, 1, -4, -2, -1, -3, 0, 5, -3, -2, 0, 0, -1, 1, 2, -1, -1, 0, -3, -4, 0, -3, 0}, {-2, 0, -2, -5, -4, 0, -4, -3, 1, 0, -3, 4, 2, -4, 0, -3, -3, -3, -3, -2, 0, 1, -2, 0, -2, 0}, {-1, 0, -2, -4, -2, 0, -4, -2, 1, 0, -2, 2, 6, -3, 0, -3, 0, -2, -2, -1, 0, 1, -2, 0, -2, 0}, {-2, 0, -3, 1, -1, -4, -1, 0, -4, 0, 0, -4, -3, 6, 0, -3, 0, -1, 0, 0, 0, -4, -4, 0, -3, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {-1, 0, -4, -2, -2, -4, -3, -3, -4, 0, -1, -3, -3, -3, 0, 8, -2, -2, -1, -2, 0, -3, -5, 0, -4, 0}, {-1, 0, -4, -1, 2, -4, -2, 1, -3, 0, 1, -3, 0, 0, 0, -2, 6, 1, 0, -1, 0, -3, -3, 0, -2, 0}, {-2, 0, -4, -2, -1, -4, -3, 0, -3, 0, 2, -3, -2, -1, 0, -2, 1, 6, -1, -1, 0, -3, -4, 0, -3, 0}, {1, 0, -2, -1, 0, -3, -1, -1, -3, 0, -1, -3, -2, 0, 0, -1, 0, -1, 5, 1, 0, -2, -4, 0, -2, 0}, {0, 0, -1, -1, -1, -2, -2, -2, -1, 0, -1, -2, -1, 0, 0, -2, -1, -1, 1, 5, 0, 0, -4, 0, -2, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, -1, -4, -3, -1, -4, -4, 3, 0, -3, 1, 1, -4, 0, -3, -3, -3, -2, 0, 0, 4, -3, 0, -2, 0}, {-3, 0, -3, -6, -4, 0, -4, -3, -3, 0, -4, -2, -2, -4, 0, -5, -3, -4, -4, -4, 0, -3, 11, 0, 2, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {-2, 0, -3, -4, -3, 3, -4, 2, -2, 0, -3, -2, -2, -3, 0, -4, -2, -3, -2, -2, 0, -2, 2, 0, 7, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
    static int[][] MPAM30 = new int[][]{{6, 0, -6, -3, -2, -8, -2, -7, -5, 0, -7, -6, -5, -4, 0, -2, -4, -7, 0, -1, 0, -2, -13, 0, -8, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {-6, 0, 10, -14, -14, -13, -9, -7, -6, 0, -14, -15, -13, -11, 0, -8, -14, -8, -3, -8, 0, -6, -15, 0, -4, 0}, {-3, 0, -14, 8, 2, -15, -3, -4, -7, 0, -4, -12, -11, 2, 0, -8, -2, -10, -4, -5, 0, -8, -15, 0, -11, 0}, {-2, 0, -14, 2, 8, -14, -4, -5, -5, 0, -4, -9, -7, -2, 0, -5, 1, -9, -4, -6, 0, -6, -17, 0, -8, 0}, {-8, 0, -13, -15, -14, 9, -9, -6, -2, 0, -14, -3, -4, -9, 0, -10, -13, -9, -6, -9, 0, -8, -4, 0, 2, 0}, {-2, 0, -9, -3, -4, -9, 6, -9, -11, 0, -7, -10, -8, -3, 0, -6, -7, -9, -2, -6, 0, -5, -15, 0, -14, 0}, {-7, 0, -7, -4, -5, -6, -9, 9, -9, 0, -6, -6, -10, 0, 0, -4, 1, -2, -6, -7, 0, -6, -7, 0, -3, 0}, {-5, 0, -6, -7, -5, -2, -11, -9, 8, 0, -6, -1, -1, -5, 0, -8, -8, -5, -7, -2, 0, 2, -14, 0, -6, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {-7, 0, -14, -4, -4, -14, -7, -6, -6, 0, 7, -8, -2, -1, 0, -6, -3, 0, -4, -3, 0, -9, -12, 0, -9, 0}, {-6, 0, -15, -12, -9, -3, -10, -6, -1, 0, -8, 7, 1, -7, 0, -7, -5, -8, -8, -7, 0, -2, -6, 0, -7, 0}, {-5, 0, -13, -11, -7, -4, -8, -10, -1, 0, -2, 1, 11, -9, 0, -8, -4, -4, -5, -4, 0, -1, -13, 0, -11, 0}, {-4, 0, -11, 2, -2, -9, -3, 0, -5, 0, -1, -7, -9, 8, 0, -6, -3, -6, 0, -2, 0, -8, -8, 0, -4, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {-2, 0, -8, -8, -5, -10, -6, -4, -8, 0, -6, -7, -8, -6, 0, 8, -3, -4, -2, -4, 0, -6, -14, 0, -13, 0}, {-4, 0, -14, -2, 1, -13, -7, 1, -8, 0, -3, -5, -4, -3, 0, -3, 8, -2, -5, -5, 0, -7, -13, 0, -12, 0}, {-7, 0, -8, -10, -9, -9, -9, -2, -5, 0, 0, -8, -4, -6, 0, -4, -2, 8, -3, -6, 0, -8, -2, 0, -10, 0}, {0, 0, -3, -4, -4, -6, -2, -6, -7, 0, -4, -8, -5, 0, 0, -2, -5, -3, 6, 0, 0, -6, -5, 0, -7, 0}, {-1, 0, -8, -5, -6, -9, -6, -7, -2, 0, -3, -7, -4, -2, 0, -4, -5, -6, 0, 7, 0, -3, -13, 0, -6, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {-2, 0, -6, -8, -6, -8, -5, -6, 2, 0, -9, -2, -1, -8, 0, -6, -7, -8, -6, -3, 0, 7, -15, 0, -7, 0}, {-13, 0, -15, -15, -17, -4, -15, -7, -14, 0, -12, -6, -13, -8, 0, -14, -13, -2, -5, -13, 0, -15, 13, 0, -5, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {-8, 0, -4, -11, -8, 2, -14, -3, -6, 0, -9, -7, -11, -4, 0, -13, -12, -10, -7, -6, 0, -7, -5, 0, 10, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
    static int[][] MPAM70 = new int[][]{{5, 0, -4, -1, -1, -6, 0, -4, -2, 0, -4, -4, -3, -2, 0, 0, -2, -4, 1, 1, 0, -1, -9, 0, -5, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {-4, 0, 9, -9, -9, -8, -6, -5, -4, 0, -9, -10, -9, -7, 0, -5, -9, -5, -1, -5, 0, -4, -11, 0, -2, 0}, {-1, 0, -9, 6, 3, -10, -1, -1, -5, 0, -2, -8, -7, 3, 0, -4, 0, -6, -1, -2, 0, -5, -10, 0, -7, 0}, {-1, 0, -9, 3, 6, -9, -2, -2, -4, 0, -2, -6, -4, 0, 0, -3, 2, -5, -2, -3, 0, -4, -11, 0, -6, 0}, {-6, 0, -8, -10, -9, 8, -7, -4, 0, 0, -9, -1, -2, -6, 0, -7, -9, -7, -4, -6, 0, -5, -2, 0, 4, 0}, {0, 0, -6, -1, -2, -7, 6, -6, -6, 0, -5, -7, -6, -1, 0, -3, -4, -6, 0, -3, 0, -3, -10, 0, -9, 0}, {-4, 0, -5, -1, -2, -4, -6, 8, -6, 0, -3, -4, -6, 1, 0, -2, 2, 0, -3, -4, 0, -4, -5, 0, -1, 0}, {-2, 0, -4, -5, -4, 0, -6, -6, 7, 0, -4, 1, 1, -3, 0, -5, -5, -3, -4, -1, 0, 3, -9, 0, -4, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {-4, 0, -9, -2, -2, -9, -5, -3, -4, 0, 6, -5, 0, 0, 0, -4, -1, 2, -2, -1, 0, -6, -7, 0, -7, 0}, {-4, 0, -10, -8, -6, -1, -7, -4, 1, 0, -5, 6, 2, -5, 0, -5, -3, -6, -6, -4, 0, 0, -4, 0, -4, 0}, {-3, 0, -9, -7, -4, -2, -6, -6, 1, 0, 0, 2, 10, -5, 0, -5, -2, -2, -3, -2, 0, 0, -8, 0, -7, 0}, {-2, 0, -7, 3, 0, -6, -1, 1, -3, 0, 0, -5, -5, 6, 0, -3, -1, -3, 1, 0, 0, -5, -6, 0, -3, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, -5, -4, -3, -7, -3, -2, -5, 0, -4, -5, -5, -3, 0, 7, -1, -2, 0, -2, 0, -3, -9, 0, -9, 0}, {-2, 0, -9, 0, 2, -9, -4, 2, -5, 0, -1, -3, -2, -1, 0, -1, 7, 0, -3, -3, 0, -4, -8, 0, -8, 0}, {-4, 0, -5, -6, -5, -7, -6, 0, -3, 0, 2, -6, -2, -3, 0, -2, 0, 8, -1, -4, 0, -5, 0, 0, -7, 0}, {1, 0, -1, -1, -2, -4, 0, -3, -4, 0, -2, -6, -3, 1, 0, 0, -3, -1, 5, 2, 0, -3, -3, 0, -5, 0}, {1, 0, -5, -2, -3, -6, -3, -4, -1, 0, -1, -4, -2, 0, 0, -2, -3, -4, 2, 6, 0, -1, -8, 0, -4, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {-1, 0, -4, -5, -4, -5, -3, -4, 3, 0, -6, 0, 0, -5, 0, -3, -4, -5, -3, -1, 0, 6, -10, 0, -5, 0}, {-9, 0, -11, -10, -11, -2, -10, -5, -9, 0, -7, -4, -8, -6, 0, -9, -8, 0, -3, -8, 0, -10, 13, 0, -3, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {-5, 0, -2, -7, -6, 4, -9, -1, -4, 0, -7, -4, -7, -3, 0, -9, -8, -7, -5, -4, 0, -5, -3, 0, 9, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
    public static final int PAM30 = 0;
    public static final int PAM70 = 1;
    public static final int BLOSUM80 = 2;
    public static final int BLOSUM62 = 3;
    public static final int BLOSUM45 = 4;
    static int score = 0;
    static String alignedQueryString = null;
    static String alignedReferenceString = null;

    public static int getScore() {
        return score;
    }

    public static String getAlignedQuery() {
        return alignedQueryString;
    }

    public static String getAlignedReference() {
        return alignedReferenceString;
    }

    public static boolean align(String protein1, String protein2, int matrix) {
        return ProteinAlignment.align(protein1, protein2, matrix, false);
    }

    public static boolean align(String protein1, String protein2, int matrix, boolean convertTerminalGapsToSpaces) {
        return ProteinAlignment.align(protein1, protein2, matrix, -2, 0, 0, false);
    }

    public static boolean align(String protein1, String protein2, int matrix, int gapPenalty, int beginGapPenalty, int endGapPenalty, boolean convertTerminalGapsToSpaces) {
        ScoreSetP scoreSet;
        switch (matrix) {
            case 0: {
                scoreSet = new ScoreSetP(MPAM30);
                break;
            }
            case 1: {
                scoreSet = new ScoreSetP(MPAM70);
                break;
            }
            case 2: {
                scoreSet = new ScoreSetP(MBLOSUM80);
                break;
            }
            case 3: {
                scoreSet = new ScoreSetP(MBLOSUM62);
                break;
            }
            case 4: {
                scoreSet = new ScoreSetP(MBLOSUM45);
                break;
            }
            default: {
                return false;
            }
        }
        scoreSet.gap = gapPenalty;
        scoreSet.beginGap = beginGapPenalty;
        scoreSet.endGap = endGapPenalty;
        char[] fProtein1 = Protein.FilterSequence(protein1.toUpperCase()).toCharArray();
        char[] fProtein2 = Protein.FilterSequence(protein2.toUpperCase()).toCharArray();
        int tmpScore = PairwiseAlignment.score;
        String tmpAlignedQueryString = PairwiseAlignment.alignedQueryString;
        String tmpAlignedReferenceString = PairwiseAlignment.alignedReferenceString;
        boolean retVal = PairwiseAlignment.align(fProtein1, fProtein2, scoreSet, convertTerminalGapsToSpaces);
        score = PairwiseAlignment.score;
        alignedQueryString = PairwiseAlignment.alignedQueryString;
        alignedReferenceString = PairwiseAlignment.alignedReferenceString;
        PairwiseAlignment.score = tmpScore;
        PairwiseAlignment.alignedQueryString = tmpAlignedQueryString;
        PairwiseAlignment.alignedReferenceString = tmpAlignedReferenceString;
        return retVal;
    }

    static class ScoreSetP
    extends QuadAlignment.ScoreSet {
        int[][] matrix;

        public ScoreSetP(int[][] matrix) {
            this.matrix = matrix;
        }

        @Override
        public int getScore(char r1, char r2) {
            return this.matrix[r1 - 65][r2 - 65];
        }
    }
}

