/*
 * Decompiled with CFR 0.152.
 */
package Tools;

import DocumentFilters.DocumentAllowedKeyFilter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigInteger;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.text.AbstractDocument;
import javax.swing.text.DocumentFilter;

class MCalc
extends JFrame {
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JLabel lblTT;
    private JTextField txtAmount1;
    private JTextField txtAmount2;
    private JTextField txtConc1;
    private JTextField txtConc2;
    private JTextField txtRatio;
    private JTextField txtSize1;
    private JTextField txtSize2;
    private JTextField txtVol1;
    private JTextField txtVol2;

    public MCalc() {
        this.initComponents();
        ((AbstractDocument)this.txtSize1.getDocument()).setDocumentFilter((DocumentFilter)DocumentAllowedKeyFilter.NumberFilter);
        ((AbstractDocument)this.txtSize2.getDocument()).setDocumentFilter((DocumentFilter)DocumentAllowedKeyFilter.NumberFilter);
        ((AbstractDocument)this.txtAmount1.getDocument()).setDocumentFilter((DocumentFilter)DocumentAllowedKeyFilter.NumberFilter);
        FocusListener fl = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                ((JTextField)e.getComponent()).selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
                MCalc.this.update();
            }
        };
        MouseListener ml = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                MCalc.this.lblTT.setText(((JTextField)e.getSource()).getToolTipText());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                MCalc.this.lblTT.setText("");
            }
        };
        this.txtSize1.addMouseListener(ml);
        this.txtSize2.addMouseListener(ml);
        this.txtVol1.addMouseListener(ml);
        this.txtVol2.addMouseListener(ml);
        this.txtConc1.addMouseListener(ml);
        this.txtConc2.addMouseListener(ml);
        this.txtAmount1.addMouseListener(ml);
        this.txtAmount2.addMouseListener(ml);
        this.txtRatio.addMouseListener(ml);
        this.txtSize1.addFocusListener(fl);
        this.txtSize2.addFocusListener(fl);
        this.txtVol1.addFocusListener(fl);
        this.txtVol2.addFocusListener(fl);
        this.txtConc1.addFocusListener(fl);
        this.txtConc2.addFocusListener(fl);
        this.txtAmount1.addFocusListener(fl);
        this.txtRatio.addFocusListener(fl);
        this.txtSize1.requestFocus();
        this.update();
        this.setLocationRelativeTo(null);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.txtSize1 = new JTextField();
        this.txtSize2 = new JTextField();
        this.jLabel3 = new JLabel();
        this.txtAmount1 = new JTextField();
        this.jLabel4 = new JLabel();
        this.txtAmount2 = new JTextField();
        this.txtRatio = new JTextField();
        this.jLabel5 = new JLabel();
        this.txtConc1 = new JTextField();
        this.jLabel6 = new JLabel();
        this.txtConc2 = new JTextField();
        this.jLabel7 = new JLabel();
        this.txtVol1 = new JTextField();
        this.txtVol2 = new JTextField();
        this.lblTT = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Molarity Calculator");
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText("Fragment 1");
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText("Fragment 2");
        this.txtSize1.setHorizontalAlignment(0);
        this.txtSize1.setText("1000");
        this.txtSize1.setToolTipText("*Input* Size in bp of fragment 1.");
        this.txtSize2.setHorizontalAlignment(0);
        this.txtSize2.setText("200");
        this.txtSize2.setToolTipText("*Input* Size in bp of fragment 2.");
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel3.setText("Size (bp)");
        this.txtAmount1.setHorizontalAlignment(0);
        this.txtAmount1.setText("200");
        this.txtAmount1.setToolTipText("*Input* Amount of fragment 1 needed in ng.");
        this.jLabel4.setHorizontalAlignment(0);
        this.jLabel4.setText("ng Needed");
        this.txtAmount2.setEditable(false);
        this.txtAmount2.setHorizontalAlignment(0);
        this.txtAmount2.setText("200");
        this.txtAmount2.setToolTipText("*Calculated* Amount of fragment 2 needed in ng.");
        this.txtRatio.setHorizontalAlignment(0);
        this.txtRatio.setText("2");
        this.txtRatio.setToolTipText("*Input* Ratio needed of fragment 2 to fragment 1");
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText("Frag 2 : Frag 1 ratio");
        this.txtConc1.setHorizontalAlignment(0);
        this.txtConc1.setText("200");
        this.txtConc1.setToolTipText("*Input* Concentration in ng/ul of fragment 1.");
        this.jLabel6.setHorizontalAlignment(0);
        this.jLabel6.setText("[] (ng/uL)");
        this.txtConc2.setHorizontalAlignment(0);
        this.txtConc2.setText("200");
        this.txtConc2.setToolTipText("*Input* Concentration in ng/ul of fragment 2.");
        this.jLabel7.setHorizontalAlignment(0);
        this.jLabel7.setText("uL Needed");
        this.txtVol1.setEditable(false);
        this.txtVol1.setHorizontalAlignment(0);
        this.txtVol1.setText("200");
        this.txtVol1.setToolTipText("*Calculated* Volume of fragment 1 needed in uL.");
        this.txtVol2.setEditable(false);
        this.txtVol2.setHorizontalAlignment(0);
        this.txtVol2.setText("200");
        this.txtVol2.setToolTipText("*Calculated* Volume of fragment 2 needed in uL.");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblTT, -1, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel5, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE).addComponent(this.txtSize1, -2, 71, -2)).addComponent(this.txtRatio, -2, 71, -2).addComponent(this.txtSize2, -2, 71, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.txtConc1).addComponent(this.jLabel6, -2, 71, -2)).addComponent(this.txtConc2, -2, 71, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.txtAmount1).addComponent(this.jLabel4, -2, 71, -2)).addComponent(this.txtAmount2, -2, 71, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.txtVol1).addComponent(this.jLabel7, -2, 71, -2)).addComponent(this.txtVol2, -2, 71, -2)).addContainerGap(-1, Short.MAX_VALUE)))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel6, -2, 32, -2).addGap(2, 2, 2).addComponent(this.txtConc1, -2, 32, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel4, -2, 32, -2).addGap(2, 2, 2).addComponent(this.txtAmount1, -2, 32, -2))).addGap(56, 56, 56).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtAmount2, -2, 32, -2).addComponent(this.txtConc2, -2, 32, -2))).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(48, 48, 48).addComponent(this.jLabel1)).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3, -2, 32, -2).addGap(2, 2, 2).addComponent(this.txtSize1, -2, 32, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.txtRatio, -2, 32, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.txtSize2, -2, 32, -2)))).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel7, -2, 32, -2).addGap(2, 2, 2).addComponent(this.txtVol1, -2, 32, -2).addGap(56, 56, 56).addComponent(this.txtVol2, -2, 32, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblTT, -1, 18, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0)));
        this.pack();
    }

    void update() {
        boolean bigInt;
        String ss1 = this.txtSize1.getText();
        String ss2 = this.txtSize2.getText();
        String sc1 = this.txtConc1.getText();
        String sc2 = this.txtConc2.getText();
        String sa1 = this.txtAmount1.getText();
        String sr = this.txtRatio.getText();
        if (ss1.length() == 0) {
            this.txtSize1.setText("0");
        }
        if (ss2.length() == 0) {
            this.txtSize2.setText("0");
        }
        if (sc1.length() == 0) {
            this.txtSize1.setText("0");
        }
        if (sc2.length() == 0) {
            this.txtSize2.setText("0");
        }
        if (sa1.length() == 0) {
            this.txtAmount1.setText("0");
        }
        if (sr.length() == 0) {
            this.txtAmount1.setText("1");
        }
        if (!(bigInt = false)) {
            double size1 = Double.parseDouble(this.txtSize1.getText());
            double size2 = Double.parseDouble(this.txtSize2.getText());
            double conc1 = Double.parseDouble(this.txtConc1.getText());
            double conc2 = Double.parseDouble(this.txtConc2.getText());
            double ng1 = Double.parseDouble(this.txtAmount1.getText());
            double ratio = Double.parseDouble(this.txtRatio.getText());
            if (size1 > 0.0 && size2 > 0.0 && ng1 > 0.0) {
                double ng2 = ng1 * size2 / size1 * ratio;
                double vol1 = ng1 / conc1;
                double vol2 = ng2 / conc2;
                this.txtAmount2.setText("" + ng2);
                this.txtVol2.setText("" + vol2);
                this.txtVol1.setText("" + vol1);
            } else {
                this.txtAmount2.setText("0");
                this.txtVol2.setText("0");
                this.txtVol1.setText("0");
            }
        } else {
            BigInteger size1 = new BigInteger(this.txtSize1.getText());
            BigInteger size2 = new BigInteger(this.txtSize2.getText());
            BigInteger conc1 = new BigInteger(this.txtConc1.getText());
            BigInteger conc2 = new BigInteger(this.txtConc2.getText());
            BigInteger ng1 = new BigInteger(this.txtAmount1.getText());
            BigInteger ratio = new BigInteger(this.txtRatio.getText());
            if (size1.intValue() > 0 && size2.intValue() > 0 && ng1.intValue() > 0) {
                BigInteger ng2 = ng1.multiply(size2).divide(size1).multiply(ratio).divide(conc2);
                BigInteger v2 = ng2.divide(conc2);
                BigInteger v1 = ng1.divide(conc1);
                this.txtAmount2.setText("" + ng2.floatValue());
                this.txtVol2.setText("" + v2.floatValue());
                this.txtVol1.setText("" + v1.floatValue());
            } else {
                this.txtAmount2.setText("0");
                this.txtVol2.setText("0");
                this.txtVol1.setText("0");
            }
        }
    }
}

