/*
 * Decompiled with CFR 0.152.
 */
package SeqTools;

import Clipboards.ClipBoard;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import javax.swing.JOptionPane;
import plot.PLOTJ;
import plot.PLOTJPlugin;

public class SeqsToMutation
extends PLOTJPlugin {
    String iconPath = "/icons/DNA.png";

    public SeqsToMutation() {
        this.setName("Compare Sequences");
        this.setDescription("Compares 2 same length amino acid sequences and copies the mutations between the two to the clipboard");
        this.setIcon(this.iconPath);
    }

    public void run() {
        PLOTJ instance = PLOTJ.getActiveInstance();
        String seq1 = JOptionPane.showInputDialog((Component)instance, "Enter first AA sequence", "Enter 1st AA sequence", -1);
        if (seq1 == null || seq1.length() == 0) {
            return;
        }
        String seq2 = JOptionPane.showInputDialog((Component)instance, "Enter second AA sequence", "Enter 2nd AA sequence", -1);
        if (seq2 == null || seq2.length() == 0) {
            return;
        }
        if (seq1.length() != seq2.length()) {
            JOptionPane.showMessageDialog((Component)instance, "Sequences must be the same length");
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (int x = 0; x < seq1.length(); ++x) {
            String s2;
            String s1 = seq1.substring(x, x + 1);
            if (s1.equals(s2 = seq2.substring(x, x + 1))) continue;
            if (x > 0) {
                sb.append("\n");
            }
            sb.append("p.").append(s1).append(x + 1).append(s2);
        }
        String fasta = sb.toString();
        ClipBoard cb = new ClipBoard();
        StringSelection outData = new StringSelection(fasta);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(outData, (ClipboardOwner)cb);
        JOptionPane.showMessageDialog((Component)instance, "Mutations have been copied to the clipboard");
    }
}

